/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.classtype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpClassTypeSuperclassHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpClassTypeSuperclassHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long clazzId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo ci = this.state.classRefIdHolder().objectById(clazzId);
            if (ci == null) {
                return 20;
            }
            if (!ci.isClass()) {
                return 21;
            }
            ClassInfoImpl cii = (ClassInfoImpl)ci;
            if ("Ljava/lang/Object;".equals(ci.signature())) {
                output.writeLong(0L);
            } else if (cii.superclassSignature() != null) {
                ci = this.state.classInfoLoader().classInfoBySignature(cii.superclassSignature());
                output.writeLong(ci.refId());
            } else {
                return 21;
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 3;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ClassType(3).Superclass(1)";
    }
}

