/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import org.robovm.debugger.utils.DataUtils;
import org.robovm.debugger.utils.bytebuffer.DataBuffer;
import org.robovm.debugger.utils.bytebuffer.DataByteBufferReader;

public interface DataBufferReader
extends DataBuffer {
    public static DataBufferReader wrap(byte[] readBytes) {
        return new DataByteBufferReader(readBytes);
    }

    public static DataBufferReader wrap(byte[] readBytes, boolean is64Bit) {
        return new DataByteBufferReader(readBytes, is64Bit);
    }

    default public void expects(int bytes) {
        if (this.remaining() < bytes) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public DataBufferReader setPosition(long var1);

    public byte readByte();

    default public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public short readInt16();

    default public int readUnsignedInt16() {
        return Short.toUnsignedInt(this.readInt16());
    }

    default public char readChar16() {
        return (char)this.readInt16();
    }

    public int readInt32();

    default public long readUnsignedInt32() {
        return Integer.toUnsignedLong(this.readInt32());
    }

    public long readLong();

    public float readFloat();

    public double readDouble();

    default public void readBytes(byte[] dst, int offset, int length) {
        if (this.hasArray()) {
            this.expects(length);
            System.arraycopy(this.array(), this.arrayPositionOffset(), dst, offset, length);
        } else {
            while (length-- > 0) {
                dst[offset++] = this.readByte();
            }
        }
    }

    default public void readBytes(byte[] array) {
        this.readBytes(array, 0, array.length);
    }

    default public byte[] readBytes() {
        return this.readBytes(this.remaining());
    }

    default public byte[] readBytes(int numBytes) {
        if (numBytes == 0) {
            throw new IllegalArgumentException("Cant read zero number of bytes!");
        }
        byte[] res = new byte[numBytes];
        this.readBytes(res);
        return res;
    }

    default public String readStringZ() {
        this.expects(1);
        if (this.hasArray()) {
            int pos = this.arrayPositionOffset();
            byte[] array = this.array();
            for (int remaining = this.remaining(); remaining > 0 && array[pos] != 0; --remaining) {
                ++pos;
            }
            return new String(array, this.arrayPositionOffset(), pos - this.arrayPositionOffset(), StandardCharsets.US_ASCII);
        }
        StringBuilder sb = new StringBuilder();
        byte b = this.readByte();
        while (b != 0) {
            sb.append((char)b);
            b = this.readByte();
        }
        return sb.toString();
    }

    default public String readStringZ(long at) {
        long savedPosition = this.position();
        this.setPosition(at);
        String s = this.readStringZ();
        this.setPosition(savedPosition);
        return s;
    }

    default public String readString(int size) {
        int stringStartOffset;
        byte[] stringBytes;
        long savedPosition = this.position();
        if (this.hasArray()) {
            this.expects(size);
            stringBytes = this.array();
            stringStartOffset = this.arrayPositionOffset();
        } else {
            stringBytes = new byte[size];
            stringStartOffset = 0;
            this.readBytes(stringBytes);
        }
        int strLen = size;
        int i = 0;
        int offset = stringStartOffset;
        while (i < size) {
            if (stringBytes[offset] == 0) {
                strLen = i;
                break;
            }
            ++i;
            ++offset;
        }
        String res = new String(stringBytes, stringStartOffset, strLen, StandardCharsets.UTF_8);
        this.setPosition(savedPosition + (long)size);
        return res;
    }

    default public String readString() {
        if (!this.hasRemaining()) {
            return "";
        }
        return this.readString(this.remaining());
    }

    default public String readStringWithLen() {
        int stringLen = this.readInt32();
        if (stringLen == 0) {
            return "";
        }
        return this.readString(stringLen);
    }

    default public long readPointer() {
        return this.readPointer(false);
    }

    default public long readPointer(boolean aligned) {
        long alignedPosition;
        long savedPosition;
        if (aligned && (savedPosition = this.position()) != (alignedPosition = DataUtils.align(savedPosition, this.pointerSize()))) {
            this.setPosition(alignedPosition);
        }
        return this.is64bit() ? this.readLong() : this.readUnsignedInt32();
    }

    default public void skip(int bytesToSkip) {
        this.setPosition(this.position() + (long)bytesToSkip);
    }

    default public void readToStream(OutputStream os) throws IOException {
        this.readToStream(os, this.remaining());
    }

    default public void dumpToOutputStream(OutputStream os) throws IOException {
        this.readToStream(os, this.bottomLimit(), this.size());
    }

    default public void readToStream(OutputStream os, int count) throws IOException {
        this.readToStream(os, this.position(), count);
    }

    default public void readToStream(OutputStream os, long position, int count) throws IOException {
        this.setPosition(position);
        this.expects(count);
        if (this.hasArray()) {
            os.write(this.array(), this.arrayPositionOffset(), count);
            this.setPosition(position + (long)count);
        } else {
            int read;
            byte[] buffer = new byte[Math.min(1024, count)];
            for (int remaining = count; remaining > 0; remaining -= read) {
                read = Math.min(remaining, buffer.length);
                this.readBytes(read);
                os.write(buffer, 0, read);
            }
        }
    }

    public DataBufferReader sliceAt(long var1, int var3, long var4, boolean var6);

    default public DataBufferReader sliceAt(long pos, int size, boolean as64bit) {
        return this.sliceAt(pos, size, 0L, as64bit);
    }

    default public DataBufferReader sliceAt(long pos, int size) {
        return this.sliceAt(pos, size, this.is64bit());
    }

    default public DataBufferReader slice(int size) {
        return this.sliceAt(this.position(), size);
    }

    default public DataBufferReader slice() {
        return this.sliceAt(this.position(), this.remaining());
    }

    default public DataBufferReader resetReader() {
        this.reset();
        return this;
    }
}

