/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.structs;

import org.robovm.debugger.utils.bytebuffer.DataBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class NList {
    private long n_strx;
    private byte n_type;
    private byte n_sect;
    private int n_desc;
    private long n_value;
    private static DataBufferArrayReader.ObjectReader<NList> objectReader32 = (reader, object) -> object == null ? new NList().read32(reader) : object.read32(reader);
    private static DataBufferArrayReader.ObjectReader<NList> objectReader64 = (reader, object) -> object == null ? new NList().read64(reader) : object.read64(reader);

    private NList read64(DataBufferReader reader) {
        this.n_strx = reader.readUnsignedInt32();
        this.n_type = reader.readByte();
        this.n_sect = reader.readByte();
        this.n_desc = reader.readUnsignedInt16();
        this.n_value = reader.readLong();
        return this;
    }

    private NList read32(DataBufferReader reader) {
        this.n_strx = reader.readUnsignedInt32();
        this.n_type = reader.readByte();
        this.n_sect = reader.readByte();
        this.n_desc = reader.readUnsignedInt16();
        this.n_value = reader.readUnsignedInt32();
        return this;
    }

    public long n_strx() {
        return this.n_strx;
    }

    public byte n_type() {
        return this.n_type;
    }

    public byte n_sect() {
        return this.n_sect;
    }

    public int n_desc() {
        return this.n_desc;
    }

    public long n_value() {
        return this.n_value;
    }

    public boolean isTypeStab() {
        return (this.n_type & 0xE0) != 0;
    }

    public boolean isTypeStabGlobalSymb() {
        return this.n_type == 32;
    }

    public boolean isTypePrivateExternal() {
        return (this.n_type & 0x10) != 0;
    }

    public boolean isTypeExternal() {
        return (this.n_type & 1) != 0;
    }

    public boolean isTypeUndfined() {
        return (this.n_type & 0xE) == 0;
    }

    public boolean isTypeAbsolute() {
        return (this.n_type & 0xE) == 2;
    }

    public boolean isTypeSectDefined() {
        return (this.n_type & 0xE) == 14;
    }

    public boolean isTypePreboundUndefined() {
        return (this.n_type & 0xE) == 12;
    }

    public boolean isTypeIndirect() {
        return (this.n_type & 0xE) == 10;
    }

    public static DataBufferArrayReader.ObjectReader<NList> OBJECT_READER(boolean is64b) {
        return is64b ? objectReader64 : objectReader32;
    }

    public static int ITEM_SIZE(boolean is64b) {
        return is64b ? 16 : 12;
    }
}

