/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefLikeType;
import soot.ShortType;
import soot.Type;
import soot.VoidType;
import soot.jimple.Jimple;

public class LocalGenerator {
    private final Body body;
    private transient Set<String> localNames = null;
    private int tempInt = -1;
    private int tempVoid = -1;
    private int tempBoolean = -1;
    private int tempLong = -1;
    private int tempDouble = -1;
    private int tempFloat = -1;
    private int tempRefLikeType = -1;
    private int tempByte = -1;
    private int tempShort = -1;
    private int tempChar = -1;

    public LocalGenerator(Body b) {
        this.body = b;
    }

    private boolean bodyContainsLocal(String name) {
        return this.localNames.contains(name);
    }

    private void initLocalNames() {
        this.localNames = new HashSet<String>();
        Iterator<Local> it = this.body.getLocals().iterator();
        while (it.hasNext()) {
            this.localNames.add(it.next().getName());
        }
    }

    public Local generateLocal(Type type) {
        this.initLocalNames();
        String name = "v";
        if (type instanceof IntType) {
            while (this.bodyContainsLocal(name = this.nextIntName())) {
            }
        } else if (type instanceof ByteType) {
            while (this.bodyContainsLocal(name = this.nextByteName())) {
            }
        } else if (type instanceof ShortType) {
            while (this.bodyContainsLocal(name = this.nextShortName())) {
            }
        } else if (type instanceof BooleanType) {
            while (this.bodyContainsLocal(name = this.nextBooleanName())) {
            }
        } else if (type instanceof VoidType) {
            while (this.bodyContainsLocal(name = this.nextVoidName())) {
            }
        } else if (type instanceof CharType) {
            while (this.bodyContainsLocal(name = this.nextCharName())) {
            }
            type = CharType.v();
        } else if (type instanceof DoubleType) {
            while (this.bodyContainsLocal(name = this.nextDoubleName())) {
            }
        } else if (type instanceof FloatType) {
            while (this.bodyContainsLocal(name = this.nextFloatName())) {
            }
        } else if (type instanceof LongType) {
            while (this.bodyContainsLocal(name = this.nextLongName())) {
            }
        } else if (type instanceof RefLikeType) {
            while (this.bodyContainsLocal(name = this.nextRefLikeTypeName())) {
            }
        } else {
            this.localNames = null;
            throw new RuntimeException("Unhandled Type of Local variable to Generate - Not Implemented");
        }
        this.localNames = null;
        return this.createLocal(name, type);
    }

    private String nextIntName() {
        ++this.tempInt;
        return "$i" + this.tempInt;
    }

    private String nextCharName() {
        ++this.tempChar;
        return "$c" + this.tempChar;
    }

    private String nextVoidName() {
        ++this.tempVoid;
        return "$v" + this.tempVoid;
    }

    private String nextByteName() {
        ++this.tempByte;
        return "$b" + this.tempByte;
    }

    private String nextShortName() {
        ++this.tempShort;
        return "$s" + this.tempShort;
    }

    private String nextBooleanName() {
        ++this.tempBoolean;
        return "$z" + this.tempBoolean;
    }

    private String nextDoubleName() {
        ++this.tempDouble;
        return "$d" + this.tempDouble;
    }

    private String nextFloatName() {
        ++this.tempFloat;
        return "$f" + this.tempFloat;
    }

    private String nextLongName() {
        ++this.tempLong;
        return "$l" + this.tempLong;
    }

    private String nextRefLikeTypeName() {
        ++this.tempRefLikeType;
        return "$r" + this.tempRefLikeType;
    }

    private Local createLocal(String name, Type sootType) {
        Local sootLocal = Jimple.v().newLocal(name, sootType);
        this.body.getLocals().add(sootLocal);
        return sootLocal;
    }
}

