/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Iterator;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Tag;

public class VisibilityAnnotationTag
implements Tag {
    private int visibility;
    private ArrayList<AnnotationTag> annotations;

    public VisibilityAnnotationTag(int vis) {
        this.visibility = vis;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Visibility Annotation: level: ");
        switch (this.visibility) {
            case 1: {
                sb.append("CLASS (runtime-invisible)");
                break;
            }
            case 0: {
                sb.append("RUNTIME (runtime-visible)");
                break;
            }
            case 2: {
                sb.append("SOURCE");
            }
        }
        sb.append("\n Annotations:");
        if (this.annotations != null) {
            Iterator<AnnotationTag> it = this.annotations.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                sb.append(it.next().toString());
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String getName() {
        return "VisibilityAnnotationTag";
    }

    public String getInfo() {
        return "VisibilityAnnotation";
    }

    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public byte[] getValue() {
        throw new RuntimeException("VisibilityAnnotationTag has no value for bytecode");
    }

    public void addAnnotation(AnnotationTag a) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(a);
    }

    public ArrayList<AnnotationTag> getAnnotations() {
        return this.annotations;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }
}

