/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.DirectoryPath;
import org.robovm.compiler.clazz.Java9RuntimePath;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.clazz.ZipFilePath;
import org.robovm.compiler.config.Config;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.options.Options;

public class Clazzes {
    private final Config config;
    private final List<Path> bootclasspathPaths = new ArrayList<Path>();
    private final List<Path> classpathPaths = new ArrayList<Path>();
    private final List<Path> paths = new ArrayList<Path>();
    private final Map<String, Clazz> cache = new HashMap<String, Clazz>();
    private final List<Clazz> allClasses = new ArrayList<Clazz>();
    private boolean sootInitialized = false;

    public Clazzes(Config config, List<File> bootclasspath, List<File> classpath) throws IOException {
        this.config = config;
        HashSet<File> seen = new HashSet<File>();
        this.addPaths(bootclasspath, this.bootclasspathPaths, seen, true);
        this.addPaths(classpath, this.classpathPaths, seen, false);
        this.paths.addAll(this.bootclasspathPaths);
        this.paths.addAll(this.classpathPaths);
        this.populateCache();
    }

    Config getConfig() {
        return this.config;
    }

    private static boolean isArchive(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".zip") || name.endsWith(".jar");
    }

    private void addPaths(List<File> files, List<Path> cp, Set<File> seen, boolean inBootclasspath) throws IOException {
        for (File file : files) {
            Path p;
            if ("VIRTUAL_FS_FOR_JDK".equals(file.getPath()) && !seen.contains(file)) {
                p = new Java9RuntimePath(file, this, cp.size(), inBootclasspath);
                cp.add(p);
                seen.add(file);
                continue;
            }
            if (!file.exists()) {
                this.config.getLogger().warn("Classpath entry %s does not exist", file);
                continue;
            }
            if (file.isFile() && !Clazzes.isArchive(file)) {
                throw new IOException("File is not an archive file: " + file.getAbsolutePath());
            }
            if (file.isDirectory() && this.isEmpty(file) || seen.contains(file)) continue;
            p = this.createPath(file, cp, inBootclasspath);
            cp.add(p);
            seen.add(file);
        }
    }

    private Path createPath(File file, List<Path> cp, boolean inBootclasspath) throws IOException {
        return file.isDirectory() ? new DirectoryPath(file, this, cp.size(), inBootclasspath) : new ZipFilePath(file, this, cp.size(), inBootclasspath);
    }

    public Path createResourcesBootclasspathPath(File file) throws IOException {
        return this.createPath(file, this.bootclasspathPaths, true);
    }

    public Path createResourcesClasspathPath(File file) throws IOException {
        return this.createPath(file, this.classpathPaths, false);
    }

    private boolean isEmpty(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                return false;
            }
            if (this.isEmpty(f)) continue;
            return false;
        }
        return true;
    }

    private void populateCache() {
        for (Path p : this.paths) {
            for (Clazz clazz : p.listClasses()) {
                if (this.cache.containsKey(clazz.getInternalName())) continue;
                this.cache.put(clazz.getInternalName(), clazz);
                this.allClasses.add(clazz);
            }
        }
    }

    public Clazz load(String internalName) {
        Clazz clazz;
        block1: {
            Path p;
            clazz = this.cache.get(internalName);
            if (clazz != null) break block1;
            Iterator<Path> iterator = this.paths.iterator();
            while (iterator.hasNext() && (clazz = (p = iterator.next()).loadGeneratedClass(internalName)) == null) {
            }
        }
        return clazz;
    }

    public List<InputStream> loadResources(String resource) throws IOException {
        ArrayList<InputStream> arr = new ArrayList<InputStream>();
        for (Path p : this.getPaths()) {
            if (!p.contains(resource)) continue;
            arr.add(p.open(resource));
        }
        return arr;
    }

    public List<Path> getBootclasspathPaths() {
        return Collections.unmodifiableList(this.bootclasspathPaths);
    }

    public List<Path> getClasspathPaths() {
        return Collections.unmodifiableList(this.classpathPaths);
    }

    public List<Path> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public List<Clazz> listClasses() {
        return Collections.unmodifiableList(this.allClasses);
    }

    SootClass getSootClass(Clazz clazz) {
        if (!this.sootInitialized) {
            Clazzes.initializeSoot(this);
            this.sootInitialized = true;
        }
        return Scene.v().loadClassAndSupport(clazz.getClassName());
    }

    private static String getSootClasspath(Clazzes clazzes) {
        StringBuilder sb = new StringBuilder();
        for (Path path : clazzes.getPaths()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            if (path instanceof Java9RuntimePath) {
                sb.append(path.getFile().getPath());
                continue;
            }
            try {
                sb.append(path.getFile().getCanonicalPath());
                sb.append(File.pathSeparator);
                sb.append(clazzes.config.getGeneratedClassDir(path).getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }

    private static void initializeSoot(Clazzes clazzes) {
        G.reset();
        Options.v().set_output_format(1);
        Options.v().set_include_all(true);
        Options.v().set_print_tags_in_output(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_keep_line_number(true);
        Options.v().set_soot_classpath(Clazzes.getSootClasspath(clazzes));
        Options.v().setPhaseOption("jb.dae", "enabled:false");
        Options.v().setPhaseOption("jb.uce", "enabled:false");
        Options.v().setPhaseOption("jap.npc", "enabled:true");
        Options.v().setPhaseOption("jap.abc", "enabled:true");
        Options.v().setPhaseOption("jop", "enabled:true");
        Options.v().setPhaseOption("jop.cse", "enabled:false");
        Options.v().setPhaseOption("jop.bcm", "enabled:false");
        Options.v().setPhaseOption("jop.lcm", "enabled:false");
        Options.v().setPhaseOption("jop.cp", "enabled:false");
        Options.v().setPhaseOption("jop.cpf", "enabled:false");
        Options.v().setPhaseOption("jop.cbf", "enabled:false");
        Options.v().setPhaseOption("jop.dae", "enabled:false");
        Options.v().setPhaseOption("jop.nce", "enabled:false");
        Options.v().setPhaseOption("jop.uce1", "enabled:false");
        Options.v().setPhaseOption("jop.ubf1", "enabled:false");
        Options.v().setPhaseOption("jop.uce2", "enabled:false");
        Options.v().setPhaseOption("jop.ubf2", "enabled:false");
        Options.v().setPhaseOption("jop.ule", "enabled:false");
        Scene.v().loadNecessaryClasses();
    }
}

