/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.Ordering;
import org.robovm.compiler.llvm.UnaryOpInstruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Load
extends UnaryOpInstruction {
    private final boolean _volatile;
    private final Ordering ordering;
    private final int alignment;

    public Load(Variable result, Value op) {
        this(result, op, false, null, -1);
    }

    public Load(Variable result, Value op, boolean _volatile) {
        this(result, op, _volatile, null, -1);
    }

    public Load(Variable result, Value op, boolean _volatile, Ordering ordering, int alignment) {
        super(result, op);
        this._volatile = _volatile;
        this.ordering = ordering;
        this.alignment = alignment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.result);
        sb.append(" = load ");
        if (this._volatile) {
            sb.append("volatile ");
        }
        if (this.ordering != null) {
            sb.append("atomic ");
        }
        sb.append(this.op.getType());
        sb.append(" ");
        sb.append(this.op);
        if (this.ordering != null) {
            sb.append(" ");
            sb.append((Object)this.ordering);
        }
        if (this.alignment > 0) {
            sb.append(", align ");
            sb.append(this.alignment);
        }
        return sb.toString();
    }
}

