/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import org.robovm.debugger.state.classdata.BaseModifiersInfo;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.state.classdata.MethodInfo;

public abstract class ClassInfo
extends BaseModifiersInfo {
    private final Type type;
    private long clazzPtr;

    public ClassInfo(Type type) {
        this.type = type;
    }

    public long clazzPtr() {
        return this.clazzPtr;
    }

    public void setClazzPtr(long clazzPtr) {
        this.clazzPtr = clazzPtr;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isPrimitive() {
        return this.type == Type.PRIMITIVE;
    }

    public boolean isClass() {
        return this.type == Type.CLASS;
    }

    public abstract String signature();

    public abstract String superclassSignature();

    public abstract FieldInfo[] fields(ClassInfoLoader var1);

    public abstract MethodInfo[] methods(ClassInfoLoader var1);

    public abstract ClassInfo[] interfaces(ClassInfoLoader var1);

    public abstract boolean hasError();

    public FieldInfo getField(String fieldName, ClassInfoLoader loader) {
        ClassInfo ci = this;
        while (ci != null) {
            FieldInfo[] fields2 = ci.fields(loader);
            Object fi = null;
            if (fields2 != null) {
                for (FieldInfo fieldInfo : fields2) {
                    if (!fieldName.equals(fieldInfo.name())) continue;
                    return fieldInfo;
                }
            }
            ci = loader.classInfoBySignature(ci.superclassSignature());
        }
        return null;
    }

    public static enum Type {
        CLASS,
        ARRAY,
        PRIMITIVE;

    }
}

