/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils;

import java.util.HashMap;
import java.util.Map;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.classdata.ClassInfoLoader;

public final class Converter {
    private final Map<Long, Byte> classInfoToTagMap = new HashMap<Long, Byte>();

    public static byte jdwpTypeTag(ClassInfo classInfo) {
        if (classInfo.isArray()) {
            return 3;
        }
        if (classInfo.isInterface()) {
            return 2;
        }
        return 1;
    }

    public static int jdwpClassStatus(ClassInfo classInfo) {
        if (classInfo.hasError()) {
            return 8;
        }
        if (classInfo.clazzPtr() != 0L) {
            return 7;
        }
        return 1;
    }

    public static int classModifiers(int flags) {
        int jdwpFlags = 0;
        if ((flags & 1) != 0) {
            jdwpFlags |= 1;
        }
        if ((flags & 2) != 0) {
            jdwpFlags |= 0x10;
        }
        if ((flags & 4) != 0) {
            jdwpFlags |= 0x200;
        }
        if ((flags & 8) != 0) {
            jdwpFlags |= 0x400;
        }
        if ((flags & 0x10) != 0) {
            jdwpFlags |= 0x1000;
        }
        if ((flags & 0x20) != 0) {
            jdwpFlags |= 0x2000;
        }
        if ((flags & 0x40) != 0) {
            jdwpFlags |= 0x4000;
        }
        return jdwpFlags;
    }

    public static int fieldModifiers(int flags) {
        int jdwpFlags = 0;
        if ((flags & 3) == 1) {
            jdwpFlags |= 1;
        }
        if ((flags & 3) == 2) {
            jdwpFlags |= 2;
        }
        if ((flags & 3) == 3) {
            jdwpFlags |= 4;
        }
        if ((flags & 4) != 0) {
            jdwpFlags |= 8;
        }
        if ((flags & 8) != 0) {
            jdwpFlags |= 0x10;
        }
        if ((flags & 0x10) != 0) {
            jdwpFlags |= 0x40;
        }
        if ((flags & 0x20) != 0) {
            jdwpFlags |= 0x80;
        }
        if ((flags & 0x40) != 0) {
            jdwpFlags |= 0x1000;
        }
        if ((flags & 0x80) != 0) {
            jdwpFlags |= 0x4000;
        }
        return jdwpFlags;
    }

    public static int methodModifiers(int flags) {
        int jdwpFlags = 0;
        if ((flags & 3) == 1) {
            jdwpFlags |= 1;
        }
        if ((flags & 3) == 2) {
            jdwpFlags |= 2;
        }
        if ((flags & 3) == 3) {
            jdwpFlags |= 4;
        }
        if ((flags & 4) != 0) {
            jdwpFlags |= 8;
        }
        if ((flags & 8) != 0) {
            jdwpFlags |= 0x10;
        }
        if ((flags & 0x10) != 0) {
            jdwpFlags |= 0x20;
        }
        if ((flags & 0x20) != 0) {
            jdwpFlags |= 0x40;
        }
        if ((flags & 0x40) != 0) {
            jdwpFlags |= 0x80;
        }
        if ((flags & 0x80) != 0) {
            jdwpFlags |= 0x100;
        }
        if ((flags & 0x100) != 0) {
            jdwpFlags |= 0x400;
        }
        if ((flags & 0x200) != 0) {
            jdwpFlags |= 0x800;
        }
        if ((flags & 0x400) != 0) {
            jdwpFlags |= 0x1000;
        }
        return jdwpFlags;
    }

    public byte jdwpInstanceTag(ClassInfo classInfo, ClassInfoLoader loader) {
        if (classInfo.isArray()) {
            return 91;
        }
        ClassInfoImpl ci = (ClassInfoImpl)classInfo;
        Byte bo = this.classInfoToTagMap.get(ci.refId());
        if (bo != null) {
            return bo;
        }
        byte tag = 0;
        switch (ci.signature()) {
            case "Ljava/lang/String;": {
                tag = 115;
                break;
            }
            case "Ljava/lang/Thread;": {
                tag = 116;
                break;
            }
            case "Ljava/lang/ThreadGroup;": {
                tag = 103;
                break;
            }
            case "Ljava/lang/ClassLoader;": {
                tag = 108;
                break;
            }
            case "Ljava/lang/Class;": {
                tag = 99;
            }
        }
        if (tag == 0) {
            ClassInfoImpl superclass;
            String superclassSignature = ci.superclassSignature();
            if (superclassSignature != null && (superclass = (ClassInfoImpl)loader.classInfoBySignature(superclassSignature)) != null) {
                tag = this.jdwpInstanceTag(superclass, loader);
            }
            if (tag == 0) {
                tag = 76;
            }
        }
        this.classInfoToTagMap.put(ci.refId(), tag);
        return tag;
    }

    public static byte jdwpSimpleInstanceTag(ClassInfo elementType) {
        byte tag = elementType.isPrimitive() ? (byte)((byte)elementType.signature().charAt(0)) : (elementType.isArray() ? (byte)91 : 76);
        return tag;
    }
}

