/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.ByteBuffer;
import org.robovm.debugger.utils.bytebuffer.DataBufferReaderWriter;
import org.robovm.debugger.utils.bytebuffer.DataByteBufferReader;

public class DataByteBufferWriter
extends DataByteBufferReader
implements DataBufferReaderWriter {
    private static final int DEFAULT_CAPACITY = 1024;

    public DataByteBufferWriter() {
        this(1024, false);
    }

    public DataByteBufferWriter(boolean is64Bit) {
        this(1024, is64Bit);
    }

    public DataByteBufferWriter(int capacity, boolean is64Bit) {
        super(ByteBuffer.allocate(capacity), is64Bit);
        this.reset();
    }

    @Override
    public DataByteBufferWriter reset() {
        this.byteBuffer.position(0);
        this.byteBuffer.limit(0);
        return this;
    }

    @Override
    public DataByteBufferWriter resetReader() {
        this.byteBuffer.position(0);
        return this;
    }

    @Override
    public void wants(int bytes) {
        long capacity;
        long afterWritePos = this.byteBuffer.position() + bytes;
        if (afterWritePos > (capacity = (long)this.byteBuffer.capacity())) {
            long blocksCount = (afterWritePos + 1024L - 1L) / 1024L;
            capacity = 2L * blocksCount * 1024L;
            ByteBuffer buffer = ByteBuffer.allocate((int)capacity);
            int oldPosition = this.byteBuffer.position();
            this.byteBuffer.position(0);
            buffer.put(this.byteBuffer);
            buffer.position(oldPosition);
            buffer.limit(this.byteBuffer.limit());
            this.byteBuffer = buffer;
        }
        if (afterWritePos > (long)this.byteBuffer.limit()) {
            this.byteBuffer.limit((int)afterWritePos);
        }
    }

    @Override
    public DataByteBufferWriter writeByte(byte b) {
        this.wants(1);
        this.byteBuffer.put(b);
        return this;
    }

    @Override
    public DataByteBufferWriter writeInt32(int i) {
        this.wants(4);
        this.byteBuffer.putInt(i);
        return this;
    }

    @Override
    public DataByteBufferWriter writeInt16(short i) {
        this.wants(2);
        this.byteBuffer.putShort(i);
        return this;
    }

    @Override
    public DataByteBufferWriter writeLong(long l) {
        this.wants(8);
        this.byteBuffer.putLong(l);
        return this;
    }

    @Override
    public DataByteBufferWriter writeFloat(float f) {
        this.wants(4);
        this.byteBuffer.putFloat(f);
        return this;
    }

    @Override
    public DataByteBufferWriter writeDouble(double d) {
        this.wants(8);
        this.byteBuffer.putDouble(d);
        return this;
    }

    @Override
    public DataByteBufferWriter writeBytes(byte[] bytes, int offset, int length) {
        this.wants(length);
        this.byteBuffer.put(bytes, offset, length);
        return this;
    }
}

