/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndClient;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.PlistUtil;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;
import org.robovm.libimobiledevice.binding.MobileImageMounterClientRef;
import org.robovm.libimobiledevice.binding.MobileImageMounterClientRefOut;
import org.robovm.libimobiledevice.binding.MobileImageMounterError;
import org.robovm.libimobiledevice.binding.PlistRef;
import org.robovm.libimobiledevice.binding.PlistRefOut;

public class MobileImageMounterClient
implements AutoCloseable {
    public static final String SERVICE_NAME = "com.apple.mobile.mobile_image_mounter";
    private static final String PRIVATE_MOUNT_PREFIX = "/private/var/mobile/Media";
    protected MobileImageMounterClientRef ref;

    MobileImageMounterClient(MobileImageMounterClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileImageMounterClient(IDevice device, LockdowndServiceDescriptor service) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        MobileImageMounterClientRefOut refOut = new MobileImageMounterClientRefOut();
        LockdowndServiceDescriptorStruct serviceStruct = new LockdowndServiceDescriptorStruct();
        serviceStruct.setPort((short)service.getPort());
        serviceStruct.setSslEnabled(service.isSslEnabled());
        try {
            MobileImageMounterClient.checkResult(LibIMobileDevice.mobile_image_mounter_new(device.getRef(), serviceStruct, refOut));
            this.ref = refOut.getValue();
        }
        finally {
            serviceStruct.delete();
            refOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary mountImage(String imagePath, byte[] imageSignature, String imageType) throws IOException {
        if (imagePath == null) {
            throw new NullPointerException("imagePath");
        }
        if (imageSignature == null) {
            throw new NullPointerException("imageSignature");
        }
        if (imageType == null) {
            imageType = "Developer";
        }
        if (!imagePath.startsWith("/")) {
            imagePath = "/" + imagePath;
        }
        imagePath = PRIVATE_MOUNT_PREFIX + imagePath;
        PlistRefOut plistOut = new PlistRefOut();
        try {
            MobileImageMounterClient.checkResult(LibIMobileDevice.mobile_image_mounter_mount_image(this.getRef(), imagePath, imageSignature, (short)imageSignature.length, imageType, plistOut));
            PlistRef plist = plistOut.getValue();
            NSDictionary nSDictionary = (NSDictionary)PlistUtil.toJavaPlist(plist);
            return nSDictionary;
        }
        finally {
            plistOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary lookupImage(String imageType) throws IOException {
        if (imageType == null) {
            imageType = "Developer";
        }
        PlistRefOut plistOut = new PlistRefOut();
        try {
            MobileImageMounterClient.checkResult(LibIMobileDevice.mobile_image_mounter_lookup_image(this.getRef(), imageType, plistOut));
            PlistRef plist = plistOut.getValue();
            NSDictionary nSDictionary = (NSDictionary)PlistUtil.toJavaPlist(plist);
            return nSDictionary;
        }
        finally {
            plistOut.delete();
        }
    }

    public void uploadImage(File localImageFile, String imageType, byte[] signature) throws IOException {
        if (localImageFile == null) {
            throw new NullPointerException("localImageFile");
        }
        if (!localImageFile.exists()) {
            throw new FileNotFoundException(localImageFile.getAbsolutePath());
        }
        if (!localImageFile.isFile()) {
            throw new IllegalArgumentException("Path is not a file: " + localImageFile.getAbsolutePath());
        }
        if (imageType == null) {
            imageType = "Developer";
        }
        MobileImageMounterClient.checkResult(LibIMobileDevice.upload_image(this.getRef(), localImageFile.getAbsolutePath(), imageType, signature, signature.length));
    }

    protected MobileImageMounterClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.mobile_image_mounter_hangup(this.ref);
        LibIMobileDevice.mobile_image_mounter_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() throws Exception {
        this.dispose();
    }

    private static void checkResult(MobileImageMounterError result) {
        if (result != MobileImageMounterError.MOBILE_IMAGE_MOUNTER_E_SUCCESS) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }

    private static void printUsageAndExit() {
        System.err.println(InstallationProxyClient.class.getName() + " [deviceid] <action> ...");
        System.err.println("  Actions:");
        System.err.println("    lookup [type]       Looks for a mounted image of the specified type or 'Developer' if not specified.");
        System.err.println("    mount <remotepath> <sigpath> [type]\n                        Mounts an image uploaded to the device. <sigpath> is the path to a local .signature file.\n                        type is the type of the image to mount. If not specified 'Developer' will be used.");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        String deviceId = null;
        String action = null;
        int index = 0;
        try {
            action = args[index++];
            if (action.matches("[0-9a-f]{40}")) {
                deviceId = action;
                action = args[index++];
            }
            if (!action.matches("lookup|mount")) {
                System.err.println("Unknown action: " + action);
                MobileImageMounterClient.printUsageAndExit();
            }
            if (deviceId == null && deviceId == null) {
                String[] udids = IDevice.listUdids();
                if (udids.length == 0) {
                    System.err.println("No device connected");
                    return;
                }
                if (udids.length > 1) {
                    System.err.println("More than 1 device connected (" + Arrays.asList(udids) + "). Using " + udids[0]);
                }
                deviceId = udids[0];
            }
            try (IDevice device = new IDevice(deviceId);
                 LockdowndClient lockdowndClient = new LockdowndClient(device, MobileImageMounterClient.class.getSimpleName(), true);){
                LockdowndServiceDescriptor afcService = lockdowndClient.startService("com.apple.afc");
                try (AfcClient afcClient = new AfcClient(device, afcService);){
                    LockdowndServiceDescriptor mimService = lockdowndClient.startService(SERVICE_NAME);
                    try (MobileImageMounterClient mimClient = new MobileImageMounterClient(device, mimService);){
                        NSObject result = null;
                        String imageType = null;
                        switch (action) {
                            case "lookup": {
                                if (args.length < index) {
                                    imageType = args[index];
                                }
                                result = mimClient.lookupImage(imageType);
                                break;
                            }
                            case "mount": {
                                String imagePath = args[index++];
                                String sigPath = args[index++];
                                byte[] sig = Files.readAllBytes(new File(sigPath).toPath());
                                if (args.length < index) {
                                    imageType = args[index];
                                }
                                afcClient.makeDirectory("/PublicStaging");
                                afcClient.fileCopy(new File(imagePath), "/PublicStaging/staging.dimage");
                                result = mimClient.mountImage("/PublicStaging/staging.dimage", sig, imageType);
                            }
                        }
                        System.out.println(result.toXMLPropertyList());
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MobileImageMounterClient.printUsageAndExit();
        }
    }
}

