/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.IOException;
import org.robovm.libimobiledevice.binding.ByteArray;
import org.robovm.libimobiledevice.binding.ByteArrayOut;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.PlistRef;
import org.robovm.libimobiledevice.binding.PlistRefOut;

class PlistUtil {
    PlistUtil() {
    }

    public static NSObject toJavaPlist(PlistRef plist) throws IOException {
        PlistRefOut plistOut = new PlistRefOut();
        ByteArrayOut plistBinOut = new ByteArrayOut();
        IntOut lengthOut = new IntOut();
        try {
            LibIMobileDevice.plist_to_bin(plist, plistBinOut, lengthOut);
            LibIMobileDevice.plist_free(plist);
            int length = lengthOut.getValue();
            ByteArray plistBin = plistBinOut.getValue();
            if (length == 0 || plistBin == null) {
                NSObject nSObject = null;
                return nSObject;
            }
            byte[] data = new byte[length];
            for (int i = 0; i < length; ++i) {
                data[i] = plistBin.get(i);
            }
            NSObject nSObject = PropertyListParser.parse(data);
            return nSObject;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            plistOut.delete();
            LibIMobileDevice.delete_ByteArrayOut_value(plistBinOut);
            plistBinOut.delete();
            lengthOut.delete();
        }
    }
}

