/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Scene;
import soot.SideEffectTester;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NaiveSideEffectTester;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.PASideEffectTester;
import soot.jimple.toolkits.scalar.FastAvailableExpressions;
import soot.options.Options;
import soot.tagkit.StringTag;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class CommonSubexpressionEliminator
extends BodyTransformer {
    public CommonSubexpressionEliminator(Singletons.Global g) {
    }

    public static CommonSubexpressionEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_CommonSubexpressionEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        int counter = 0;
        Iterator<Local> localsIt = b.getLocals().iterator();
        HashSet<String> localNames = new HashSet<String>(b.getLocals().size());
        while (localsIt.hasNext()) {
            localNames.add(localsIt.next().getName());
        }
        SideEffectTester sideEffect = Scene.v().hasCallGraph() && !PhaseOptions.getBoolean(options, "naive-side-effect") ? new PASideEffectTester() : new NaiveSideEffectTester();
        sideEffect.newMethod(b.getMethod());
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Eliminating common subexpressions " + (sideEffect instanceof NaiveSideEffectTester ? "(naively)" : "") + "...");
        }
        FastAvailableExpressions ae = new FastAvailableExpressions(b, sideEffect);
        PatchingChain<Unit> units = b.getUnits();
        Iterator unitsIt = units.snapshotIterator();
        while (unitsIt.hasNext()) {
            Value v;
            EquivalentValue ev;
            Chain availExprs;
            Stmt s = (Stmt)unitsIt.next();
            if (!(s instanceof AssignStmt) || !(availExprs = ae.getAvailableEquivsBefore(s)).contains(ev = new EquivalentValue(v = ((AssignStmt)s).getRightOp()))) continue;
            List availPairs = ae.getAvailablePairsBefore(s);
            for (UnitValueBoxPair up : availPairs) {
                if (!up.getValueBox().getValue().equivTo(v)) continue;
                String newName = "$cseTmp" + counter;
                ++counter;
                while (localNames.contains(newName)) {
                    newName = "$cseTmp" + counter;
                    ++counter;
                }
                Local l = Jimple.v().newLocal(newName, Type.toMachineType(v.getType()));
                b.getLocals().add(l);
                AssignStmt origCalc = (AssignStmt)up.getUnit();
                Value origLHS = origCalc.getLeftOp();
                origCalc.setLeftOp(l);
                AssignStmt copier = Jimple.v().newAssignStmt(origLHS, l);
                units.insertAfter(copier, (Unit)origCalc);
                ((AssignStmt)s).setRightOp(l);
                copier.addTag(new StringTag("Common sub-expression"));
                s.addTag(new StringTag("Common sub-expression"));
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Eliminating common subexpressions done!");
        }
    }
}

