/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;

public class CytronDominanceFrontier
implements DominanceFrontier {
    protected DominatorTree dt;
    protected Map<DominatorNode, List<DominatorNode>> nodeToFrontier;

    public CytronDominanceFrontier(DominatorTree dt) {
        this.dt = dt;
        this.nodeToFrontier = new HashMap<DominatorNode, List<DominatorNode>>();
        this.bottomUpDispatch(dt.getHead());
    }

    @Override
    public List getDominanceFrontierOf(DominatorNode node) {
        ArrayList frontier = (ArrayList)this.nodeToFrontier.get(node);
        if (frontier == null) {
            throw new RuntimeException("Frontier not defined for node: " + node);
        }
        return (List)frontier.clone();
    }

    protected boolean isFrontierKnown(DominatorNode node) {
        return this.nodeToFrontier.containsKey(node);
    }

    protected void bottomUpDispatch(DominatorNode node) {
        if (this.isFrontierKnown(node)) {
            return;
        }
        for (DominatorNode child : this.dt.getChildrenOf(node)) {
            if (this.isFrontierKnown(child)) continue;
            this.bottomUpDispatch(child);
        }
        this.processNode(node);
    }

    protected void processNode(DominatorNode node) {
        ArrayList<DominatorNode> dominanceFrontier = new ArrayList<DominatorNode>();
        for (DominatorNode succ : this.dt.getSuccsOf(node)) {
            if (this.dt.isImmediateDominatorOf(node, succ)) continue;
            dominanceFrontier.add(succ);
        }
        for (DominatorNode child : this.dt.getChildrenOf(node)) {
            for (DominatorNode childFront : this.getDominanceFrontierOf(child)) {
                if (this.dt.isImmediateDominatorOf(node, childFront)) continue;
                dominanceFrontier.add(childFront);
            }
        }
        this.nodeToFrontier.put(node, dominanceFrontier);
    }
}

