/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.Pair;

public class RoboVmLiveSlotLocals {
    private final UnitGraph graph;
    private final Map<Unit, Map<Integer, Local>> localVisibility = new HashMap<Unit, Map<Integer, Local>>();

    public RoboVmLiveSlotLocals(UnitGraph graph) {
        this.graph = graph;
        this.traverseNodes(graph.getHeads());
    }

    public Map<Integer, Local> getLocalsBeforUnit(Unit u) {
        return this.localVisibility.get(u);
    }

    private void traverseNodes(List<Unit> units) {
        HashSet<Unit> visitedUnits = new HashSet<Unit>();
        ArrayDeque stack = new ArrayDeque();
        stack.push(new Pair(units.iterator(), new HashMap()));
        while (!stack.isEmpty()) {
            Pair pair = (Pair)stack.pop();
            Iterator<Unit> it = (Iterator<Unit>)pair.o1;
            HashMap<Integer, Local> definedLocals = (HashMap<Integer, Local>)pair.o2;
            while (it.hasNext()) {
                Unit u = (Unit)it.next();
                if (visitedUnits.contains(u)) continue;
                visitedUnits.add(u);
                this.localVisibility.put(u, (Map<Integer, Local>)definedLocals);
                List<Unit> successors = this.graph.getSuccsOf(u);
                if (successors == null || successors.isEmpty() || successors.size() == 1 && visitedUnits.contains(successors.get(0))) continue;
                HashMap<Integer, Local> unitLocals = definedLocals;
                if (u.getDefBoxes().size() == 1) {
                    ValueBox loBox = u.getDefBoxes().get(0);
                    Value lo = loBox.getValue();
                    Local local = null;
                    if (lo instanceof Local) {
                        local = (Local)lo;
                    }
                    if (local != null && local.getIndex() >= 0) {
                        unitLocals = new HashMap<Integer, Local>(definedLocals);
                        unitLocals.put(local.getIndex(), local);
                    }
                }
                if (it.hasNext()) {
                    stack.push(new Pair<Iterator<Unit>, Map>(it, definedLocals));
                }
                definedLocals = unitLocals;
                it = successors.iterator();
            }
        }
    }
}

