/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.nio.ByteOrder;
import org.robovm.compiler.CompilerException;
import org.robovm.llvm.Target;

public enum Arch {
    x86("i386", "i386", "penryn", true, false),
    x86_64("x86_64", "x86_64", "penryn", false, false),
    thumbv7("thumbv7", "armv7", true, true),
    arm64("arm64", "arm64", false, true);

    private final String llvmName;
    private final String clangName;
    private final String llvmCpu;
    private final boolean is32Bit;
    private final boolean isArm;
    private final ByteOrder byteOrder;

    private Arch(String llvmName, String clangName, boolean is32Bit, boolean isArm) {
        this(llvmName, clangName, "generic", is32Bit, isArm);
    }

    private Arch(String llvmName, String clangName, String llvmCpu, boolean is32Bit, boolean isArm) {
        this(llvmName, clangName, llvmCpu, is32Bit, isArm, ByteOrder.LITTLE_ENDIAN);
    }

    private Arch(String llvmName, String clangName, String llvmCpu, boolean is32Bit, boolean isArm, ByteOrder byteOrder) {
        this.llvmName = llvmName;
        this.clangName = clangName;
        this.llvmCpu = llvmCpu;
        this.is32Bit = is32Bit;
        this.isArm = isArm;
        this.byteOrder = byteOrder;
    }

    public String getLlvmName() {
        return this.llvmName;
    }

    public String getClangName() {
        return this.clangName;
    }

    public String getLlvmCpu() {
        return this.llvmCpu;
    }

    public boolean isArm() {
        return this.isArm;
    }

    public boolean is32Bit() {
        return this.is32Bit;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static Arch getDefaultArch() {
        String hostTriple = Target.getHostTriple();
        if (hostTriple.matches("^(x86.64|amd64).*")) {
            return x86_64;
        }
        if (hostTriple.matches("^(x86|i\\d86).*")) {
            return x86;
        }
        throw new CompilerException("Unrecognized arch in host triple: " + hostTriple);
    }
}

