/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.NamedMetadata;
import org.robovm.compiler.llvm.UnnamedMetadata;
import org.robovm.compiler.llvm.UserType;

public class Module {
    private final Collection<URL> includes;
    private final Collection<Global> globals;
    private final Collection<Alias> aliases;
    private final Collection<Function> functions;
    private final Collection<FunctionDeclaration> functionDeclarations;
    private final Collection<UserType> types;
    private final Collection<String> asm;
    private final Collection<NamedMetadata> namedMetadata;
    private final Collection<UnnamedMetadata> unnamedMetadata;

    public Module(Collection<URL> includes, Collection<UserType> types, Collection<Global> globals, Collection<Alias> aliases, Collection<FunctionDeclaration> functionDeclarations, Collection<String> asm, Collection<Function> functions, Collection<NamedMetadata> namedMetadata, Collection<UnnamedMetadata> unnamedMetadata) {
        this.includes = includes;
        this.types = types;
        this.globals = globals;
        this.aliases = aliases;
        this.functionDeclarations = functionDeclarations;
        this.asm = asm;
        this.functions = functions;
        this.namedMetadata = namedMetadata;
        this.unnamedMetadata = unnamedMetadata;
    }

    public void write(Writer writer) throws IOException {
        for (URL uRL : this.includes) {
            InputStream in = null;
            try {
                in = uRL.openStream();
                IOUtils.copy(in, writer, "UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            writer.write("\n");
        }
        writer.write("\n");
        for (String string : this.asm) {
            writer.write("module asm \"");
            writer.write(string);
            writer.write("\"\n");
        }
        writer.write("\n");
        for (UserType userType : this.types) {
            writer.write(userType.getAlias());
            writer.write(" = type ");
            writer.write(userType.getDefinition());
            writer.write("\n");
        }
        writer.write("\n");
        for (FunctionDeclaration functionDeclaration : this.functionDeclarations) {
            writer.write(functionDeclaration.toString());
            writer.write("\n");
        }
        writer.write("\n");
        for (Global global : this.globals) {
            writer.write(global.getDefinition());
            writer.write("\n");
        }
        writer.write("\n");
        for (Alias alias : this.aliases) {
            writer.write(alias.getDefinition());
            writer.write("\n");
        }
        writer.write("\n");
        for (Function function : this.functions) {
            writer.write(function.toString());
            writer.write("\n");
        }
        writer.write("\n");
        for (NamedMetadata namedMetadata : this.namedMetadata) {
            writer.write(namedMetadata.toString());
            writer.write("\n");
        }
        writer.write("\n");
        for (UnnamedMetadata unnamedMetadata : this.unnamedMetadata) {
            writer.write(unnamedMetadata.getDefinition());
            writer.write("\n");
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }
}

