/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.util.Arrays;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Type;

public class StructureType
extends AggregateType {
    protected final Type[] types;
    private final int ownMembersOffset;
    private final int attributes;
    public static final int ATTR_UNALIGNED = 1;
    public static final int ATTR_NOT_SINGLE_INT_STRUCT = 2;

    public StructureType(int ownMembersOffset, int flags, Type ... types) {
        this.types = (Type[])types.clone();
        this.ownMembersOffset = ownMembersOffset;
        this.attributes = flags;
    }

    public StructureType(int ownMembersOffset, int flags, String alias, Type ... types) {
        super(alias);
        this.types = (Type[])types.clone();
        this.ownMembersOffset = ownMembersOffset;
        this.attributes = flags;
    }

    public StructureType(Type ... types) {
        this(0, 0, types);
    }

    public StructureType(String alias, Type ... types) {
        this(0, 0, alias, types);
    }

    @Override
    public Type getTypeAt(int index) {
        return this.types[index];
    }

    public Type[] getTypes() {
        return this.types;
    }

    @Override
    public int getTypeCount() {
        return this.types.length;
    }

    public int getOwnMembersOffset() {
        return this.ownMembersOffset;
    }

    @Override
    public String getDefinition() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.types[i].toString());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureType other = (StructureType)obj;
        return Arrays.equals(this.types, other.types);
    }

    public int getAttributes() {
        return this.attributes;
    }
}

