/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import soot.SootClass;
import soot.SootResolver;

public class ObjCProtocolProxyPlugin
extends AbstractCompilerPlugin {
    public static final String OBJC_PROTOCOL = "org.robovm.objc.ObjCProtocol";
    public static final String PROXY_CLASS_NAME_SUFFIX = "$ObjCProxy";
    private SootClass org_robovm_objc_ObjCProtocol = null;
    private boolean initialized = false;

    private void init() {
        if (this.initialized) {
            return;
        }
        SootResolver r = SootResolver.v();
        this.org_robovm_objc_ObjCProtocol = r.makeClassRef(OBJC_PROTOCOL);
        this.initialized = true;
    }

    public static boolean isObjCProxy(SootClass cls) {
        return (cls.getModifiers() & 0x1000) > 0 && cls.getName().endsWith(PROXY_CLASS_NAME_SUFFIX);
    }

    private boolean isObjCProtocol(SootClass cls) {
        if (this.org_robovm_objc_ObjCProtocol.isPhantom() || !cls.isInterface()) {
            return false;
        }
        for (SootClass interfaze : cls.getInterfaces()) {
            if (interfaze != this.org_robovm_objc_ObjCProtocol && !this.isObjCProtocol(interfaze)) continue;
            return true;
        }
        return false;
    }

    private String getProxySuperclassInternalName(SootClass cls) {
        if (cls.getName().equals("org.robovm.apple.foundation.NSObjectProtocol")) {
            return "org/robovm/apple/foundation/NSObject";
        }
        if (cls.getName().equals("org.robovm.cocoatouch.foundation.NSObjectProtocol")) {
            return "org/robovm/cocoatouch/foundation/NSObject";
        }
        if (cls == this.org_robovm_objc_ObjCProtocol) {
            return "org/robovm/objc/ObjCObject";
        }
        for (SootClass interfaze : cls.getInterfaces()) {
            String name = this.getProxySuperclassInternalName(interfaze);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private void collectProxyInterfaceInternalNames(SootClass cls, List<String> result) {
        if (result.isEmpty()) {
            result.add(cls.getName().replace('.', '/'));
        }
        for (SootClass interfaze : cls.getInterfaces()) {
            String internalName = interfaze.getName().replace('.', '/');
            if (result.contains(internalName)) continue;
            result.add(internalName);
        }
        for (SootClass interfaze : cls.getInterfaces()) {
            this.collectProxyInterfaceInternalNames(interfaze, result);
        }
    }

    private void generateProxyMethods(Config config, List<String> interfazes, ClassWriter cw) throws IOException {
        Clazzes clazzes = config.getClazzes();
        final HashSet addedMethods = new HashSet();
        for (String interfaze : interfazes) {
            Clazz clazz = clazzes.load(interfaze);
            if (clazz == null) continue;
            ClassReader classReader = new ClassReader(clazz.getBytes());
            classReader.accept(new ClassVisitor(262144, cw){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    String key = name + desc;
                    if ((access & 0x400) > 0 && !addedMethods.contains(key)) {
                        access &= 0xFFFFFBFF;
                        addedMethods.add(key);
                        return super.visitMethod(access |= 0x100, name, desc, signature, exceptions);
                    }
                    return null;
                }

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                }

                @Override
                public void visitEnd() {
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return null;
                }

                @Override
                public void visitAttribute(Attribute attr) {
                }

                @Override
                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    return null;
                }

                @Override
                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                }

                @Override
                public void visitOuterClass(String owner, String name, String desc) {
                }

                @Override
                public void visitSource(String source, String debug) {
                }
            }, 0);
        }
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) {
        this.init();
        SootClass sootClass = clazz.getSootClass();
        if (this.isObjCProtocol(sootClass)) {
            try {
                String proxyInternalName = clazz.getInternalName() + PROXY_CLASS_NAME_SUFFIX;
                ArrayList<String> interfazes = new ArrayList<String>();
                this.collectProxyInterfaceInternalNames(sootClass, interfazes);
                ClassWriter cw = new ClassWriter(1);
                cw.visit(51, 4145, proxyInternalName, null, this.getProxySuperclassInternalName(sootClass), new String[]{clazz.getInternalName()});
                this.generateProxyMethods(config, interfazes, cw);
                cw.visitEnd();
                File f = clazz.getPath().getGeneratedClassFile(proxyInternalName);
                FileUtils.writeByteArrayToFile(f, cw.toByteArray());
                f.setLastModified(clazz.lastModified());
                clazz.getClazzInfo().addClassDependency(proxyInternalName, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

