/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Bro;
import org.robovm.compiler.Types;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;

public class TypeEncoder {
    public static final String SELECTOR = "org.robovm.objc.Selector";
    public static final String OBJC_CLASS = "org.robovm.objc.ObjCClass";
    public static final String OBJC_BLOCK = "org.robovm.objc.ObjCBlock";

    public String encode(SootMethod method, boolean is64bit) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.encodeOne(method, method.getReturnType(), -1, is64bit));
        for (int i = 0; i < method.getParameterCount(); ++i) {
            sb.append(this.encodeOne(method, method.getParameterType(i), i, is64bit));
        }
        return sb.toString();
    }

    private boolean hasAnno(SootMethod method, int idx, String annotationType) {
        if (idx == -1) {
            return Annotations.hasAnnotation(method, annotationType);
        }
        return Annotations.hasParameterAnnotation(method, idx, annotationType);
    }

    private String encodeOne(SootMethod method, Type t, int idx, boolean is64bit) {
        if (t instanceof VoidType) {
            return this.encodeVoid((VoidType)t);
        }
        if (t instanceof PrimType) {
            return this.encodePrimitive(method, (PrimType)t, idx, is64bit);
        }
        if (Types.isStruct(method.getDeclaringClass()) && this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/Array;")) {
            throw new IllegalArgumentException("Cannot not determine type encoding for @Array annotated method " + method + ". @Array is not yet supported. Use an explicit @TypeEncoding annotation instead.");
        }
        if (t instanceof RefType) {
            return this.encodeRef(method, (RefType)t, idx, is64bit);
        }
        throw new IllegalArgumentException("Unsupported type " + t.getClass().getName() + " " + t);
    }

    private String encodeVoid(VoidType t) {
        return "v";
    }

    private String encodeRef(SootMethod method, RefType t, int idx, boolean is64bit) {
        if (SELECTOR.equals(t.getClassName())) {
            return ":";
        }
        if (OBJC_CLASS.equals(t.getClassName())) {
            return "#";
        }
        if (OBJC_BLOCK.equals(t.getClassName())) {
            return "@?";
        }
        if (Types.isStruct(t)) {
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/ByVal;")) {
                return this.encodeStruct(method, t, idx, is64bit);
            }
            return "^v";
        }
        return "@";
    }

    private boolean isUnion(Collection<Member> members) {
        for (Member m : members) {
            if (m.offset <= 0) continue;
            return false;
        }
        return true;
    }

    private String encodeStruct(SootMethod method, RefType t, int idx, boolean is64bit) {
        TreeSet<Member> members = new TreeSet<Member>(this.getStructMembers(t.getSootClass(), is64bit));
        StringBuilder sb = new StringBuilder();
        boolean union = this.isUnion(members);
        sb.append(union ? (char)'(' : '{');
        sb.append("?=");
        for (Member m : members) {
            sb.append(m.type);
        }
        sb.append(union ? (char)')' : '}');
        return sb.toString();
    }

    private String encodePrimitive(SootMethod method, PrimType t, int idx, boolean is64bit) {
        if (t.equals(BooleanType.v())) {
            return "c";
        }
        if (t.equals(ByteType.v())) {
            return "c";
        }
        if (t.equals(ShortType.v())) {
            return "s";
        }
        if (t.equals(CharType.v())) {
            return "S";
        }
        if (t.equals(IntType.v())) {
            return "i";
        }
        if (t.equals(LongType.v())) {
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/Pointer;")) {
                return "^v";
            }
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/MachineSizedSInt;")) {
                return is64bit ? "q" : "i";
            }
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/MachineSizedUInt;")) {
                return is64bit ? "Q" : "I";
            }
            return "q";
        }
        if (t.equals(FloatType.v())) {
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/MachineSizedFloat;")) {
                return is64bit ? "d" : "f";
            }
            return "f";
        }
        if (t.equals(DoubleType.v())) {
            if (this.hasAnno(method, idx, "Lorg/robovm/rt/bro/annotation/MachineSizedFloat;")) {
                return is64bit ? "d" : "f";
            }
            return "d";
        }
        throw new IllegalArgumentException("Unknown Type: " + t);
    }

    private List<Member> getStructMembers(SootClass clazz, boolean is64bit) {
        SootClass superclass;
        ArrayList<Member> members = new ArrayList<Member>();
        if (clazz.hasSuperclass() && !(superclass = clazz.getSuperclass()).getName().equals("org.robovm.rt.bro.Struct")) {
            members.addAll(this.getStructMembers(clazz, is64bit));
        }
        for (SootMethod method : clazz.getMethods()) {
            int idx;
            Type type;
            int offset = Bro.getStructMemberOffset(method);
            if (offset == -1 || !method.isNative() && !method.isStatic()) continue;
            if (method.getParameterCount() == 0) {
                type = method.getReturnType();
                idx = -1;
            } else {
                if (method.getParameterCount() != 1) continue;
                type = method.getParameterType(0);
                idx = 0;
            }
            Member member = new Member();
            member.offset = offset;
            member.type = this.encodeOne(method, type, idx, is64bit);
            members.add(member);
        }
        return members;
    }

    static class Member
    implements Comparable<Member> {
        int offset;
        String type;

        Member() {
        }

        @Override
        public int compareTo(Member o) {
            int c = Integer.compare(this.offset, o.offset);
            if (c == 0) {
                c = this.type.compareTo(o.type);
            }
            return c;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.offset;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            if (this.offset != other.offset) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

