/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.robovm.compiler.log.ErrorOutputStream;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;
import org.robovm.libimobiledevice.util.AppLauncher;

public class AppLauncherProcess
extends Process
implements Launcher {
    private final AtomicInteger threadCounter = new AtomicInteger();
    private final Logger log;
    private final AppLauncher launcher;
    private final WaitInputStream in = new WaitInputStream();
    private final WaitInputStream err = new WaitInputStream();
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private Thread launcherThread;
    private volatile boolean finished = false;
    private volatile int exitCode = -1;
    private OutputStream errStream;

    public AppLauncherProcess(Logger log, AppLauncher launcher, LaunchParameters launchParameters) {
        this.log = log;
        this.launcher = launcher;
        if (launchParameters.getStderrFifo() != null) {
            this.errStream = new OpenOnWriteFileOutputStream(launchParameters.getStderrFifo());
        }
    }

    @Override
    public Process execAsync() throws IOException {
        this.launcher.install();
        this.launcherThread = new Thread("AppLauncherThread-" + this.threadCounter.getAndIncrement()){

            @Override
            public void run() {
                try {
                    AppLauncherProcess.this.exitCode = AppLauncherProcess.this.launcher.launch();
                }
                catch (Throwable t) {
                    AppLauncherProcess.this.log.error("AppLauncher failed with an exception:", t.getMessage());
                    t.printStackTrace(new PrintStream(new ErrorOutputStream(AppLauncherProcess.this.log), true));
                }
                finally {
                    IOUtils.closeQuietly(AppLauncherProcess.this.errStream);
                    AppLauncherProcess.this.finished = true;
                    AppLauncherProcess.this.countDownLatch.countDown();
                }
            }
        };
        this.launcherThread.start();
        return this;
    }

    @Override
    public OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.countDownLatch.await();
        return this.exitCode;
    }

    @Override
    public int exitValue() {
        if (!this.finished) {
            throw new IllegalThreadStateException("Not terminated");
        }
        return this.exitCode;
    }

    @Override
    public void destroy() {
        this.launcher.kill();
    }

    private class WaitInputStream
    extends InputStream {
        private WaitInputStream() {
        }

        @Override
        public int read() throws IOException {
            try {
                AppLauncherProcess.this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            return -1;
        }
    }
}

