/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.config.AppExtension;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.AbstractTarget;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.Launcher;
import org.robovm.compiler.target.ios.AppLauncherProcess;
import org.robovm.compiler.target.ios.IOSDeviceLaunchParameters;
import org.robovm.compiler.target.ios.IOSSimulatorLaunchParameters;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SDK;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.robovm.compiler.target.ios.SimLauncherProcess;
import org.robovm.compiler.util.Executor;
import org.robovm.compiler.util.ToolchainUtil;
import org.robovm.compiler.util.io.OpenOnWriteFileOutputStream;
import org.robovm.libimobiledevice.AfcClient;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.InstallationProxyClient;
import org.robovm.libimobiledevice.util.AppLauncher;
import org.robovm.libimobiledevice.util.AppLauncherCallback;

public class IOSTarget
extends AbstractTarget {
    final List<String> excludedKeys = Arrays.asList("com.apple.developer.icloud-container-development-container-identifiers", "com.apple.developer.icloud-container-environment", "com.apple.developer.icloud-container-identifiers", "com.apple.developer.icloud-services", "com.apple.developer.restricted-resource-mode", "com.apple.developer.ubiquity-container-identifiers", "com.apple.developer.ubiquity-kvstore-identifier", "inter-app-audio", "com.apple.developer.homekit", "com.apple.developer.healthkit", "com.apple.developer.in-app-payments", "com.apple.developer.associated-domains", "com.apple.security.application-groups", "com.apple.developer.maps", "com.apple.developer.networking.vpn.api", "com.apple.external-accessory.wireless-configuration");
    public static final String TYPE = "ios";
    private static File iosSimPath;
    private Arch arch;
    private SDK sdk;
    private File entitlementsPList;
    private SigningIdentity signIdentity;
    private ProvisioningProfile provisioningProfile;
    private IDevice device;
    private File partialPListDir;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Arch getArch() {
        return this.arch;
    }

    @Override
    public LaunchParameters createLaunchParameters() {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return new IOSSimulatorLaunchParameters();
        }
        return new IOSDeviceLaunchParameters();
    }

    public static boolean isSimulatorArch(Arch arch) {
        return arch == Arch.x86 || arch == Arch.x86_64;
    }

    public static boolean isDeviceArch(Arch arch) {
        return arch == Arch.thumbv7 || arch == Arch.arm64;
    }

    private File getPartialPListDir() {
        if (!this.partialPListDir.exists()) {
            this.partialPListDir.mkdirs();
        }
        return this.partialPListDir;
    }

    public List<SDK> getSDKs() {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return SDK.listSimulatorSDKs();
        }
        return SDK.listDeviceSDKs();
    }

    public IDevice getDevice() {
        return this.device;
    }

    @Override
    protected Launcher createLauncher(LaunchParameters launchParameters) throws IOException {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            return this.createIOSSimLauncher(launchParameters);
        }
        return this.createIOSDevLauncher(launchParameters);
    }

    private Launcher createIOSSimLauncher(LaunchParameters launchParameters) throws IOException {
        return new SimLauncherProcess(this.config.getLogger(), this.getAppDir(), this.getBundleId(), (IOSSimulatorLaunchParameters)launchParameters);
    }

    private Launcher createIOSDevLauncher(LaunchParameters launchParameters) throws IOException {
        IOSDeviceLaunchParameters deviceLaunchParameters = (IOSDeviceLaunchParameters)launchParameters;
        String deviceId = deviceLaunchParameters.getDeviceId();
        int forwardPort = deviceLaunchParameters.getForwardPort();
        AppLauncherCallback callback = deviceLaunchParameters.getAppPathCallback();
        if (deviceId == null) {
            String[] udids = IDevice.listUdids();
            if (udids.length == 0) {
                throw new RuntimeException("No devices connected");
            }
            if (udids.length > 1) {
                this.config.getLogger().warn("More than 1 device connected (%s). Using %s.", Arrays.asList(udids), udids[0]);
            }
            deviceId = udids[0];
        }
        this.device = new IDevice(deviceId);
        OutputStream out = null;
        out = launchParameters.getStdoutFifo() != null ? new OpenOnWriteFileOutputStream(launchParameters.getStdoutFifo()) : System.out;
        Map<String, String> env = launchParameters.getEnvironment();
        if (env == null) {
            env = new HashMap<String, String>();
        }
        env.put("OS_ACTIVITY_DT_MODE", "");
        AppLauncher launcher = new AppLauncher(this.device, this.getAppDir()){

            @Override
            protected void log(String s, Object ... args) {
                IOSTarget.this.config.getLogger().info(s, args);
            }
        }.stdout(out).closeOutOnExit(true).args(launchParameters.getArguments().toArray(new String[0])).env(env).forward(forwardPort).appLauncherCallback(callback).xcodePath(ToolchainUtil.findXcodePath()).uploadProgressCallback(new AfcClient.UploadProgressCallback(){
            boolean first = true;

            @Override
            public void success() {
                IOSTarget.this.config.getLogger().info("[100%%] Upload complete", new Object[0]);
            }

            @Override
            public void progress(File path, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().info("[  0%%] Beginning upload...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().info("[%3d%%] Uploading %s...", percentComplete, path);
            }

            @Override
            public void error(String message) {
            }
        }).installStatusCallback(new InstallationProxyClient.StatusCallback(){
            boolean first = true;

            @Override
            public void success() {
                IOSTarget.this.config.getLogger().info("[100%%] Install complete", new Object[0]);
            }

            @Override
            public void progress(String status, int percentComplete) {
                if (this.first) {
                    IOSTarget.this.config.getLogger().info("[  0%%] Beginning installation...", new Object[0]);
                }
                this.first = false;
                IOSTarget.this.config.getLogger().info("[%3d%%] %s", percentComplete, status);
            }

            @Override
            public void error(String message) {
            }
        });
        return new AppLauncherProcess(this.config.getLogger(), launcher, launchParameters);
    }

    @Override
    protected void doBuild(File outFile, List<String> ccArgs, List<File> objectFiles, List<String> libArgs) throws IOException {
        if (!this.config.getFrameworks().contains("UIKit")) {
            libArgs.add("-framework");
            libArgs.add("UIKit");
        }
        String minVersion = this.getMinimumOSVersion();
        int majorVersionNumber = -1;
        try {
            majorVersionNumber = Integer.parseInt(minVersion.substring(0, minVersion.indexOf(46)));
            int minMajorSupportedVersion = Integer.parseInt(minVersion.substring(0, this.config.getOs().getMinVersion().indexOf(46)));
            if (majorVersionNumber < minMajorSupportedVersion) {
                throw new CompilerException("MinimumOSVersion of " + minVersion + " is not supported. The minimum version for this platform is " + this.config.getOs().getMinVersion());
            }
        }
        catch (NumberFormatException e) {
            throw new CompilerException("Failed to get major version number from MinimumOSVersion string '" + minVersion + "'");
        }
        if (IOSTarget.isDeviceArch(this.arch)) {
            ccArgs.add("-miphoneos-version-min=" + minVersion);
            if (this.config.isDebug()) {
                ccArgs.add("-Wl,-no_pie");
            }
        } else {
            ccArgs.add("-mios-simulator-version-min=" + minVersion);
            if (this.config.getArch() == Arch.x86 || this.config.isDebug()) {
                ccArgs.add("-Wl,-no_pie");
            }
        }
        ccArgs.add("-isysroot");
        ccArgs.add(this.sdk.getRoot().getAbsolutePath());
        libArgs.add("-Xlinker");
        libArgs.add("-sdk_version");
        libArgs.add("-Xlinker");
        libArgs.add(this.sdk.getVersion());
        libArgs.add("-Xlinker");
        libArgs.add("-rpath");
        libArgs.add("-Xlinker");
        libArgs.add("@executable_path/Frameworks");
        libArgs.add("-Xlinker");
        libArgs.add("-rpath");
        libArgs.add("-Xlinker");
        libArgs.add("@loader_path/Frameworks");
        super.doBuild(outFile, ccArgs, objectFiles, libArgs);
    }

    protected void prepareInstall(File installDir) throws IOException {
        this.createInfoPList(installDir);
        this.generateDsym(installDir, this.getExecutable(), false);
        if (IOSTarget.isDeviceArch(this.arch)) {
            if (!this.config.isDebug()) {
                this.strip(installDir, this.getExecutable());
            }
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skipping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.ldid(this.entitlementsPList, installDir);
            } else {
                this.copyProvisioningProfile(this.provisioningProfile, installDir);
                boolean getTaskAllow = this.provisioningProfile.getType() == ProvisioningProfile.Type.Development;
                this.signFrameworks(this.signIdentity, installDir);
                this.provisionAppExtensions(this.signIdentity, installDir);
                this.signAppExtensions(this.signIdentity, installDir, getTaskAllow);
                this.codesignApp(this.signIdentity, this.getOrCreateEntitlementsPList(getTaskAllow, this.getBundleId()), installDir);
            }
        }
    }

    private void copyProvisioningProfile(ProvisioningProfile profile, File destDir) throws IOException {
        this.config.getLogger().info("Copying %s provisioning profile: %s (%s)", new Object[]{profile.getType(), profile.getName(), profile.getEntitlements().objectForKey("application-identifier")});
        FileUtils.copyFile(profile.getFile(), new File(destDir, "embedded.mobileprovision"));
    }

    @Override
    public void prepareLaunch() throws IOException {
        this.prepareLaunch(this.getAppDir());
    }

    protected void prepareLaunch(File appDir) throws IOException {
        super.doInstall(appDir, this.getExecutable(), appDir);
        this.createInfoPList(appDir);
        this.generateDsym(appDir, this.getExecutable(), true);
        if (IOSTarget.isDeviceArch(this.arch)) {
            if (this.config.isIosSkipSigning()) {
                this.config.getLogger().warn("Skiping code signing. The resulting app will be unsigned and will not run on unjailbroken devices", new Object[0]);
                this.ldid(this.getOrCreateEntitlementsPList(true, this.getBundleId()), appDir);
            } else {
                this.copyProvisioningProfile(this.provisioningProfile, appDir);
                boolean getTaskAllow = this.provisioningProfile.getType() == ProvisioningProfile.Type.Development;
                this.signFrameworks(this.signIdentity, appDir);
                this.provisionAppExtensions(this.signIdentity, appDir);
                this.signAppExtensions(this.signIdentity, appDir, getTaskAllow);
                this.codesignApp(this.signIdentity, this.getOrCreateEntitlementsPList(getTaskAllow, this.getBundleId()), appDir);
            }
        } else if (this.sdk.getVersionCode() >= 721664) {
            this.signFrameworks(SigningIdentity.ADHOC, appDir);
            this.signAppExtensions(SigningIdentity.ADHOC, appDir, true);
        }
    }

    private void signFrameworks(SigningIdentity identity, File appDir) throws IOException {
        File frameworksDir = new File(appDir, "Frameworks");
        if (frameworksDir.exists() && frameworksDir.isDirectory()) {
            for (File swiftLib : frameworksDir.listFiles()) {
                if (!swiftLib.getName().endsWith(".dylib")) continue;
                this.codesignSwiftLib(identity, swiftLib);
            }
            for (File framework : frameworksDir.listFiles()) {
                if (!framework.isDirectory() || !framework.getName().endsWith(".framework")) continue;
                this.codesignCustomFramework(identity, framework);
            }
        }
    }

    private void signAppExtensions(SigningIdentity identity, File appDir, boolean getTaskAllow) throws IOException {
        File extensionsDir = new File(appDir, "PlugIns");
        if (extensionsDir.exists() && extensionsDir.isDirectory()) {
            for (File extension : extensionsDir.listFiles()) {
                if (!extension.isDirectory() || !extension.getName().endsWith(".appex")) continue;
                File entitlements = null;
                if (this.provisioningProfile != null) {
                    String bundleId = this.provisioningProfile.getAppIdPrefix() + "." + this.getBundleId() + "." + extension.getName().replace(".appex", "");
                    entitlements = this.createEntitlementForAppEx(getTaskAllow, bundleId);
                }
                this.codesignAppExtension(identity, entitlements, extension);
            }
        }
    }

    private File createEntitlementForAppEx(boolean getTaskAllow, String bundleId) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "AppExtEntitlements.plist");
            NSDictionary dict = (NSDictionary)PropertyListParser.parse(IOUtils.toByteArray(this.getClass().getResourceAsStream("/Entitlements.plist")));
            dict.put("application-identifier", (Object)bundleId);
            dict.put("get-task-allow", (Object)getTaskAllow);
            PropertyListParser.saveAsXML((NSObject)dict, destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void provisionAppExtensions(SigningIdentity signIdentity, File installDir) throws IOException {
        File pluginsDir = new File(installDir, "PlugIns");
        for (AppExtension extension : this.config.getAppExtensions()) {
            String bundleId;
            ProvisioningProfile appExtProfile;
            String profileName = extension.getProfile();
            if (profileName != null) {
                appExtProfile = ProvisioningProfile.find(ProvisioningProfile.list(), profileName);
            } else {
                bundleId = this.getBundleId() + "." + extension.getName();
                appExtProfile = ProvisioningProfile.find(ProvisioningProfile.list(), signIdentity, bundleId);
            }
            if (appExtProfile != null) {
                File extPath = new File(pluginsDir, extension.getName() + ".appex");
                this.config.getLogger().info("Copying %s provisioning profile for : %s (%s)", new Object[]{appExtProfile.getType(), appExtProfile.getName(), appExtProfile.getEntitlements().objectForKey("application-identifier")});
                FileUtils.copyFile(appExtProfile.getFile(), new File(extPath, "embedded.mobileprovision"));
            }
            if (this.provisioningProfile != null) continue;
            bundleId = "*";
            if (this.config.getIosInfoPList() != null && this.config.getIosInfoPList().getBundleIdentifier() != null) {
                bundleId = this.config.getIosInfoPList().getBundleIdentifier();
            }
            this.provisioningProfile = ProvisioningProfile.find(ProvisioningProfile.list(), signIdentity, bundleId);
        }
    }

    private void codesignApp(SigningIdentity identity, File entitlementsPList, File appDir) throws IOException {
        this.config.getLogger().info("Code signing app using identity '%s' with fingerprint %s", identity.getName(), identity.getFingerprint());
        this.codesign(identity, entitlementsPList, false, false, true, appDir);
    }

    private void codesignSwiftLib(SigningIdentity identity, File swiftLib) throws IOException {
        this.config.getLogger().info("Code signing swift dylib '%s' using identity '%s' with fingerprint %s", swiftLib.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, null, false, true, false, swiftLib);
    }

    private void codesignCustomFramework(SigningIdentity identity, File frameworkDir) throws IOException {
        this.config.getLogger().info("Code signing framework '%s' using identity '%s' with fingerprint %s", frameworkDir.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, null, true, false, true, frameworkDir);
    }

    private void codesignAppExtension(SigningIdentity identity, File entitlementsPList, File extensionDir) throws IOException {
        this.config.getLogger().info("Code signing app-extension '%s' using identity '%s' with fingerprint %s", extensionDir.getName(), identity.getName(), identity.getFingerprint());
        this.codesign(identity, entitlementsPList, false, false, true, extensionDir);
    }

    private void codesign(SigningIdentity identity, File entitlementsPList, boolean preserveMetadata, boolean verbose, boolean allocate, File target) throws IOException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-f");
        args.add("-s");
        args.add(identity.getFingerprint());
        if (entitlementsPList != null) {
            args.add("--entitlements");
            args.add(entitlementsPList);
        }
        if (preserveMetadata) {
            args.add("--preserve-metadata=identifier,entitlements");
        }
        if (verbose) {
            args.add("--verbose");
        }
        args.add(target);
        Executor executor = new Executor(this.config.getLogger(), "codesign");
        if (allocate) {
            executor.addEnv("CODESIGN_ALLOCATE", ToolchainUtil.findXcodeCommand("codesign_allocate", "iphoneos"));
        }
        executor.args(args);
        executor.exec();
    }

    private void ldid(File entitlementsPList, File appDir) throws IOException {
        File executableFile = new File(appDir, this.getExecutable());
        this.config.getLogger().info("Pseudo-signing %s", executableFile.getAbsolutePath());
        ArrayList<Object> args = new ArrayList<Object>();
        if (entitlementsPList != null) {
            args.add("-S" + entitlementsPList.getAbsolutePath());
        } else {
            args.add("-S");
        }
        args.add(executableFile);
        new Executor(this.config.getLogger(), new File(this.config.getHome().getBinDir(), "ldid")).args(args).exec();
    }

    private File getOrCreateEntitlementsPList(boolean getTaskAllow, String bundleId) throws IOException {
        try {
            File destFile = new File(this.config.getTmpDir(), "Entitlements.plist");
            NSDictionary dict = null;
            dict = this.entitlementsPList != null ? (NSDictionary)PropertyListParser.parse(this.entitlementsPList) : (NSDictionary)PropertyListParser.parse(IOUtils.toByteArray(this.getClass().getResourceAsStream("/Entitlements.plist")));
            if (this.provisioningProfile != null) {
                NSDictionary profileEntitlements = this.provisioningProfile.getEntitlements();
                for (String key : profileEntitlements.allKeys()) {
                    if (dict.objectForKey(key) != null || this.excludedKeys.contains(key)) continue;
                    dict.put(key, profileEntitlements.objectForKey(key));
                }
                dict.put("application-identifier", (Object)(this.provisioningProfile.getAppIdPrefix() + "." + bundleId));
            }
            dict.put("get-task-allow", (Object)getTaskAllow);
            PropertyListParser.saveAsXML((NSObject)dict, destFile);
            return destFile;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void generateDsym(final File dir, final String executable, boolean copyToIndexedDir) throws IOException {
        final File dsymDir = new File(dir.getParentFile(), dir.getName() + ".dSYM");
        final File exePath = new File(dir, executable);
        FileUtils.deleteDirectory(dsymDir);
        final Process process = new Executor(this.config.getLogger(), "xcrun").args("dsymutil", "-o", dsymDir, exePath).execAsync();
        if (copyToIndexedDir) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    IOSTarget.this.copyToIndexedDir(dir, executable, dsymDir, exePath);
                }
            }.start();
        }
    }

    private void strip(File dir, String executable) throws IOException {
        new Executor(this.config.getLogger(), "xcrun").args("strip", "-x", new File(dir, executable)).exec();
    }

    @Override
    protected void doInstall(File installDir, String executable, File resourcesDir) throws IOException {
        super.doInstall(installDir, this.getExecutable(), resourcesDir);
        this.prepareInstall(installDir);
    }

    @Override
    protected Process doLaunch(LaunchParameters launchParameters) throws IOException {
        if (!this.config.isManuallyPreparedForLaunch()) {
            this.prepareLaunch();
        }
        Process process = super.doLaunch(launchParameters);
        return process;
    }

    @Override
    public List<Arch> getDefaultArchs() {
        return Arrays.asList(Arch.thumbv7, Arch.arm64);
    }

    @Override
    public void archive() throws IOException {
        this.config.getLogger().info("Creating IPA in %s", this.config.getInstallDir());
        this.config.getInstallDir().mkdirs();
        File tmpDir = new File(this.config.getInstallDir(), this.getExecutable() + ".app");
        FileUtils.deleteDirectory(tmpDir);
        tmpDir.mkdirs();
        super.doInstall(tmpDir, this.getExecutable(), tmpDir);
        this.prepareInstall(tmpDir);
        this.packageApplication(tmpDir);
    }

    private void packageApplication(File appDir) throws IOException {
        String[] plugins;
        File pluginsDir;
        String[] swiftLibs;
        File ipaFile = new File(this.config.getInstallDir(), this.getExecutable() + ".ipa");
        this.config.getLogger().info("Packaging IPA %s from %s", ipaFile.getName(), appDir.getName());
        File tmpDir = new File(this.config.getInstallDir(), "ipabuild");
        FileUtils.deleteDirectory(tmpDir);
        tmpDir.mkdirs();
        File payloadDir = new File(tmpDir, "Payload");
        payloadDir.mkdir();
        this.config.getLogger().info("Copying %s to %s", appDir.getName(), payloadDir);
        new Executor(this.config.getLogger(), "cp").args("-Rp", appDir, payloadDir).exec();
        File frameworksDir = new File(appDir, "Frameworks");
        if (frameworksDir.exists() && (swiftLibs = frameworksDir.list(new AndFileFilter(new PrefixFileFilter("libswift"), new SuffixFileFilter(".dylib")))) != null && swiftLibs.length > 0) {
            File swiftSupportDir = new File(tmpDir, "SwiftSupport");
            if (this.config.getOs() == OS.ios) {
                if (this.config.getArch().isArm()) {
                    swiftSupportDir = new File(swiftSupportDir, "iphoneos");
                }
            } else {
                swiftSupportDir = new File(swiftSupportDir, "mac");
            }
            swiftSupportDir.mkdirs();
            this.copySwiftLibs(Arrays.asList(swiftLibs), swiftSupportDir, false);
        }
        if ((pluginsDir = new File(appDir, "PlugIns")).exists() && (plugins = pluginsDir.list()) != null && plugins.length > 0) {
            String iStickersExtId = "com.apple.message-payload-provider";
            boolean hasStickers = false;
            for (String p : plugins) {
                File infoPlistFile = new File(new File(pluginsDir, p), "Info.plist");
                if (!infoPlistFile.exists()) continue;
                try {
                    NSDictionary infoPlist = (NSDictionary)PropertyListParser.parse(infoPlistFile);
                    NSDictionary extensionDict = (NSDictionary)infoPlist.get("NSExtension");
                    if (extensionDict == null) continue;
                    hasStickers |= "com.apple.message-payload-provider".equals(extensionDict.get("NSExtensionPointIdentifier").toJavaObject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hasStickers) {
                this.config.getLogger().info("Copying support files for Stickers app extension", new Object[0]);
                File xcodePath = new File(ToolchainUtil.findXcodePath());
                File stickersExtSupportStub = new File(xcodePath, "Platforms/iPhoneOS.platform/Library/Application Support/MessagesApplicationExtensionStub/MessagesApplicationExtensionStub");
                if (!stickersExtSupportStub.exists()) {
                    throw new FileNotFoundException("Stickers support: bi MessagesApplicationStub or MessagesApplicationExtensionStub found in " + new File(xcodePath, "Platforms/iPhoneOS.platform/Library/Application Support/").getAbsolutePath());
                }
                File stickersExtSupportDestDir = new File(tmpDir, "MessagesApplicationExtensionSupport");
                stickersExtSupportDestDir.mkdir();
                Files.copy(stickersExtSupportStub.toPath(), new File(stickersExtSupportDestDir, stickersExtSupportStub.getName()).toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
        this.config.getLogger().info("Zipping %s to %s", tmpDir, ipaFile);
        new Executor(Logger.NULL_LOGGER, "zip").wd(tmpDir).args("--symlinks", "--recurse-paths", ipaFile, ".").exec();
        this.config.getLogger().info("Deleting temp dir %s", tmpDir);
        FileUtils.deleteDirectory(tmpDir);
    }

    @Override
    protected boolean processDir(Resource resource, File dir, File destDir) throws IOException {
        if (dir.getName().endsWith(".atlas")) {
            destDir.mkdirs();
            ToolchainUtil.textureatlas(this.config, dir, destDir);
            return false;
        }
        if (dir.getName().endsWith(".xcassets")) {
            ToolchainUtil.actool(this.config, this.createPartialInfoPlistFile(dir), dir, this.getAppDir());
            return false;
        }
        return super.processDir(resource, dir, destDir);
    }

    @Override
    protected void copyFile(Resource resource, File file, File destDir) throws IOException {
        if (IOSTarget.isDeviceArch(this.arch) && !resource.isSkipPngCrush() && file.getName().toLowerCase().endsWith(".png")) {
            destDir.mkdirs();
            File outFile = new File(destDir, file.getName());
            ToolchainUtil.pngcrush(this.config, file, outFile);
        } else if (file.getName().toLowerCase().endsWith(".strings")) {
            destDir.mkdirs();
            File outFile = new File(destDir, file.getName());
            ToolchainUtil.compileStrings(this.config, file, outFile);
        } else if (file.getName().toLowerCase().endsWith(".storyboard")) {
            destDir.mkdirs();
            ToolchainUtil.ibtool(this.config, this.createPartialInfoPlistFile(file), file, destDir);
        } else if (file.getName().toLowerCase().endsWith(".xib")) {
            destDir.mkdirs();
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46)) + ".nib";
            File outFile = new File(destDir, fileName);
            ToolchainUtil.ibtool(this.config, this.createPartialInfoPlistFile(file), file, outFile);
        } else {
            super.copyFile(resource, file, destDir);
        }
    }

    private File createPartialInfoPlistFile(File f) throws IOException {
        File tmpFile = File.createTempFile(f.getName() + "_", ".plist", this.getPartialPListDir());
        tmpFile.delete();
        return tmpFile;
    }

    protected File getAppDir() {
        File dir = null;
        if (!this.config.isSkipInstall()) {
            dir = new File(this.config.getInstallDir(), this.getExecutable() + ".app");
            if (!dir.exists()) {
                dir = this.config.getInstallDir();
            }
        } else {
            dir = new File(this.config.getTmpDir(), this.getExecutable() + ".app");
            dir.mkdirs();
        }
        return dir;
    }

    @Override
    protected String getExecutable() {
        String bundleExecutable;
        if (this.config.getIosInfoPList() != null && (bundleExecutable = this.config.getIosInfoPList().getBundleExecutable()) != null) {
            return bundleExecutable;
        }
        return this.config.getExecutableName();
    }

    @Override
    protected String getBundleId() {
        String bundleIdentifier;
        if (this.config.getIosInfoPList() != null && (bundleIdentifier = this.config.getIosInfoPList().getBundleIdentifier()) != null) {
            return bundleIdentifier;
        }
        return this.config.getMainClass() != null ? this.config.getMainClass() : this.config.getExecutableName();
    }

    protected String getMinimumOSVersion() {
        String minVersion;
        if (this.config.getIosInfoPList() != null && (minVersion = this.config.getIosInfoPList().getMinimumOSVersion()) != null) {
            return minVersion;
        }
        return this.config.getOs().getMinVersion();
    }

    private void putIfAbsent(NSDictionary dict, String key, String value) {
        if (dict.objectForKey(key) == null) {
            dict.put(key, (Object)value);
        }
    }

    protected void customizeInfoPList(NSDictionary dict) {
        if (IOSTarget.isSimulatorArch(this.arch)) {
            dict.put("CFBundleSupportedPlatforms", new NSArray(new NSString("iPhoneSimulator")));
        } else {
            dict.put("CFBundleSupportedPlatforms", new NSArray(new NSString("iPhoneOS")));
            dict.put("DTPlatformVersion", (Object)this.sdk.getPlatformVersion());
            dict.put("DTPlatformBuild", (Object)this.sdk.getPlatformBuild());
            dict.put("DTSDKBuild", (Object)this.sdk.getBuild());
            try {
                File versionPListFile = new File(new File(ToolchainUtil.findXcodePath()).getParentFile(), "version.plist");
                NSDictionary versionPList = (NSDictionary)PropertyListParser.parse(versionPListFile);
                File xcodeInfoPListFile = new File(new File(ToolchainUtil.findXcodePath()).getParentFile(), "Info.plist");
                NSDictionary xcodeInfoPList = (NSDictionary)PropertyListParser.parse(xcodeInfoPListFile);
                NSString dtXcodeBuild = (NSString)versionPList.objectForKey("ProductBuildVersion");
                if (dtXcodeBuild == null) {
                    throw new NoSuchElementException("No ProductBuildVersion in " + versionPListFile.getAbsolutePath());
                }
                NSString dtXcode = (NSString)xcodeInfoPList.objectForKey("DTXcode");
                if (dtXcode == null) {
                    throw new NoSuchElementException("No DTXcode in " + xcodeInfoPListFile.getAbsolutePath());
                }
                this.putIfAbsent(dict, "DTXcode", dtXcode.toString());
                this.putIfAbsent(dict, "DTXcodeBuild", dtXcodeBuild.toString());
            }
            catch (Exception e) {
                this.config.getLogger().warn("Failed to read DTXcodeBuild/DTXcode from current Xcode install. Will use fake values. (%s: %s)", e.getClass().getName(), e.getMessage());
            }
            this.putIfAbsent(dict, "DTXcode", "0611");
            this.putIfAbsent(dict, "DTXcodeBuild", "6A2008a");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createInfoPList(File dir) throws IOException {
        NSDictionary dict = new NSDictionary();
        if (this.config.getIosInfoPList() != null && this.config.getIosInfoPList().getDictionary() != null) {
            NSDictionary infoPListDict = this.config.getIosInfoPList().getDictionary();
            for (String key : infoPListDict.allKeys()) {
                dict.put(key, infoPListDict.objectForKey(key));
            }
        } else {
            dict.put("CFBundleVersion", (Object)"1.0");
            dict.put("CFBundleExecutable", (Object)this.config.getExecutableName());
            dict.put("CFBundleName", (Object)this.config.getExecutableName());
            dict.put("CFBundleIdentifier", (Object)this.getBundleId());
            dict.put("CFBundlePackageType", (Object)"APPL");
            dict.put("LSRequiresIPhoneOS", (Object)true);
            NSObject supportedDeviceFamilies = this.sdk.getDefaultProperty("SUPPORTED_DEVICE_FAMILIES");
            if (supportedDeviceFamilies != null) {
                void var4_8;
                NSObject defFamilies;
                Object var4_5 = null;
                if (supportedDeviceFamilies instanceof NSString) {
                    defFamilies = (NSString)supportedDeviceFamilies;
                    String[] parts = ((NSString)defFamilies).toString().split(",");
                    NSArray nSArray = new NSArray(parts.length);
                    for (int i = 0; i < nSArray.count(); ++i) {
                        nSArray.setValue(i, new NSNumber(parts[i].trim()));
                    }
                } else {
                    defFamilies = (NSArray)supportedDeviceFamilies;
                    NSArray nSArray = new NSArray(((NSArray)defFamilies).count());
                    for (int i = 0; i < nSArray.count(); ++i) {
                        nSArray.setValue(i, new NSNumber(((NSArray)defFamilies).objectAtIndex(i).toString()));
                    }
                }
                dict.put("UIDeviceFamily", (NSObject)var4_8);
            }
            dict.put("UISupportedInterfaceOrientations", new NSArray(new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")));
            dict.put("UISupportedInterfaceOrientations~ipad", new NSArray(new NSString("UIInterfaceOrientationPortrait"), new NSString("UIInterfaceOrientationLandscapeLeft"), new NSString("UIInterfaceOrientationLandscapeRight"), new NSString("UIInterfaceOrientationPortraitUpsideDown")));
            dict.put("UIRequiredDeviceCapabilities", new NSArray(new NSString("armv7")));
        }
        dict.put("DTPlatformName", (Object)this.sdk.getPlatformName());
        dict.put("DTSDKName", (Object)this.sdk.getCanonicalName());
        for (File file : FileUtils.listFiles(this.getPartialPListDir(), new String[]{"plist"}, false)) {
            try {
                NSDictionary d = (NSDictionary)PropertyListParser.parse(file);
                dict.putAll(d);
            }
            catch (Exception e) {
                throw new CompilerException(e);
            }
        }
        if (dict.objectForKey("MinimumOSVersion") == null) {
            dict.put("MinimumOSVersion", (Object)"6.0");
        }
        this.customizeInfoPList(dict);
        NSDictionary newDict = new NSDictionary();
        if (dict.objectForKey("CFBundleShortVersionString") != null) {
            newDict.put("CFBundleShortVersionString", dict.objectForKey("CFBundleShortVersionString"));
            dict.remove("CFBundleShortVersionString");
        }
        if (dict.objectForKey("CFBundleVersion") != null) {
            newDict.put("CFBundleVersion", dict.objectForKey("CFBundleVersion"));
            dict.remove("CFBundleVersion");
        }
        for (String key : dict.allKeys()) {
            newDict.put(key, dict.objectForKey(key));
        }
        File file = new File(this.config.getTmpDir(), "Info.plist");
        PropertyListParser.saveAsBinary((NSObject)newDict, file);
        this.config.getLogger().info("Installing Info.plist to %s", dir);
        FileUtils.copyFile(file, new File(dir, file.getName()));
    }

    @Override
    public void init(Config config) {
        super.init(config);
        if (config.getArch() == null) {
            this.arch = Arch.thumbv7;
        } else {
            if (!IOSTarget.isSimulatorArch(config.getArch()) && !IOSTarget.isDeviceArch(config.getArch())) {
                throw new IllegalArgumentException("Arch '" + (Object)((Object)config.getArch()) + "' is unsupported for iOS target");
            }
            this.arch = config.getArch();
        }
        if (config.getIosInfoPList() != null) {
            config.getIosInfoPList().parse(config.getProperties());
        }
        if (IOSTarget.isDeviceArch(this.arch) && !config.isSkipLinking() && !config.isIosSkipSigning()) {
            this.signIdentity = config.getIosSignIdentity();
            this.provisioningProfile = config.getIosProvisioningProfile();
            String bundleId = "*";
            if (config.getIosInfoPList() != null && config.getIosInfoPList().getBundleIdentifier() != null) {
                bundleId = config.getIosInfoPList().getBundleIdentifier();
            }
            if (this.signIdentity == null && this.provisioningProfile == null) {
                Pair<SigningIdentity, ProvisioningProfile> pair = ProvisioningProfile.find(ProvisioningProfile.list(), SigningIdentity.list("/(?i)iPhone Developer|iOS Development/"), bundleId);
                this.signIdentity = pair.getLeft();
                this.provisioningProfile = pair.getRight();
            } else if (this.signIdentity == null) {
                this.signIdentity = SigningIdentity.find(SigningIdentity.list(), "/(?i)iPhone Developer|iOS Development/", this.provisioningProfile);
            } else if (this.provisioningProfile == null) {
                this.provisioningProfile = ProvisioningProfile.find(ProvisioningProfile.list(), this.signIdentity, bundleId);
            }
        }
        String sdkVersion = config.getIosSdkVersion();
        List<SDK> sdks = this.getSDKs();
        if (sdkVersion == null) {
            if (sdks.isEmpty()) {
                throw new IllegalArgumentException("No " + (IOSTarget.isDeviceArch(this.arch) ? "device" : "simulator") + " SDKs installed");
            }
            Collections.sort(sdks);
            this.sdk = sdks.get(sdks.size() - 1);
        } else {
            for (SDK sdk : sdks) {
                if (!sdk.getVersion().equals(sdkVersion)) continue;
                this.sdk = sdk;
                break;
            }
            if (this.sdk == null) {
                throw new IllegalArgumentException("No SDK found matching version string " + sdkVersion);
            }
        }
        this.entitlementsPList = config.getIosEntitlementsPList();
        this.partialPListDir = new File(config.getTmpDir(), "partial-plists");
        try {
            if (this.partialPListDir.exists()) {
                FileUtils.cleanDirectory(this.partialPListDir);
            }
        }
        catch (IOException e) {
            throw new CompilerException(e);
        }
    }

    @Override
    public OS getOs() {
        return OS.ios;
    }

    @Override
    public boolean canLaunchInPlace() {
        return false;
    }

    private void copyToIndexedDir(File dir, String executable, File dsymDir, File exePath) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        File indexedDir = new File(System.getProperty("user.home"), "Library/Developer/Xcode/DerivedData/RoboVM/Build/Products/" + FilenameUtils.removeExtension(dir.getName()) + "_" + sdf.format(new Date()));
        indexedDir.mkdirs();
        File indexedDSymDir = new File(indexedDir, dsymDir.getName());
        File indexedAppDir = new File(indexedDir, dir.getName());
        indexedAppDir.mkdirs();
        try {
            FileUtils.copyFile(exePath, new File(indexedAppDir, executable));
        }
        catch (IOException e) {
            this.config.getLogger().error("Failed to copy %s to indexed dir %s: %s", exePath.getAbsolutePath(), indexedAppDir.getAbsolutePath(), e.getMessage());
        }
        try {
            FileUtils.copyDirectory(dsymDir, indexedDSymDir);
        }
        catch (IOException e) {
            this.config.getLogger().error("Failed to copy %s to indexed dir %s: %s", dsymDir.getAbsolutePath(), indexedDir.getAbsolutePath(), e.getMessage());
        }
        ArrayList<File> dirs = new ArrayList<File>(Arrays.asList(indexedDir.getParentFile().listFiles(new AndFileFilter(new PrefixFileFilter(FilenameUtils.removeExtension(dir.getName())), new RegexFileFilter(".*_\\d{14}")))));
        Collections.sort(dirs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.lastModified(), o2.lastModified());
            }
        });
        if (dirs.size() > 3) {
            for (File f : dirs.subList(0, dirs.size() - 3)) {
                try {
                    FileUtils.deleteDirectory(f);
                }
                catch (IOException e) {
                    this.config.getLogger().error("Failed to delete diretcory %s", f.getAbsolutePath(), e.getMessage());
                }
            }
        }
    }
}

