/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.trampoline;

import java.io.Serializable;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;

public abstract class Trampoline
implements Comparable<Trampoline>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String callingClass;
    protected final String target;

    protected Trampoline(String callingClass, String target) {
        this.callingClass = callingClass;
        this.target = target;
    }

    public String getCallingClass() {
        return this.callingClass;
    }

    public String getTarget() {
        return this.target;
    }

    public FunctionRef getFunctionRef() {
        return new FunctionRef(this.getFunctionName(), this.getFunctionType());
    }

    public String getFunctionName() {
        return this.toString();
    }

    public abstract FunctionType getFunctionType();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callingClass == null ? 0 : this.callingClass.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trampoline other = (Trampoline)obj;
        if (this.callingClass == null ? other.callingClass != null : !this.callingClass.equals(other.callingClass)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public int compareTo(Trampoline o) {
        int c = this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        if (c == 0 && (c = this.callingClass.compareTo(o.callingClass)) == 0) {
            c = this.target.compareTo(o.target);
        }
        return c;
    }

    public String toString() {
        return Symbols.trampolineSymbol(this, this.getCallingClass(), this.getTarget());
    }
}

