/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;

class AsyncExecutor
implements Executor {
    private static final AtomicInteger threadCounter = new AtomicInteger();
    private ExecuteStreamHandler streamHandler = new PumpStreamHandler();
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private final CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
    private ProcessDestroyer processDestroyer;

    public AsyncExecutor() {
        this.exitValues = new int[0];
    }

    @Override
    public ExecuteStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    @Override
    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    @Override
    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public void setWatchdog(ExecuteWatchdog watchDog) {
        this.watchdog = watchDog;
    }

    @Override
    public ProcessDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    @Override
    public void setProcessDestroyer(ProcessDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
    }

    public Process executeAsync(CommandLine command) throws IOException {
        return this.executeAsync(command, (Map<String, String>)null);
    }

    public Process executeAsync(CommandLine command, Map<String, String> environment) throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        return this.executeInternal(command, environment, this.workingDirectory, this.streamHandler, null);
    }

    public Process executeAsync(CommandLine command, ExecuteResultHandler handler) throws IOException {
        return this.executeAsync(command, null, handler);
    }

    public Process executeAsync(CommandLine command, Map<String, String> environment, ExecuteResultHandler handler) throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        return this.executeInternal(command, environment, this.workingDirectory, this.streamHandler, handler);
    }

    @Override
    public void setExitValue(int value) {
        this.setExitValues(new int[]{value});
    }

    @Override
    public void setExitValues(int[] values) {
        this.exitValues = values == null ? null : (int[])values.clone();
    }

    @Override
    public boolean isFailure(int exitValue) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(exitValue);
        }
        for (int i = 0; i < this.exitValues.length; ++i) {
            if (this.exitValues[i] != exitValue) continue;
            return false;
        }
        return true;
    }

    protected Process launch(CommandLine command, Map<String, String> env, File dir) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException("CommandLauncher can not be null");
        }
        if (dir != null && !dir.exists()) {
            throw new IOException(dir + " doesn't exist.");
        }
        return this.launcher.exec(command, env, dir);
    }

    private void closeStreams(Process process) throws IOException {
        IOException caught = null;
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            caught = e;
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            caught = e;
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }

    private Process executeInternal(CommandLine command, Map<String, String> environment, File dir, final ExecuteStreamHandler streams, final ExecuteResultHandler handler) throws IOException {
        final Process process = this.launch(command, environment, dir);
        try {
            streams.setProcessInputStream(process.getOutputStream());
            streams.setProcessOutputStream(process.getInputStream());
            streams.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        streams.start();
        if (this.getProcessDestroyer() != null) {
            this.getProcessDestroyer().add(process);
        }
        if (this.watchdog != null) {
            this.watchdog.start(process);
        }
        Thread waitForThread = new Thread(AsyncExecutor.class.getSimpleName() + ".waitFor-" + threadCounter.incrementAndGet()){

            @Override
            public void run() {
                int exitValue = -559038737;
                try {
                    try {
                        exitValue = process.waitFor();
                    }
                    catch (InterruptedException e) {
                        process.destroy();
                    }
                    if (AsyncExecutor.this.watchdog != null) {
                        AsyncExecutor.this.watchdog.stop();
                    }
                    streams.stop();
                    AsyncExecutor.this.closeStreams(process);
                    if (AsyncExecutor.this.watchdog != null) {
                        try {
                            AsyncExecutor.this.watchdog.checkException();
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    if (handler != null) {
                        handler.onProcessComplete(exitValue);
                    }
                }
                catch (ExecuteException e) {
                    if (handler != null) {
                        handler.onProcessFailed(e);
                    }
                }
                catch (Exception e) {
                    if (handler != null) {
                        handler.onProcessFailed(new ExecuteException("Execution failed", exitValue, e));
                    }
                }
                finally {
                    if (AsyncExecutor.this.getProcessDestroyer() != null) {
                        AsyncExecutor.this.getProcessDestroyer().remove(process);
                    }
                }
            }
        };
        waitForThread.setDaemon(true);
        waitForThread.start();
        return process;
    }

    @Override
    public int execute(CommandLine command) throws ExecuteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int execute(CommandLine command, Map environment) throws ExecuteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(CommandLine command, ExecuteResultHandler handler) throws ExecuteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(CommandLine command, Map environment, ExecuteResultHandler handler) throws ExecuteException, IOException {
        throw new UnsupportedOperationException();
    }
}

