/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.binding.DebugServerClientRef;
import org.robovm.libimobiledevice.binding.DebugServerClientRefOut;
import org.robovm.libimobiledevice.binding.DebugServerError;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;

public class DebugServerClient
implements AutoCloseable {
    protected DebugServerClientRef ref;

    DebugServerClient(DebugServerClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugServerClient(IDevice device, String label) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        DebugServerClientRefOut refOut = new DebugServerClientRefOut();
        try {
            DebugServerClient.checkResult(LibIMobileDevice.debugserver_client_start_service(device.getRef(), refOut, label));
            this.ref = refOut.getValue();
        }
        finally {
            refOut.delete();
        }
    }

    public DebugServerClient(IDevice device, LockdowndServiceDescriptor descriptor) {
        this(device, descriptor.toDescriptorStruct());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugServerClient(IDevice device, LockdowndServiceDescriptorStruct descriptor) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        DebugServerClientRefOut refOut = new DebugServerClientRefOut();
        try {
            DebugServerClient.checkResult(LibIMobileDevice.debugserver_client_new(device.getRef(), descriptor, refOut));
            this.ref = refOut.getValue();
        }
        finally {
            refOut.delete();
        }
    }

    protected DebugServerClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.debugserver_client_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(byte[] buffer, int offset, int count) {
        this.checkArrayBounds(buffer, offset, count);
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
            System.arraycopy(buffer, offset, data, 0, count);
        }
        IntOut bytesSentOut = new IntOut();
        try {
            DebugServerClient.checkResult(LibIMobileDevice.debugserver_client_send(this.getRef(), data, count, bytesSentOut));
            int n = bytesSentOut.getValue();
            return n;
        }
        finally {
            bytesSentOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] buffer, int offset, int count, int timeout) {
        this.checkArrayBounds(buffer, offset, count);
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
        }
        IntOut bytesReceivedOut = new IntOut();
        try {
            DebugServerClient.checkResult(LibIMobileDevice.debugserver_client_receive_with_timeout(this.getRef(), data, count, bytesReceivedOut, timeout), DebugServerError.DEBUGSERVER_E_TIMEOUT);
            int bytesRead = bytesReceivedOut.getValue();
            if (bytesRead > 0 && data != buffer) {
                System.arraycopy(data, 0, buffer, offset, bytesRead);
            }
            int n = bytesRead;
            return n;
        }
        finally {
            bytesReceivedOut.delete();
        }
    }

    private void checkArrayBounds(byte[] buffer, int offset, int count) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    private static void checkResult(DebugServerError result) {
        if (result != DebugServerError.DEBUGSERVER_E_SUCCESS) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }

    static void checkResult(DebugServerError result, DebugServerError allowed) {
        if (result != DebugServerError.DEBUGSERVER_E_SUCCESS && result != allowed) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }
}

