/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.PointsToSet;
import soot.SootField;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.MethodRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.Union;

public class StmtRWSet
extends RWSet {
    protected Object field;
    protected PointsToSet base;
    protected boolean callsNative = false;

    public String toString() {
        return "[Field: " + this.field + this.base + "]\n";
    }

    @Override
    public int size() {
        Set globals = this.getGlobals();
        Set fields = this.getFields();
        if (globals == null) {
            if (fields == null) {
                return 0;
            }
            return fields.size();
        }
        if (fields == null) {
            return globals.size();
        }
        return globals.size() + fields.size();
    }

    @Override
    public boolean getCallsNative() {
        return this.callsNative;
    }

    @Override
    public boolean setCallsNative() {
        boolean ret = !this.callsNative;
        this.callsNative = true;
        return ret;
    }

    @Override
    public Set getGlobals() {
        if (this.base == null) {
            HashSet<Object> ret = new HashSet<Object>();
            ret.add(this.field);
            return ret;
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Set getFields() {
        if (this.base != null) {
            HashSet<Object> ret = new HashSet<Object>();
            ret.add(this.field);
            return ret;
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public PointsToSet getBaseForField(Object f) {
        if (this.field.equals(f)) {
            return this.base;
        }
        return null;
    }

    @Override
    public boolean hasNonEmptyIntersection(RWSet other) {
        if (this.field == null) {
            return false;
        }
        if (other instanceof StmtRWSet) {
            StmtRWSet o = (StmtRWSet)other;
            if (!this.field.equals(o.field)) {
                return false;
            }
            if (this.base == null) {
                return o.base == null;
            }
            return Union.hasNonEmptyIntersection(this.base, o.base);
        }
        if (other instanceof MethodRWSet) {
            if (this.base == null) {
                return other.getGlobals().contains(this.field);
            }
            return Union.hasNonEmptyIntersection(this.base, other.getBaseForField(this.field));
        }
        return other.hasNonEmptyIntersection(this);
    }

    @Override
    public boolean union(RWSet other) {
        throw new RuntimeException("Can't do that");
    }

    @Override
    public boolean addGlobal(SootField global) {
        if (this.field != null || this.base != null) {
            throw new RuntimeException("Can't do that");
        }
        this.field = global;
        return true;
    }

    @Override
    public boolean addFieldRef(PointsToSet otherBase, Object field) {
        if (this.field != null || this.base != null) {
            throw new RuntimeException("Can't do that");
        }
        this.field = field;
        this.base = otherBase;
        return true;
    }

    @Override
    public boolean isEquivTo(RWSet other) {
        if (!(other instanceof StmtRWSet)) {
            return false;
        }
        StmtRWSet o = (StmtRWSet)other;
        if (this.callsNative != o.callsNative) {
            return false;
        }
        if (!this.field.equals(o.field)) {
            return false;
        }
        if (this.base instanceof FullObjectSet && o.base instanceof FullObjectSet) {
            return true;
        }
        return this.base == o.base;
    }
}

