/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class ArrayNumberer<E>
implements IterableNumberer<E> {
    Numberable[] numberToObj = new Numberable[1024];
    int lastNumber = 0;

    @Override
    public void add(E oo) {
        Numberable o = (Numberable)oo;
        if (o.getNumber() != 0) {
            return;
        }
        ++this.lastNumber;
        if (this.lastNumber >= this.numberToObj.length) {
            Numberable[] newnto = new Numberable[this.numberToObj.length * 2];
            System.arraycopy(this.numberToObj, 0, newnto, 0, this.numberToObj.length);
            this.numberToObj = newnto;
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
    }

    @Override
    public long get(E oo) {
        if (oo == null) {
            return 0L;
        }
        Numberable o = (Numberable)oo;
        int ret = o.getNumber();
        if (ret == 0) {
            throw new RuntimeException("unnumbered: " + o);
        }
        return ret;
    }

    @Override
    public E get(long number) {
        if (number == 0L) {
            return null;
        }
        Numberable ret = this.numberToObj[(int)number];
        if (ret == null) {
            throw new RuntimeException("no object with number " + number);
        }
        return (E)ret;
    }

    @Override
    public int size() {
        return this.lastNumber;
    }

    @Override
    public Iterator<E> iterator() {
        return new NumbererIterator();
    }

    final class NumbererIterator
    implements Iterator<E> {
        int cur = 1;

        NumbererIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.cur < ArrayNumberer.this.numberToObj.length && ArrayNumberer.this.numberToObj[this.cur] != null;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayNumberer.this.numberToObj[this.cur++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

