/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.robovm.compiler.Access;
import org.robovm.compiler.AppCompiler;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.MethodInfo;
import org.robovm.compiler.clazz.Path;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.hash.HashTableGenerator;
import org.robovm.compiler.hash.ModifiedUtf8HashFunction;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.ArrayConstant;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.ConstantGetelementptr;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Global;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.plugin.CompilerPlugin;
import org.robovm.llvm.Context;
import org.robovm.llvm.Module;
import org.robovm.llvm.PassManager;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetMachine;
import org.robovm.llvm.binding.CodeGenFileType;
import org.robovm.llvm.binding.RelocMode;

public class Linker {
    private static final TypeInfo[] EMPTY_TYPE_INFOS = new TypeInfo[0];
    private final Config config;
    private final Map<String, byte[]> runtimeData = new HashMap<String, byte[]>();

    public Linker(Config config) {
        this.config = config;
    }

    public void addRuntimeData(String id, byte[] data) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(data, "data");
        this.runtimeData.put(id, data);
    }

    private ArrayConstant runtimeDataToBytes() throws UnsupportedEncodingException {
        LinkedList<byte[]> dataList = new LinkedList<byte[]>();
        int length = 4;
        for (Map.Entry<String, byte[]> entry : this.runtimeData.entrySet()) {
            dataList.add(entry.getKey().getBytes("UTF8"));
            length += 4 + ((byte[])dataList.getLast()).length;
            dataList.add(entry.getValue());
            length += 4 + ((byte[])dataList.getLast()).length;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[length + 4]).order(this.config.getArch().getByteOrder());
        bb.putInt(length);
        bb.putInt(this.runtimeData.size());
        for (byte[] b : dataList) {
            bb.putInt(b.length);
            bb.put(b);
        }
        return new ArrayConstantBuilder(Type.I8).add(bb.array()).build();
    }

    /*
     * WARNING - void declaration
     */
    public void link(Set<Clazz> classes) throws IOException {
        File f;
        void var23_32;
        void var22_27;
        for (CompilerPlugin plugin : this.config.getCompilerPlugins()) {
            plugin.beforeLinker(this.config, this, classes);
        }
        Arch arch = this.config.getArch();
        OS os = this.config.getOs();
        TreeSet<Clazz> linkClasses = new TreeSet<Clazz>(classes);
        this.config.getLogger().info("Linking %d classes (%s %s %s)", new Object[]{linkClasses.size(), os, arch, this.config.isDebug() ? "debug" : "release"});
        ModuleBuilder mb = new ModuleBuilder();
        mb.addInclude(this.getClass().getClassLoader().getResource(String.format("header-%s-%s.ll", new Object[]{os.getFamily(), arch})));
        mb.addInclude(this.getClass().getClassLoader().getResource("header.ll"));
        mb.addGlobal(new Global("_bcRuntimeData", this.runtimeDataToBytes()));
        ArrayConstantBuilder staticLibs = new ArrayConstantBuilder(Type.I8_PTR);
        for (Config.Lib lib : this.config.getLibs()) {
            String p = lib.getValue();
            if (!p.endsWith(".a")) continue;
            String libName = (p = new File(p).getName()).substring(0, p.length() - 2);
            if (libName.startsWith("lib")) {
                libName = libName.substring(3);
            }
            staticLibs.add(mb.getString(libName));
        }
        staticLibs.add(new NullConstant(Type.I8_PTR));
        mb.addGlobal(new Global("_bcStaticLibs", new ConstantGetelementptr(mb.newGlobal(staticLibs.build()).ref(), 0, 0)));
        HashTableGenerator<String, ConstantBitcast> bcpHashGen = new HashTableGenerator<String, ConstantBitcast>(new ModifiedUtf8HashFunction());
        HashTableGenerator<String, ConstantBitcast> cpHashGen = new HashTableGenerator<String, ConstantBitcast>(new ModifiedUtf8HashFunction());
        int classCount = 0;
        HashMap<ClazzInfo, TypeInfo> typeInfos = new HashMap<ClazzInfo, TypeInfo>();
        for (Clazz clazz : linkClasses) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.clazz = clazz;
            typeInfo.id = classCount++;
            typeInfos.put(clazz.getClazzInfo(), typeInfo);
            StructureConstant infoErrorStruct = this.createClassInfoErrorStruct(mb, clazz.getClazzInfo());
            Global info = null;
            if (infoErrorStruct == null) {
                info = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), Linkage.external, Type.I8_PTR, false);
            } else {
                typeInfo.error = true;
                info = new Global(Symbols.infoStructSymbol(clazz.getInternalName()), infoErrorStruct);
            }
            mb.addGlobal(info);
            if (clazz.isInBootClasspath()) {
                bcpHashGen.put(clazz.getInternalName(), new ConstantBitcast(info.ref(), Type.I8_PTR));
                continue;
            }
            cpHashGen.put(clazz.getInternalName(), new ConstantBitcast(info.ref(), Type.I8_PTR));
        }
        mb.addGlobal(new Global("_bcBootClassesHash", new ConstantGetelementptr(mb.newGlobal(bcpHashGen.generate(), true).ref(), 0, 0)));
        mb.addGlobal(new Global("_bcClassesHash", new ConstantGetelementptr(mb.newGlobal(cpHashGen.generate(), true).ref(), 0, 0)));
        ArrayConstantBuilder bootClasspathValues = new ArrayConstantBuilder(Type.I8_PTR);
        ArrayConstantBuilder classpathValues = new ArrayConstantBuilder(Type.I8_PTR);
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.addAll(this.config.getClazzes().getPaths());
        allPaths.addAll(this.config.getResourcesPaths());
        for (Path path : allPaths) {
            String entryName = null;
            entryName = this.config.isSkipInstall() && this.config.getTarget().canLaunchInPlace() ? path.getFile().getAbsolutePath() : this.config.getTarget().getInstallRelativeArchivePath(path);
            if (path.isInBootClasspath()) {
                bootClasspathValues.add(mb.getString(entryName));
                continue;
            }
            classpathValues.add(mb.getString(entryName));
        }
        bootClasspathValues.add(new NullConstant(Type.I8_PTR));
        classpathValues.add(new NullConstant(Type.I8_PTR));
        mb.addGlobal(new Global("_bcBootclasspath", new ConstantGetelementptr(mb.newGlobal(bootClasspathValues.build()).ref(), 0, 0)));
        mb.addGlobal(new Global("_bcClasspath", new ConstantGetelementptr(mb.newGlobal(classpathValues.build()).ref(), 0, 0)));
        if (this.config.getMainClass() != null) {
            mb.addGlobal(new Global("_bcMainClass", mb.getString(this.config.getMainClass())));
        }
        ModuleBuilder[] mbs = new ModuleBuilder[this.config.getThreads() + 1];
        FunctionRef[] stubRefs = new FunctionRef[mbs.length];
        ArrayConstantBuilder stubRefsArray = new ArrayConstantBuilder(Type.I8_PTR);
        mbs[0] = mb;
        for (int i = 1; i < mbs.length; ++i) {
            mbs[i] = new ModuleBuilder();
            mbs[i].addInclude(this.getClass().getClassLoader().getResource(String.format("header-%s-%s.ll", new Object[]{os.getFamily(), arch})));
            mbs[i].addInclude(this.getClass().getClassLoader().getResource("header.ll"));
            Function fn = new FunctionBuilder("_stripped_method" + i, new FunctionType((Type)Type.VOID, Types.ENV_PTR)).linkage(Linkage.external).build();
            Functions.call(fn, (Value)Functions.BC_THROW_NO_SUCH_METHOD_ERROR, fn.getParameterRef(0), mbs[i].getString("Method has been stripped out of the executable"));
            fn.add(new Unreachable());
            mbs[i].addFunction(fn);
            mb.addFunctionDeclaration(new FunctionDeclaration(fn.ref()));
            stubRefs[i] = fn.ref();
            stubRefsArray.add(new ConstantBitcast(fn.ref(), Type.I8_PTR));
        }
        stubRefsArray.add(new NullConstant(Type.I8_PTR));
        mb.addGlobal(new Global("_bcStrippedMethodStubs", stubRefsArray.build()));
        Random rnd = new Random();
        this.buildTypeInfos(typeInfos);
        HashSet<String> checkcasts = new HashSet<String>();
        HashSet<String> instanceofs = new HashSet<String>();
        HashSet<String> invokes = new HashSet<String>();
        for (Clazz clazz : linkClasses) {
            ClazzInfo clazzInfo = clazz.getClazzInfo();
            checkcasts.addAll(clazzInfo.getCheckcasts());
            instanceofs.addAll(clazzInfo.getInstanceofs());
            invokes.addAll(clazzInfo.getInvokes());
        }
        HashSet<String> reachableMethods = new HashSet<String>();
        for (Triple<String, String, String> triple : this.config.getDependencyGraph().findReachableMethods()) {
            reachableMethods.add(triple.getLeft() + "." + triple.getMiddle() + triple.getRight());
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Clazz clazz : linkClasses) {
            int mbIdx = rnd.nextInt(mbs.length - 1) + 1;
            ClazzInfo ci = clazz.getClazzInfo();
            for (MethodInfo mi : ci.getMethods()) {
                if (mi.isAbstract()) continue;
                ++var22_27;
                if (!reachableMethods.contains(clazz.getInternalName() + "." + mi.getName() + mi.getDesc())) {
                    this.createStrippedMethodStub(stubRefs[mbIdx], mbs[mbIdx], clazz, mi);
                    continue;
                }
                ++var23_32;
            }
            TypeInfo typeInfo = (TypeInfo)typeInfos.get(ci);
            if (typeInfo.error) {
                mb.addGlobal(new Global(Symbols.typeInfoSymbol(clazz.getInternalName()), new StructureConstantBuilder().add(new IntegerConstant(typeInfo.id)).add(new IntegerConstant(0)).add(new IntegerConstant(-1)).add(new IntegerConstant(0)).add(new IntegerConstant(0)).build()));
            } else {
                int[] classIds = new int[typeInfo.classTypes.length];
                for (int i = 0; i < typeInfo.classTypes.length; ++i) {
                    classIds[i] = typeInfo.classTypes[i].id;
                }
                int[] interfaceIds = new int[typeInfo.interfaceTypes.length];
                for (int i = 0; i < typeInfo.interfaceTypes.length; ++i) {
                    interfaceIds[i] = typeInfo.interfaceTypes[i].id;
                }
                mb.addGlobal(new Global(Symbols.typeInfoSymbol(clazz.getInternalName()), new StructureConstantBuilder().add(new IntegerConstant(typeInfo.id)).add(new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20)).add(new IntegerConstant(-1)).add(new IntegerConstant(typeInfo.classTypes.length)).add(new IntegerConstant(typeInfo.interfaceTypes.length)).add(new ArrayConstantBuilder(Type.I32).add(classIds).build()).add(new ArrayConstantBuilder(Type.I32).add(interfaceIds).build()).build()));
                if (!this.config.isDebug() && !ci.isInterface() && !ci.isFinal() && typeInfo.children.isEmpty()) {
                    for (MethodInfo mi : ci.getMethods()) {
                        String name = mi.getName();
                        if (name.equals("<clinit>") || name.equals("<init>") || mi.isPrivate() || mi.isStatic() || mi.isFinal() || mi.isAbstract() || !invokes.contains(clazz.getInternalName() + "." + name + mi.getDesc()) || !reachableMethods.contains(clazz.getInternalName() + "." + name + mi.getDesc())) continue;
                        mbs[mbIdx].addFunction(this.createLookup(mbs[mbIdx], ci, mi));
                    }
                }
            }
            if (checkcasts.contains(clazz.getInternalName())) {
                mbs[mbIdx].addFunction(this.createCheckcast(mbs[mbIdx], clazz, typeInfo));
            }
            if (!instanceofs.contains(clazz.getInternalName())) continue;
            mbs[mbIdx].addFunction(this.createInstanceof(mbs[mbIdx], clazz, typeInfo));
        }
        this.config.getLogger().info("%d methods out of %d included in the executable", (int)var23_32, (int)var22_27);
        ArrayList<File> objectFiles = new ArrayList<File>();
        this.generateMachineCode(this.config, mbs, objectFiles);
        for (Clazz clazz : linkClasses) {
            objectFiles.add(this.config.getOFile(clazz));
        }
        for (Clazz clazz : linkClasses) {
            f = this.config.getLinesOFile(clazz);
            if (!f.exists() || f.length() <= 0L) continue;
            objectFiles.add(f);
        }
        if (this.config.isDebug()) {
            for (Clazz clazz : linkClasses) {
                f = this.config.getDebugInfoOFile(clazz);
                if (!f.exists() || f.length() <= 0L) continue;
                objectFiles.add(f);
            }
        }
        this.config.getTarget().build(objectFiles);
    }

    private void generateMachineCode(final Config config, ModuleBuilder[] mbs, final List<File> objectFiles) throws IOException {
        config.getTmpDir().mkdirs();
        Executor executor = config.getThreads() <= 1 ? AppCompiler.SAME_THREAD_EXECUTOR : Executors.newFixedThreadPool(config.getThreads());
        final List errors = Collections.synchronizedList(new ArrayList());
        int i = 0;
        while (i < mbs.length) {
            final ModuleBuilder mb = mbs[i];
            final int num = i++;
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File linkerO = Linker.this.generateMachineCode(config, mb, num);
                        List list = objectFiles;
                        synchronized (list) {
                            objectFiles.add(linkerO);
                        }
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
            });
        }
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.get(0);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CompilerException(t);
        }
    }

    private File generateMachineCode(Config config, ModuleBuilder mb, int num) throws IOException {
        File linkerO = new File(config.getTmpDir(), "linker" + num + ".o");
        linkerO.getParentFile().mkdirs();
        try (Context context = new Context();){
            String ir = mb.build().toString();
            if (config.isDumpIntermediates()) {
                File linkerLl = new File(config.getTmpDir(), "linker" + num + ".ll");
                FileUtils.writeStringToFile(linkerLl, ir, "utf-8");
            }
            try (Module module = Module.parseIR(context, ir, "linker" + num + ".ll");){
                try (PassManager passManager = new PassManager();){
                    passManager.addAlwaysInlinerPass();
                    passManager.addPromoteMemoryToRegisterPass();
                    passManager.run(module);
                }
                if (config.isDumpIntermediates()) {
                    File linkerBc = new File(config.getTmpDir(), "linker" + num + ".bc");
                    module.writeBitcode(linkerBc);
                }
                String triple = config.getTriple();
                Target target = Target.lookupTarget(triple);
                try (TargetMachine targetMachine = target.createTargetMachine(triple, null, null, null, RelocMode.RelocPIC, null);){
                    targetMachine.setAsmVerbosityDefault(true);
                    targetMachine.setFunctionSections(true);
                    targetMachine.setDataSections(true);
                    targetMachine.getOptions().setNoFramePointerElim(true);
                    targetMachine.getOptions().setPositionIndependentExecutable(true);
                    if (config.isDumpIntermediates()) {
                        File linkerS = new File(config.getTmpDir(), "linker" + num + ".s");
                        try (BufferedOutputStream outS = new BufferedOutputStream(new FileOutputStream(linkerS));){
                            targetMachine.emit(module, outS, CodeGenFileType.AssemblyFile);
                        }
                    }
                    try (BufferedOutputStream outO = new BufferedOutputStream(new FileOutputStream(linkerO));){
                        targetMachine.emit(module, outO, CodeGenFileType.ObjectFile);
                    }
                }
            }
        }
        return linkerO;
    }

    private TypeInfo buildTypeInfo(TypeInfo typeInfo, Map<ClazzInfo, TypeInfo> typeInfos) {
        if (typeInfo.error || typeInfo.classTypes != null) {
            return typeInfo;
        }
        ClazzInfo ci = typeInfo.clazz.getClazzInfo();
        ArrayList<TypeInfo> clTypeInfos = new ArrayList<TypeInfo>();
        TreeSet<TypeInfo> ifTypeInfos = new TreeSet<TypeInfo>();
        if (!ci.isInterface()) {
            if (ci.hasSuperclass()) {
                TypeInfo superTypeInfo = this.buildTypeInfo(typeInfos.get(ci.getSuperclass()), typeInfos);
                if (superTypeInfo.error) {
                    typeInfo.error = true;
                    return typeInfo;
                }
                clTypeInfos.addAll(Arrays.asList(superTypeInfo.classTypes));
                clTypeInfos.add(typeInfo);
                ifTypeInfos.addAll(Arrays.asList(superTypeInfo.interfaceTypes));
                superTypeInfo.children.add(typeInfo.clazz);
            } else {
                clTypeInfos.add(typeInfo);
            }
        }
        for (ClazzInfo ifCi : ci.getInterfaces()) {
            TypeInfo ifTypeInfo = this.buildTypeInfo(typeInfos.get(ifCi), typeInfos);
            if (ifTypeInfo.error) {
                typeInfo.error = true;
                return typeInfo;
            }
            ifTypeInfos.addAll(Arrays.asList(ifTypeInfo.interfaceTypes));
        }
        if (ci.isInterface()) {
            ifTypeInfos.add(typeInfo);
        }
        typeInfo.classTypes = EMPTY_TYPE_INFOS;
        typeInfo.interfaceTypes = EMPTY_TYPE_INFOS;
        if (!clTypeInfos.isEmpty()) {
            typeInfo.classTypes = clTypeInfos.toArray(new TypeInfo[clTypeInfos.size()]);
        }
        if (!ifTypeInfos.isEmpty()) {
            typeInfo.interfaceTypes = ifTypeInfos.toArray(new TypeInfo[ifTypeInfos.size()]);
        }
        return typeInfo;
    }

    private void buildTypeInfos(Map<ClazzInfo, TypeInfo> typeInfos) {
        for (TypeInfo typeInfo : typeInfos.values()) {
            this.buildTypeInfo(typeInfo, typeInfos);
        }
    }

    private StructureConstant createClassInfoErrorStruct(ModuleBuilder mb, ClazzInfo ci) {
        int errorType = 0;
        String errorMessage = null;
        if (!ci.isInterface() && ci.hasSuperclass()) {
            ClazzInfo superclazz = ci.getSuperclass();
            if (superclazz.isPhantom()) {
                errorType = 1;
                errorMessage = superclazz.getName();
            } else if (!Access.checkClassAccessible(superclazz, ci)) {
                errorType = 2;
                errorMessage = String.format("Attempt to access class %s from class %s", superclazz, ci);
            } else if (superclazz.isInterface()) {
                errorType = 3;
                errorMessage = String.format("class %s has interface %s as super class", ci, superclazz);
            }
        }
        if (errorType == 0) {
            for (ClazzInfo interfaze : ci.getInterfaces()) {
                if (interfaze.isPhantom()) {
                    errorType = 1;
                    errorMessage = interfaze.getName();
                    break;
                }
                if (!Access.checkClassAccessible(interfaze, ci)) {
                    errorType = 2;
                    errorMessage = String.format("Attempt to access class %s from class %s", interfaze, ci);
                    break;
                }
                if (interfaze.isInterface()) continue;
                errorType = 3;
                errorMessage = String.format("class %s tries to implement class %s as interface", ci, interfaze);
                break;
            }
        }
        if (errorType == 0) {
            for (ClazzInfo ex : ci.getCatches()) {
                if (ex == null || ex.isPhantom()) {
                    errorType = 1;
                    errorMessage = ex.getInternalName();
                    break;
                }
                if (Access.checkClassAccessible(ex, ci)) continue;
                errorType = 2;
                errorMessage = String.format("Attempt to access class %s from class %s", ex, ci);
                break;
            }
        }
        if (errorType == 0) {
            return null;
        }
        StructureConstantBuilder error = new StructureConstantBuilder();
        error.add(new NullConstant(Type.I8_PTR));
        error.add(new IntegerConstant(256));
        error.add(mb.getString(ci.getInternalName()));
        error.add(new IntegerConstant(errorType));
        error.add(mb.getString(errorMessage));
        return error.build();
    }

    private void createStrippedMethodStub(FunctionRef stubRef, ModuleBuilder mb, Clazz clazz, MethodInfo mi) {
        String symbol = Symbols.methodSymbol(clazz.getInternalName(), mi.getName(), mi.getDesc());
        Alias alias = new Alias(symbol, Linkage.external, stubRef);
        mb.addAlias(alias);
    }

    private Function createCheckcast(ModuleBuilder mb, Clazz clazz, TypeInfo typeInfo) {
        Function fn = FunctionBuilder.checkcast(clazz);
        Value info = this.getInfoStruct(mb, fn, clazz);
        if (typeInfo.error) {
            Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
            fn.add(new Ret(new NullConstant(Types.OBJECT_PTR)));
        } else if (!clazz.getClazzInfo().isInterface()) {
            Value result = Functions.call(fn, (Value)Functions.CHECKCAST_CLASS, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        } else {
            Value result = Functions.call(fn, (Value)Functions.CHECKCAST_INTERFACE, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        }
        return fn;
    }

    private Function createInstanceof(ModuleBuilder mb, Clazz clazz, TypeInfo typeInfo) {
        Function fn = FunctionBuilder.instanceOf(clazz);
        Value info = this.getInfoStruct(mb, fn, clazz);
        if (typeInfo.error) {
            Functions.call(fn, (Value)Functions.BC_LDC_CLASS, fn.getParameterRef(0), info);
            fn.add(new Ret(new IntegerConstant(0)));
        } else if (!clazz.getClazzInfo().isInterface()) {
            Value result = Functions.call(fn, (Value)Functions.INSTANCEOF_CLASS, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant((typeInfo.classTypes.length - 1) * 4 + 20), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        } else {
            Value result = Functions.call(fn, (Value)Functions.INSTANCEOF_INTERFACE, fn.getParameterRef(0), info, fn.getParameterRef(1), new IntegerConstant(typeInfo.id));
            fn.add(new Ret(result));
        }
        return fn;
    }

    private Function createLookup(ModuleBuilder mb, ClazzInfo ci, MethodInfo mi) {
        Function function = FunctionBuilder.lookup(ci, mi, false);
        String targetFnName = mi.isSynchronized() ? Symbols.synchronizedWrapperSymbol(ci.getInternalName(), mi.getName(), mi.getDesc()) : Symbols.methodSymbol(ci.getInternalName(), mi.getName(), mi.getDesc());
        FunctionRef fn = new FunctionRef(targetFnName, function.getType());
        if (!mb.hasSymbol(fn.getName())) {
            mb.addFunctionDeclaration(new FunctionDeclaration(fn));
        }
        Value result = Functions.tailcall(function, fn, function.getParameterRefs());
        function.add(new Ret(result));
        return function;
    }

    private Value getInfoStruct(ModuleBuilder mb, Function f, Clazz clazz) {
        String symbol = Symbols.infoStructSymbol(clazz.getInternalName());
        if (!mb.hasSymbol(symbol)) {
            Global info = new Global(symbol, Linkage.external, Type.I8_PTR, false);
            mb.addGlobal(info);
            return info.ref();
        }
        return new ConstantBitcast(mb.getGlobalRef(symbol), Type.I8_PTR_PTR);
    }

    private static class TypeInfo
    implements Comparable<TypeInfo> {
        boolean error;
        Clazz clazz;
        List<Clazz> children = new ArrayList<Clazz>();
        int id;
        TypeInfo[] classTypes;
        TypeInfo[] interfaceTypes;

        private TypeInfo() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeInfo other = (TypeInfo)obj;
            return this.id == other.id;
        }

        @Override
        public int compareTo(TypeInfo o) {
            return this.id < o.id ? -1 : (this.id == o.id ? 0 : 1);
        }
    }
}

