/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.Bro;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.trampoline.Invokestatic;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.VoidType;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.Tag;

public class MarshalerLookup {
    private final String BUILTIN_MARSHALERS = "org/robovm/rt/bro/BuiltinMarshalers";
    private final Config config;
    private final Map<String, List<Marshaler>> cache = new HashMap<String, List<Marshaler>>();
    private boolean searchBuiltins = true;

    public MarshalerLookup(Config config) {
        this.config = config;
    }

    public MarshalerLookup searchBuiltins(boolean b) {
        this.searchBuiltins = b;
        return this;
    }

    public Marshaler findMarshalers(MarshalSite marshalSite) {
        soot.Type type = marshalSite.getType();
        SootClass sc = null;
        if (type instanceof RefType) {
            sc = ((RefType)type).getSootClass();
        } else if (type instanceof ArrayType && ((ArrayType)type).baseType instanceof RefType) {
            sc = ((RefType)((ArrayType)type).baseType).getSootClass();
        }
        ArrayList<Marshaler> result = new ArrayList<Marshaler>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        if (sc != null) {
            this.findMarshalers(sc, result, visited, seen, false);
        }
        this.findMarshalers(marshalSite.method.getDeclaringClass(), result, visited, seen, this.searchBuiltins);
        for (Marshaler marshaler : result) {
            if (!marshaler.canMarshal(marshalSite)) continue;
            return marshaler;
        }
        return null;
    }

    public List<Marshaler> findMarshalers(SootClass sc) {
        ArrayList<Marshaler> result = new ArrayList<Marshaler>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        this.findMarshalers(sc, result, visited, seen, this.searchBuiltins);
        return result;
    }

    private void findMarshalers(SootClass sc, List<Marshaler> result, Set<String> visited, Set<String> seen, boolean searchBuiltins) {
        Clazz builtinMarshalersClazz;
        this.findMarshalersOnClasses(sc, result, visited, seen);
        this.findMarshalersOnInterfaces(sc, result, visited, seen);
        this.findMarshalersOnOuterClasses(sc, result, visited, seen);
        if (searchBuiltins && (builtinMarshalersClazz = this.config.getClazzes().load("org/robovm/rt/bro/BuiltinMarshalers")) != null) {
            this.findMarshalersOnClasses(builtinMarshalersClazz.getSootClass(), result, visited, seen);
        }
    }

    public MarshalerMethod findMarshalerMethod(MarshalSite marshalSite) {
        Marshaler marshaler;
        int pidx = marshalSite.paramIdx;
        if (pidx != -2) {
            AnnotationTag anno;
            AnnotationTag annotationTag = anno = pidx == -1 ? Annotations.getMarshalerAnnotation(marshalSite.method) : Annotations.getMarshalerAnnotation(marshalSite.method, pidx);
            if (anno != null) {
                Marshaler marshaler2;
                AnnotationClassElem elem = (AnnotationClassElem)Annotations.getElemByName(anno, "value");
                String name = Types.getInternalNameFromDescriptor(elem.getDesc());
                Clazz marshalerClazz = this.config.getClazzes().load(name);
                if (marshalerClazz != null && (marshaler2 = new Marshaler(marshalerClazz)).canMarshal(marshalSite)) {
                    return marshaler2.getMarshalerMethod(marshalSite);
                }
                throw new IllegalArgumentException(String.format("@Marshaler %s specified for %s of %s method %s can not be used to marshal %s", name.replace('/', '.'), pidx == -1 ? "return type" : "parameter " + (pidx + 1), marshalSite.callTypeName, marshalSite.method, marshalSite.type));
            }
        }
        if ((marshaler = this.findMarshalers(marshalSite)) != null) {
            return marshaler.getMarshalerMethod(marshalSite);
        }
        throw new IllegalArgumentException(String.format("No @Marshaler found for %s of %s method %s", pidx == -2 ? "receiver" : (pidx == -1 ? "return type" : "parameter " + (pidx + 1)), marshalSite.callTypeName, marshalSite.method));
    }

    private void findMarshalersOnClasses(SootClass sc, List<Marshaler> result, Set<String> visited, Set<String> seen) {
        SootResolver.v().bringToHierarchy(sc);
        result.addAll(this.findMarshalersOn(sc, visited, seen));
        if (sc.hasSuperclass()) {
            this.findMarshalersOnClasses(sc.getSuperclass(), result, visited, seen);
        }
    }

    private void findMarshalersOnInterfaces(SootClass sc, List<Marshaler> result, Set<String> visited, Set<String> seen) {
        SootResolver.v().bringToHierarchy(sc);
        for (SootClass ifs : sc.getInterfaces()) {
            result.addAll(this.findMarshalersOn(ifs, visited, seen));
        }
        for (SootClass ifs : sc.getInterfaces()) {
            this.findMarshalersOnInterfaces(ifs, result, visited, seen);
        }
        if (sc.hasSuperclass()) {
            this.findMarshalersOnInterfaces(sc.getSuperclass(), result, visited, seen);
        }
    }

    private void findMarshalersOnOuterClasses(SootClass sc, List<Marshaler> result, Set<String> visited, Set<String> seen) {
        SootClass outer = this.getOuterClass(sc);
        if (outer != null) {
            this.findMarshalersOnClasses(outer, result, visited, seen);
            this.findMarshalersOnInterfaces(outer, result, visited, seen);
            this.findMarshalersOnOuterClasses(outer, result, visited, seen);
        }
    }

    private List<Marshaler> findMarshalersOn(SootClass sc, Set<String> visited, Set<String> seen) {
        String name;
        String internalName = Types.getInternalName(sc);
        if (visited.contains(internalName)) {
            return Collections.emptyList();
        }
        visited.contains(internalName);
        List<Marshaler> all = this.cache.get(sc.getName());
        if (all == null) {
            all = new ArrayList<Marshaler>();
            for (AnnotationTag tag : Annotations.getMarshalerAnnotations(sc)) {
                AnnotationClassElem elem = (AnnotationClassElem)Annotations.getElemByName(tag, "value");
                name = Types.getInternalNameFromDescriptor(elem.getDesc());
                Clazz marshalerClazz = this.config.getClazzes().load(name);
                if (marshalerClazz == null) continue;
                all.add(new Marshaler(marshalerClazz));
            }
            this.cache.put(sc.getName(), all);
        }
        ArrayList<Marshaler> result = new ArrayList<Marshaler>();
        for (Marshaler m : all) {
            name = m.clazz.getInternalName();
            if (seen.contains(name)) continue;
            seen.add(name);
            result.add(m);
        }
        return result;
    }

    private SootClass getOuterClass(SootClass clazz) {
        String name = Types.getInternalName(clazz);
        for (Tag tag : clazz.getTags()) {
            if (!(tag instanceof InnerClassTag)) continue;
            InnerClassTag innerClassTag = (InnerClassTag)tag;
            String inner = innerClassTag.getInnerClass();
            String outer = innerClassTag.getOuterClass();
            if (inner == null || outer == null || !inner.equals(name)) continue;
            return this.config.getClazzes().load(outer).getSootClass();
        }
        return null;
    }

    private Set<Long> getSupportedCallTypes(AnnotationTag anno) {
        AnnotationArrayElem el = (AnnotationArrayElem)Annotations.getElemByName(anno, "supportedCallTypes");
        if (el == null) {
            return new HashSet<Long>(Arrays.asList(0L, 1L, 2L, 3L, 4L));
        }
        ArrayList<AnnotationElem> values = el.getValues();
        HashSet<Long> callTypes = new HashSet<Long>();
        for (AnnotationElem value : values) {
            callTypes.add(((AnnotationLongElem)value).getValue());
        }
        return callTypes;
    }

    private soot.Type getBaseType(SootMethod m, AnnotationTag anno) {
        AnnotationClassElem el = (AnnotationClassElem)Annotations.getElemByName(anno, "baseType");
        if (el != null) {
            switch (el.getDesc().charAt(0)) {
                case 'Z': {
                    return BooleanType.v();
                }
                case 'B': {
                    return ByteType.v();
                }
                case 'S': {
                    return ShortType.v();
                }
                case 'C': {
                    return CharType.v();
                }
                case 'I': {
                    return IntType.v();
                }
                case 'J': {
                    return LongType.v();
                }
                case 'F': {
                    return FloatType.v();
                }
                case 'D': {
                    return DoubleType.v();
                }
            }
            return null;
        }
        soot.Type t = m.getReturnType();
        if (t == VoidType.v()) {
            t = m.getParameterType(0);
        }
        if (t instanceof RefType) {
            SootClass c = ((RefType)t).getSootClass();
            if (Types.isInstanceOfClass(c, "java.nio.ByteBuffer")) {
                return ByteType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.ShortBuffer")) {
                return ShortType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.CharBuffer")) {
                return CharType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.IntBuffer")) {
                return IntType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.LongBuffer")) {
                return LongType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.FloatBuffer")) {
                return FloatType.v();
            }
            if (Types.isInstanceOfClass(c, "java.nio.DoubleBuffer")) {
                return DoubleType.v();
            }
            if (Types.isInstanceOfClass(c, "org.robovm.rt.bro.Struct")) {
                return this.config.getClazzes().load("org/robovm/rt/bro/Struct").getSootClass().getType();
            }
        } else if (t instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)t;
            if (arrayType.baseType instanceof PrimType || Types.isInstanceOfClass(arrayType.baseType, "org.robovm.rt.bro.Struct")) {
                return arrayType.baseType;
            }
        }
        return null;
    }

    public class Marshaler {
        private final Clazz clazz;
        private Map<String, MarshalerMethod> toObjectMethods = null;
        private Map<String, MarshalerMethod> toNativeMethods = null;
        private Map<Integer, Map<String, ArrayMarshalerMethod>> toArrayObjectMethods = null;
        private Map<Integer, Map<String, ArrayMarshalerMethod>> toNativeArrayMethods = null;

        private Marshaler(Clazz clazz) {
            this.clazz = clazz;
        }

        private boolean isToObject(SootMethod m, AnnotationTag pointerAnno, AnnotationTag valueAnno, AnnotationTag arrayAnno) {
            if (pointerAnno == null && valueAnno == null && arrayAnno == null) {
                return false;
            }
            if (pointerAnno != null && (valueAnno != null || arrayAnno != null) || valueAnno != null && arrayAnno != null) {
                return false;
            }
            List paramTypes = m.getParameterTypes();
            if (paramTypes.size() < 3) {
                return false;
            }
            if (!(paramTypes.get(0) instanceof RefType)) {
                return false;
            }
            SootClass sc = ((RefType)paramTypes.get(0)).getSootClass();
            if (!sc.getName().equals("java.lang.Class")) {
                return false;
            }
            soot.Type returnType = m.getReturnType();
            if (pointerAnno != null) {
                if (!(returnType instanceof RefLikeType)) {
                    return false;
                }
                if (paramTypes.size() == 3 && paramTypes.get(1) == LongType.v() && paramTypes.get(2) == LongType.v()) {
                    return true;
                }
            } else if (valueAnno != null) {
                if (!(returnType instanceof RefLikeType)) {
                    return false;
                }
                if (paramTypes.size() == 3 && paramTypes.get(1) instanceof PrimType && paramTypes.get(2) == LongType.v()) {
                    if (Annotations.hasPointerAnnotation(m, 1)) {
                        return ((soot.Type)paramTypes.get(1)).equals(LongType.v());
                    }
                    if (Annotations.hasMachineSizedFloatAnnotation(m, 1)) {
                        return ((soot.Type)paramTypes.get(1)).equals(FloatType.v()) || ((soot.Type)paramTypes.get(1)).equals(DoubleType.v());
                    }
                    if (Annotations.hasMachineSizedSIntAnnotation(m, 1)) {
                        return ((soot.Type)paramTypes.get(1)).equals(LongType.v());
                    }
                    if (Annotations.hasMachineSizedUIntAnnotation(m, 1)) {
                        return ((soot.Type)paramTypes.get(1)).equals(LongType.v());
                    }
                    return true;
                }
            } else if (arrayAnno != null) {
                if (!(returnType instanceof RefLikeType)) {
                    return false;
                }
                if (MarshalerLookup.this.getBaseType(m, arrayAnno) == null) {
                    return false;
                }
                if (paramTypes.size() > 3 && paramTypes.get(1) == LongType.v() && paramTypes.get(2) == LongType.v()) {
                    for (int i = 3; i < paramTypes.size(); ++i) {
                        if (paramTypes.get(i) == IntType.v()) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean isToNative(SootMethod m, AnnotationTag pointerAnno, AnnotationTag valueAnno, AnnotationTag arrayAnno) {
            if (pointerAnno == null && valueAnno == null && arrayAnno == null) {
                return false;
            }
            if (pointerAnno != null && (valueAnno != null || arrayAnno != null) || valueAnno != null && arrayAnno != null) {
                return false;
            }
            List paramTypes = m.getParameterTypes();
            if (paramTypes.size() < 2) {
                return false;
            }
            if (!(paramTypes.get(0) instanceof RefLikeType)) {
                return false;
            }
            soot.Type returnType = m.getReturnType();
            if (pointerAnno != null) {
                if (returnType != LongType.v()) {
                    return false;
                }
                if (paramTypes.size() == 2 && paramTypes.get(1) == LongType.v()) {
                    return true;
                }
            } else if (valueAnno != null) {
                if (!(returnType instanceof PrimType)) {
                    return false;
                }
                if (paramTypes.size() == 2 && paramTypes.get(1) == LongType.v()) {
                    if (Annotations.hasPointerAnnotation(m)) {
                        return returnType.equals(LongType.v());
                    }
                    if (Annotations.hasMachineSizedFloatAnnotation(m)) {
                        return returnType.equals(FloatType.v()) || returnType.equals(DoubleType.v());
                    }
                    if (Annotations.hasMachineSizedSIntAnnotation(m)) {
                        return returnType.equals(LongType.v());
                    }
                    if (Annotations.hasMachineSizedUIntAnnotation(m)) {
                        return returnType.equals(LongType.v());
                    }
                    return true;
                }
            } else if (arrayAnno != null) {
                if (returnType != VoidType.v()) {
                    return false;
                }
                if (MarshalerLookup.this.getBaseType(m, arrayAnno) == null) {
                    return false;
                }
                if (paramTypes.size() > 3 && paramTypes.get(1) == LongType.v() && paramTypes.get(2) == LongType.v()) {
                    for (int i = 3; i < paramTypes.size(); ++i) {
                        if (paramTypes.get(i) == IntType.v()) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        private void buildMaps() {
            if (this.toObjectMethods == null && this.toNativeMethods == null && this.toArrayObjectMethods == null && this.toNativeArrayMethods == null) {
                this.toObjectMethods = new HashMap<String, MarshalerMethod>();
                this.toNativeMethods = new HashMap<String, MarshalerMethod>();
                this.toArrayObjectMethods = new HashMap<Integer, Map<String, ArrayMarshalerMethod>>();
                this.toNativeArrayMethods = new HashMap<Integer, Map<String, ArrayMarshalerMethod>>();
                for (SootMethod m : this.clazz.getSootClass().getMethods()) {
                    Map<String, ArrayMarshalerMethod> map;
                    int dimCount;
                    Set supportedCallTypes;
                    AnnotationTag anno;
                    AnnotationTag arrayAnno;
                    AnnotationTag valueAnno;
                    if (!m.isStatic() || !m.isPublic()) continue;
                    AnnotationTag pointerAnno = Annotations.getMarshalsPointerAnnotation(m);
                    if (this.isToObject(m, pointerAnno, valueAnno = Annotations.getMarshalsValueAnnotation(m), arrayAnno = Annotations.getMarshalsArrayAnnotation(m))) {
                        anno = pointerAnno != null ? pointerAnno : (valueAnno != null ? valueAnno : arrayAnno);
                        supportedCallTypes = MarshalerLookup.this.getSupportedCallTypes(anno);
                        if (pointerAnno != null) {
                            this.toObjectMethods.put(Types.getDescriptor(m.getReturnType()), new PointerMarshalerMethod(m, supportedCallTypes));
                            continue;
                        }
                        if (valueAnno != null) {
                            this.toObjectMethods.put(Types.getDescriptor(m.getReturnType()), new ValueMarshalerMethod(m, supportedCallTypes));
                            continue;
                        }
                        dimCount = m.getParameterCount() - 3;
                        map = this.toArrayObjectMethods.get(dimCount);
                        if (map == null) {
                            map = new HashMap<String, ArrayMarshalerMethod>();
                            this.toArrayObjectMethods.put(dimCount, map);
                        }
                        map.put(Types.getDescriptor(m.getReturnType()), new ArrayMarshalerMethod(m, supportedCallTypes, MarshalerLookup.this.getBaseType(m, arrayAnno)));
                        continue;
                    }
                    if (this.isToNative(m, pointerAnno, valueAnno, arrayAnno)) {
                        anno = pointerAnno != null ? pointerAnno : (valueAnno != null ? valueAnno : arrayAnno);
                        supportedCallTypes = MarshalerLookup.this.getSupportedCallTypes(anno);
                        if (pointerAnno != null) {
                            this.toNativeMethods.put(Types.getDescriptor(m.getParameterType(0)), new PointerMarshalerMethod(m, supportedCallTypes));
                            continue;
                        }
                        if (valueAnno != null) {
                            this.toNativeMethods.put(Types.getDescriptor(m.getParameterType(0)), new ValueMarshalerMethod(m, supportedCallTypes));
                            continue;
                        }
                        dimCount = m.getParameterCount() - 3;
                        map = this.toNativeArrayMethods.get(dimCount);
                        if (map == null) {
                            map = new HashMap<String, ArrayMarshalerMethod>();
                            this.toNativeArrayMethods.put(dimCount, map);
                        }
                        map.put(Types.getDescriptor(m.getParameterType(0)), new ArrayMarshalerMethod(m, supportedCallTypes, MarshalerLookup.this.getBaseType(m, arrayAnno)));
                        continue;
                    }
                    if (pointerAnno == null && valueAnno == null && arrayAnno == null) continue;
                    MarshalerLookup.this.config.getLogger().warn("Ignoring invalid marshaler method %s", m);
                }
            }
        }

        private soot.Type makeArrayType(soot.Type baseType, int numDimensions) {
            soot.Type newType = baseType;
            for (int i = 0; i < numDimensions; ++i) {
                newType = newType.makeArrayType();
            }
            return newType;
        }

        private MarshalerMethod findMarshalerMethod(soot.Type type, Map<String, ? extends MarshalerMethod> map) {
            block7: {
                MarshalerMethod m;
                block6: {
                    m = map.get(Types.getDescriptor(type));
                    if (m != null) {
                        return m;
                    }
                    if (!(type instanceof RefType)) break block6;
                    SootClass sc = ((RefType)type).getSootClass();
                    if (sc.hasSuperclass() && (m = this.findMarshalerMethod(sc.getSuperclass().getType(), map)) != null) {
                        return m;
                    }
                    for (SootClass ifs : sc.getInterfaces()) {
                        m = this.findMarshalerMethod(ifs.getType(), map);
                        if (m == null) continue;
                        return m;
                    }
                    break block7;
                }
                if (!(type instanceof ArrayType)) break block7;
                ArrayType arrayType = (ArrayType)type;
                if (arrayType.baseType instanceof RefType) {
                    SootClass sc = ((RefType)arrayType.baseType).getSootClass();
                    if (sc.hasSuperclass() && (m = this.findMarshalerMethod(this.makeArrayType(sc.getSuperclass().getType(), arrayType.numDimensions), map)) != null) {
                        return m;
                    }
                    for (SootClass ifs : sc.getInterfaces()) {
                        m = this.findMarshalerMethod(this.makeArrayType(ifs.getType(), arrayType.numDimensions), map);
                        if (m == null) continue;
                        return m;
                    }
                }
            }
            return null;
        }

        public Clazz getClazz() {
            return this.clazz;
        }

        public boolean canMarshal(MarshalSite marshalSite) {
            return this.getMarshalerMethod(marshalSite) != null;
        }

        public MarshalerMethod getMarshalerMethod(MarshalSite marshalSite) {
            MarshalerMethod m;
            this.buildMaps();
            Map<String, MarshalerMethod> map = null;
            if (marshalSite.isArray()) {
                int dimCount = Bro.getArrayDimensions(marshalSite.method, marshalSite.paramIdx).length;
                Map<String, MarshalerMethod> map2 = map = marshalSite.isToNative() ? this.toNativeArrayMethods.get(dimCount) : this.toArrayObjectMethods.get(dimCount);
                if (map == null) {
                    return null;
                }
            } else {
                map = marshalSite.isToNative() ? this.toNativeMethods : this.toObjectMethods;
            }
            if ((m = this.findMarshalerMethod(marshalSite.getType(), map)) != null && m.supportsCallType(marshalSite.getCallType())) {
                return m;
            }
            return null;
        }
    }

    public class ArrayMarshalerMethod
    extends MarshalerMethod {
        private final soot.Type baseType;

        ArrayMarshalerMethod(SootMethod method, Set<Long> supportedCallTypes, soot.Type baseType) {
            super(method, supportedCallTypes);
            this.baseType = baseType;
        }

        public soot.Type getBaseType() {
            return this.baseType;
        }
    }

    public class ValueMarshalerMethod
    extends MarshalerMethod {
        ValueMarshalerMethod(SootMethod method, Set<Long> supportedCallTypes) {
            super(method, supportedCallTypes);
        }

        public Type getNativeType(Arch arch) {
            if (this.method.getReturnType() instanceof PrimType) {
                if (Annotations.hasPointerAnnotation(this.method)) {
                    return Type.I8_PTR;
                }
                if (arch.is32Bit() && (Annotations.hasMachineSizedSIntAnnotation(this.method) || Annotations.hasMachineSizedUIntAnnotation(this.method))) {
                    return Type.I32;
                }
                if (arch.is32Bit() && Annotations.hasMachineSizedFloatAnnotation(this.method)) {
                    return Type.FLOAT;
                }
                if (!arch.is32Bit() && Annotations.hasMachineSizedFloatAnnotation(this.method)) {
                    return Type.DOUBLE;
                }
                return Types.getType(this.method.getReturnType());
            }
            if (Annotations.hasPointerAnnotation(this.method, 1)) {
                return Type.I8_PTR;
            }
            if (arch.is32Bit() && (Annotations.hasMachineSizedSIntAnnotation(this.method, 1) || Annotations.hasMachineSizedUIntAnnotation(this.method, 1))) {
                return Type.I32;
            }
            if (arch.is32Bit() && Annotations.hasMachineSizedFloatAnnotation(this.method, 1)) {
                return Type.FLOAT;
            }
            if (!arch.is32Bit() && Annotations.hasMachineSizedFloatAnnotation(this.method, 1)) {
                return Type.DOUBLE;
            }
            return Types.getType(this.method.getParameterType(1));
        }
    }

    public class PointerMarshalerMethod
    extends MarshalerMethod {
        private boolean hasSearchedForAfterBridgeCallMethod;
        private SootMethod afterBridgeCallMethod;
        private boolean hasSearchedForAfterCallbackCallMethod;
        private SootMethod afterCallbackCallMethod;

        PointerMarshalerMethod(SootMethod method, Set<Long> supportedCallTypes) {
            super(method, supportedCallTypes);
            this.hasSearchedForAfterBridgeCallMethod = false;
            this.afterBridgeCallMethod = null;
            this.hasSearchedForAfterCallbackCallMethod = false;
            this.afterCallbackCallMethod = null;
        }

        public SootMethod getAfterBridgeCallMethod() {
            if (this.hasSearchedForAfterBridgeCallMethod) {
                return this.afterBridgeCallMethod;
            }
            this.hasSearchedForAfterBridgeCallMethod = true;
            List<soot.Type> paramTypes = Arrays.asList(this.method.getParameterType(0), LongType.v(), LongType.v());
            for (SootMethod m : this.method.getDeclaringClass().getMethods()) {
                if (!Annotations.hasAfterBridgeCallAnnotation(m) || m.getReturnType() != VoidType.v() || !m.getParameterTypes().equals(paramTypes)) continue;
                this.afterBridgeCallMethod = m;
                break;
            }
            return this.afterBridgeCallMethod;
        }

        public SootMethod getAfterCallbackCallMethod() {
            if (this.hasSearchedForAfterCallbackCallMethod) {
                return this.afterCallbackCallMethod;
            }
            this.hasSearchedForAfterCallbackCallMethod = true;
            List<soot.Type> paramTypes = Arrays.asList(LongType.v(), this.method.getReturnType(), LongType.v());
            for (SootMethod m : this.method.getDeclaringClass().getMethods()) {
                if (!Annotations.hasAfterCallbackCallAnnotation(m) || m.getReturnType() != VoidType.v() || !m.getParameterTypes().equals(paramTypes)) continue;
                this.afterCallbackCallMethod = m;
                break;
            }
            return this.afterCallbackCallMethod;
        }
    }

    public abstract class MarshalerMethod {
        protected final SootMethod method;
        protected final Set<Long> supportedCallTypes;

        MarshalerMethod(SootMethod method, Set<Long> supportedCallTypes) {
            this.method = method;
            this.supportedCallTypes = supportedCallTypes;
        }

        public SootMethod getMethod() {
            return this.method;
        }

        public boolean supportsCallType(long callType) {
            return this.supportedCallTypes.contains(callType);
        }

        public Invokestatic getInvokeStatic(SootClass caller) {
            return new Invokestatic(Types.getInternalName(caller), Types.getInternalName(this.method.getDeclaringClass()), this.method.getName(), Types.getDescriptor(this.method));
        }
    }

    public static class MarshalSite {
        public static final int RETURN_TYPE = -1;
        public static final int RECEIVER = -2;
        private final SootMethod method;
        private final int paramIdx;
        private final long callType;
        private final String callTypeName;
        private final soot.Type type;
        private final boolean array;

        public MarshalSite(SootMethod method) {
            this(method, -1);
        }

        public MarshalSite(SootMethod method, int paramIdx) {
            this.method = method;
            this.paramIdx = paramIdx;
            soot.Type type = paramIdx == -1 ? method.getReturnType() : (this.type = paramIdx == -2 ? method.getDeclaringClass().getType() : method.getParameterType(paramIdx));
            if (Annotations.hasBridgeAnnotation(method)) {
                this.callType = 0L;
                this.callTypeName = "@Bridge";
                this.array = false;
            } else if (Annotations.hasCallbackAnnotation(method)) {
                this.callType = 1L;
                this.callTypeName = "@Callback";
                this.array = false;
            } else if (Annotations.hasStructMemberAnnotation(method)) {
                this.callType = 2L;
                this.callTypeName = "@StructMember";
                this.array = paramIdx == -1 ? Annotations.hasArrayAnnotation(method) : Annotations.hasArrayAnnotation(method, paramIdx);
            } else if (Annotations.hasGlobalValueAnnotation(method)) {
                this.callType = 3L;
                this.callTypeName = "@GlobalValue";
                this.array = paramIdx == -1 ? Annotations.hasArrayAnnotation(method) : Annotations.hasArrayAnnotation(method, paramIdx);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public SootMethod getMethod() {
            return this.method;
        }

        public long getCallType() {
            return this.callType;
        }

        public soot.Type getType() {
            return this.type;
        }

        public boolean isToNative() {
            if (this.callType == 1L) {
                return this.paramIdx == -1;
            }
            return this.paramIdx != -1;
        }

        public boolean isArray() {
            return this.array;
        }
    }
}

