/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Bitcast;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.ConstantGetelementptr;
import org.robovm.compiler.llvm.ConstantPtrtoint;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Getelementptr;
import org.robovm.compiler.llvm.IntegerType;
import org.robovm.compiler.llvm.NullConstant;
import org.robovm.compiler.llvm.OpaqueType;
import org.robovm.compiler.llvm.PackedStructureType;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.VoidType;
import soot.jimple.toolkits.typing.fast.BottomType;

public class Types {
    public static final StructureType GATEWAY_FRAME = new StructureType("GatewayFrame", Type.I8_PTR, Type.I8_PTR, Type.I8_PTR);
    public static final Type GATEWAY_FRAME_PTR = new PointerType(GATEWAY_FRAME);
    public static final StructureType TRYCATCH_CONTEXT = new StructureType("TrycatchContext", Type.I8_PTR);
    public static final Type TRYCATCH_CONTEXT_PTR = new PointerType(TRYCATCH_CONTEXT);
    public static final StructureType BC_TRYCATCH_CONTEXT = new StructureType("BcTrycatchContext", TRYCATCH_CONTEXT, Type.I8_PTR);
    public static final Type BC_TRYCATCH_CONTEXT_PTR = new PointerType(BC_TRYCATCH_CONTEXT);
    public static final Type ENV_PTR = new PointerType(new StructureType("Env", Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I8_PTR, Type.I32));
    public static final StructureType CLASS = new StructureType("Class", Type.I8_PTR);
    public static final Type CLASS_PTR = new PointerType(CLASS);
    public static final StructureType OBJECT = new StructureType("Object", CLASS_PTR);
    public static final StructureType DATA_OBJECT = new StructureType("DataObject", OBJECT);
    public static final StructureType VITABLE = new StructureType("VITable", Type.I8_PTR);
    public static final Type VITABLE_PTR = new PointerType(VITABLE);
    public static final Type OBJECT_PTR = new PointerType(OBJECT);
    public static final Type METHOD_PTR = new PointerType(new OpaqueType("Method"));
    public static final Type FIELD_PTR = new PointerType(new OpaqueType("Field"));

    public static Type getType(String desc) {
        switch (desc.charAt(0)) {
            case 'Z': {
                return Type.I8;
            }
            case 'B': {
                return Type.I8;
            }
            case 'S': {
                return Type.I16;
            }
            case 'C': {
                return Type.I16;
            }
            case 'I': {
                return Type.I32;
            }
            case 'J': {
                return Type.I64;
            }
            case 'F': {
                return Type.FLOAT;
            }
            case 'D': {
                return Type.DOUBLE;
            }
            case 'V': {
                return Type.VOID;
            }
            case 'L': {
                return OBJECT_PTR;
            }
            case '[': {
                return OBJECT_PTR;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Type getType(CharBuffer desc) {
        switch (desc.get()) {
            case 'Z': {
                return Type.I8;
            }
            case 'B': {
                return Type.I8;
            }
            case 'S': {
                return Type.I16;
            }
            case 'C': {
                return Type.I16;
            }
            case 'I': {
                return Type.I32;
            }
            case 'J': {
                return Type.I64;
            }
            case 'F': {
                return Type.FLOAT;
            }
            case 'D': {
                return Type.DOUBLE;
            }
            case 'V': {
                return Type.VOID;
            }
            case 'L': {
                while (desc.get() != ';') {
                }
                return OBJECT_PTR;
            }
            case '[': {
                Types.getType(desc);
                return OBJECT_PTR;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Type getLocalType(soot.Type sootType) {
        Type t = Types.getType(sootType);
        if (t instanceof IntegerType && ((IntegerType)t).getBits() < 32) {
            return Type.I32;
        }
        return t;
    }

    public static Type getType(soot.Type sootType) {
        if (sootType.equals(BooleanType.v())) {
            return Type.I8;
        }
        if (sootType.equals(ByteType.v())) {
            return Type.I8;
        }
        if (sootType.equals(ShortType.v())) {
            return Type.I16;
        }
        if (sootType.equals(CharType.v())) {
            return Type.I16;
        }
        if (sootType.equals(IntType.v())) {
            return Type.I32;
        }
        if (sootType.equals(LongType.v())) {
            return Type.I64;
        }
        if (sootType.equals(FloatType.v())) {
            return Type.FLOAT;
        }
        if (sootType.equals(DoubleType.v())) {
            return Type.DOUBLE;
        }
        if (sootType.equals(VoidType.v())) {
            return Type.VOID;
        }
        if (sootType instanceof RefLikeType || sootType.equals(BottomType.v())) {
            return OBJECT_PTR;
        }
        throw new IllegalArgumentException("Unknown Type: " + sootType);
    }

    public static boolean isUnsigned(soot.Type type) {
        return type.equals(CharType.v());
    }

    public static String getInternalName(soot.Type t) {
        if (t instanceof ArrayType) {
            return Types.getDescriptor(t);
        }
        if (t instanceof RefType) {
            RefType rt = (RefType)t;
            return rt.getClassName().replace('.', '/');
        }
        throw new IllegalArgumentException();
    }

    public static String getInternalName(SootClass sc) {
        return sc.getName().replace('.', '/');
    }

    public static String getInternalNameFromDescriptor(String desc) {
        if (!desc.startsWith("L")) {
            throw new IllegalArgumentException(desc + " is not a class descriptor");
        }
        return desc.substring(1, desc.length() - 1);
    }

    public static String getDescriptor(Type t) {
        if (t instanceof PointerType) {
            return "J";
        }
        if (t == Type.I8) {
            return "B";
        }
        if (t == Type.I16) {
            return "S";
        }
        if (t == Type.I32) {
            return "I";
        }
        if (t == Type.I64) {
            return "J";
        }
        if (t == Type.FLOAT) {
            return "F";
        }
        if (t == Type.DOUBLE) {
            return "D";
        }
        throw new IllegalArgumentException(t.toString());
    }

    public static String getDescriptor(soot.Type t) {
        if (t instanceof PrimType) {
            if (t.equals(BooleanType.v())) {
                return "Z";
            }
            if (t.equals(ByteType.v())) {
                return "B";
            }
            if (t.equals(ShortType.v())) {
                return "S";
            }
            if (t.equals(CharType.v())) {
                return "C";
            }
            if (t.equals(IntType.v())) {
                return "I";
            }
            if (t.equals(LongType.v())) {
                return "J";
            }
            if (t.equals(FloatType.v())) {
                return "F";
            }
            return "D";
        }
        if (t.equals(VoidType.v())) {
            return "V";
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return "[" + Types.getDescriptor(at.getElementType());
        }
        RefType rt = (RefType)t;
        return "L" + rt.getClassName().replace('.', '/') + ";";
    }

    public static String getDescriptor(SootField field) {
        return Types.getDescriptor(field.getType());
    }

    public static String getDescriptor(SootMethod method) {
        return Types.getDescriptor(method.makeRef());
    }

    public static String getDescriptor(SootMethodRef methodRef) {
        return Types.getDescriptor(methodRef.parameterTypes(), methodRef.returnType());
    }

    public static String getDescriptor(List<soot.Type> paramTypes, soot.Type returnType) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (soot.Type t : paramTypes) {
            sb.append(Types.getDescriptor(t));
        }
        sb.append(')');
        sb.append(Types.getDescriptor(returnType));
        return sb.toString();
    }

    private static void nextDescriptor(CharBuffer cb, StringBuilder sb) {
        char c = cb.get();
        sb.append(c);
        if (c == 'L') {
            do {
                c = cb.get();
                sb.append(c);
            } while (c != ';');
        } else if (c == '[') {
            Types.nextDescriptor(cb, sb);
        }
    }

    public static String getReturnTypeDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
    }

    public static List<String> getParameterDescriptors(String methodDescriptor) {
        return Types.getParameterDescriptors(CharBuffer.wrap(methodDescriptor));
    }

    private static List<String> getParameterDescriptors(CharBuffer cb) {
        ArrayList<String> result = new ArrayList<String>();
        cb.get();
        while (cb.hasRemaining() && cb.get(cb.position()) != ')') {
            StringBuilder sb = new StringBuilder();
            Types.nextDescriptor(cb, sb);
            result.add(sb.toString());
        }
        return result;
    }

    public static boolean isEnum(soot.Type t) {
        if (t instanceof RefType) {
            return Types.isEnum(((RefType)t).getSootClass());
        }
        return false;
    }

    public static boolean isEnum(SootClass sc) {
        return sc.hasSuperclass() && sc.getSuperclass().getName().equals("java.lang.Enum");
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor.length() == 1;
    }

    public static boolean isArray(String descriptor) {
        return descriptor.charAt(0) == '[';
    }

    public static boolean isNativeObject(soot.Type t) {
        if (t instanceof RefType) {
            return Types.isNativeObject(((RefType)t).getSootClass());
        }
        return false;
    }

    public static boolean isNativeObject(SootClass sc) {
        return Types.isSubclass(sc, "org.robovm.rt.bro.NativeObject");
    }

    public static boolean isStruct(soot.Type t) {
        if (t instanceof RefType) {
            return Types.isStruct(((RefType)t).getSootClass());
        }
        return false;
    }

    public static boolean isStruct(SootClass sc) {
        return Types.isSubclass(sc, "org.robovm.rt.bro.Struct");
    }

    public static boolean isPrimitiveComponentType(String descriptor) {
        if (!Types.isArray(descriptor)) {
            throw new IllegalArgumentException("Not an array");
        }
        return descriptor.length() == 2;
    }

    public static boolean isPrimitiveBaseType(String descriptor) {
        if (!Types.isArray(descriptor)) {
            throw new IllegalArgumentException("Not an array");
        }
        return descriptor.charAt(descriptor.length() - 1) != ';';
    }

    public static String getBaseType(String descriptor) {
        if (!Types.isArray(descriptor) || descriptor.charAt(descriptor.length() - 1) != ';') {
            throw new IllegalArgumentException("Not an array or base type is primitive");
        }
        int start = descriptor.lastIndexOf(91) + 1;
        if (descriptor.charAt(start) != 'L') {
            throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
        }
        return descriptor.substring(start + 1, descriptor.length() - 1);
    }

    public static FunctionType getFunctionType(SootMethod method) {
        return Types.getFunctionType(method.makeRef());
    }

    public static FunctionType getFunctionType(SootMethodRef methodRef) {
        Type returnType = Types.getType(methodRef.returnType());
        Type[] paramTypes = new Type[(methodRef.isStatic() ? 1 : 2) + methodRef.parameterTypes().size()];
        int i = 0;
        paramTypes[i++] = ENV_PTR;
        if (!methodRef.isStatic()) {
            paramTypes[i++] = OBJECT_PTR;
        }
        for (soot.Type t : methodRef.parameterTypes()) {
            paramTypes[i++] = Types.getType(t);
        }
        return new FunctionType(returnType, paramTypes);
    }

    public static FunctionType getFunctionType(String methodDesc, boolean ztatic) {
        return Types.getFunctionType(methodDesc, ztatic, false);
    }

    public static FunctionType getNativeFunctionType(String methodDesc, boolean ztatic) {
        return Types.getFunctionType(methodDesc, ztatic, true);
    }

    private static FunctionType getFunctionType(String methodDesc, boolean ztatic, boolean nativ) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        paramTypes.add(ENV_PTR);
        if (!ztatic) {
            paramTypes.add(OBJECT_PTR);
        } else if (nativ) {
            paramTypes.add(OBJECT_PTR);
        }
        CharBuffer buffer = CharBuffer.wrap(methodDesc);
        buffer.get();
        while (buffer.get(buffer.position()) != ')') {
            paramTypes.add(Types.getType(buffer));
        }
        buffer.get();
        Type returnType = Types.getType(buffer);
        return new FunctionType(returnType, paramTypes.toArray(new Type[paramTypes.size()]));
    }

    public static boolean isSubclass(SootClass sc, String className) {
        SootClass clazz = sc;
        while (clazz.hasSuperclass()) {
            if (!className.equals((clazz = clazz.getSuperclass()).getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfClass(soot.Type t, String className) {
        if (t instanceof RefType) {
            return Types.isInstanceOfClass(((RefType)t).getSootClass(), className);
        }
        return false;
    }

    public static boolean isInstanceOfClass(SootClass sc, String className) {
        SootClass clazz = sc;
        if (className.equals(clazz.getName())) {
            return true;
        }
        return Types.isSubclass(sc, className);
    }

    public static Constant sizeof(AggregateType type) {
        return new ConstantPtrtoint(new ConstantGetelementptr(new NullConstant(new PointerType(type)), 1), Type.I32);
    }

    public static Constant offsetof(AggregateType type, int ... idx) {
        int[] i = new int[idx.length + 1];
        i[0] = 0;
        System.arraycopy(idx, 0, i, 1, idx.length);
        return new ConstantPtrtoint(new ConstantGetelementptr(new NullConstant(new PointerType(type)), i), Type.I32);
    }

    private static PackedStructureType padType(Type t, int padding) {
        ArrayList<IntegerType> paddingType = new ArrayList<IntegerType>();
        for (int i = 0; i < padding; ++i) {
            paddingType.add(Type.I8);
        }
        return new PackedStructureType(new PackedStructureType(paddingType.toArray(new Type[paddingType.size()])), t);
    }

    private static PackedStructureType getInstanceType0(OS os, Arch arch, SootClass clazz, int subClassAlignment, int[] superSize) {
        ArrayList<Type> types = new ArrayList<Type>();
        List<SootField> fields = Types.getInstanceFields(os, arch, clazz);
        int superAlignment = 1;
        if (!fields.isEmpty()) {
            SootField field = fields.get(0);
            superAlignment = Types.getFieldAlignment(os, arch, field);
        }
        if (clazz.hasSuperclass()) {
            types.add(Types.getInstanceType0(os, arch, clazz.getSuperclass(), superAlignment, superSize));
        }
        int offset = superSize[0];
        for (SootField field : fields) {
            int falign = Types.getFieldAlignment(os, arch, field);
            int padding = (offset & falign - 1) != 0 ? falign - (offset & falign - 1) : 0;
            types.add(Types.padType(Types.getType(field.getType()), padding));
            offset += padding + Types.getFieldSize(arch, field);
        }
        int padding = (offset & subClassAlignment - 1) != 0 ? subClassAlignment - (offset & subClassAlignment - 1) : 0;
        for (int i = 0; i < padding; ++i) {
            types.add(Type.I8);
            ++offset;
        }
        superSize[0] = offset;
        return new PackedStructureType(types.toArray(new Type[types.size()]));
    }

    public static StructureType getClassType(OS os, Arch arch, SootClass clazz) {
        ArrayList<PackedStructureType> types = new ArrayList<PackedStructureType>();
        int offset = 0;
        for (SootField field : Types.getClassFields(os, arch, clazz)) {
            int falign = Types.getFieldAlignment(os, arch, field);
            int padding = (offset & falign - 1) != 0 ? falign - (offset & falign - 1) : 0;
            types.add(Types.padType(Types.getType(field.getType()), padding));
            offset += padding + Types.getFieldSize(arch, field);
        }
        return new StructureType(CLASS, new StructureType(types.toArray(new Type[types.size()])));
    }

    public static StructureType getInstanceType(OS os, Arch arch, SootClass clazz) {
        return new StructureType(DATA_OBJECT, Types.getInstanceType0(os, arch, clazz, 1, new int[]{0}));
    }

    public static int getFieldAlignment(OS os, Arch arch, SootField f) {
        soot.Type t = f.getType();
        if (arch.is32Bit() && arch.isArm() && LongType.v().equals(t)) {
            return 8;
        }
        if (LongType.v().equals(t) || DoubleType.v().equals(t)) {
            return arch.is32Bit() ? 4 : 8;
        }
        return Types.getFieldSize(arch, f);
    }

    public static int getFieldSize(Arch arch, SootField f) {
        soot.Type t = f.getType();
        if (LongType.v().equals(t) || DoubleType.v().equals(t)) {
            return 8;
        }
        if (IntType.v().equals(t) || FloatType.v().equals(t)) {
            return 4;
        }
        if (t instanceof RefLikeType) {
            return arch.is32Bit() ? 4 : 8;
        }
        if (ShortType.v().equals(t) || CharType.v().equals(t)) {
            return 2;
        }
        if (ByteType.v().equals(t) || BooleanType.v().equals(t)) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown Type: " + t);
    }

    public static Value getFieldPtr(Function f, Value base, Constant offset, Type fieldType) {
        Variable baseI8Ptr = f.newVariable(Type.I8_PTR);
        f.add(new Bitcast(baseI8Ptr, base, Type.I8_PTR));
        Variable fieldI8Ptr = f.newVariable(Type.I8_PTR);
        f.add(new Getelementptr(fieldI8Ptr, (Value)baseI8Ptr.ref(), offset));
        Variable fieldPtr = f.newVariable(new PointerType(fieldType));
        f.add(new Bitcast(fieldPtr, fieldI8Ptr.ref(), fieldPtr.getType()));
        return fieldPtr.ref();
    }

    public static List<SootField> getFields(final OS os, final Arch arch, SootClass clazz, boolean ztatic) {
        ArrayList<SootField> l = new ArrayList<SootField>();
        for (SootField f : clazz.getFields()) {
            if (ztatic != f.isStatic()) continue;
            l.add(f);
        }
        Collections.sort(l, new Comparator<SootField>(){

            @Override
            public int compare(SootField o1, SootField o2) {
                soot.Type t1 = o1.getType();
                soot.Type t2 = o2.getType();
                if (t1 instanceof RefLikeType && !(t2 instanceof RefLikeType)) {
                    return -1;
                }
                if (t2 instanceof RefLikeType && !(t1 instanceof RefLikeType)) {
                    return 1;
                }
                int align1 = Types.getFieldAlignment(os, arch, o1);
                int align2 = Types.getFieldAlignment(os, arch, o2);
                int c = new Integer(align2).compareTo(align1);
                if (c == 0) {
                    int size1 = Types.getFieldSize(arch, o1);
                    int size2 = Types.getFieldSize(arch, o2);
                    c = new Integer(size2).compareTo(size1);
                    if (c == 0 && (c = t1.getClass().getSimpleName().compareTo(t2.getClass().getSimpleName())) == 0) {
                        c = o1.getName().compareTo(o2.getName());
                    }
                }
                return c;
            }
        });
        return l;
    }

    public static List<SootField> getClassFields(OS os, Arch arch, SootClass clazz) {
        return Types.getFields(os, arch, clazz, true);
    }

    public static List<SootField> getInstanceFields(OS os, Arch arch, SootClass clazz) {
        return Types.getFields(os, arch, clazz, false);
    }
}

