/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.robovm.compiler.Annotations;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.objc.ObjCProtocolProxyPlugin;
import org.robovm.compiler.plugin.objc.TypeEncoder;
import org.robovm.compiler.util.generic.SootMethodType;
import soot.Body;
import soot.BooleanType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.PatchingChain;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.ClassConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Host;
import soot.tagkit.SignatureTag;

public class ObjCMemberPlugin
extends AbstractCompilerPlugin {
    public static final String OBJC_ANNOTATIONS_PACKAGE = "org/robovm/objc/annotation";
    public static final String METHOD = "Lorg/robovm/objc/annotation/Method;";
    public static final String PROPERTY = "Lorg/robovm/objc/annotation/Property;";
    public static final String BIND_SELECTOR = "Lorg/robovm/objc/annotation/BindSelector;";
    public static final String NOT_IMPLEMENTED = "Lorg/robovm/objc/annotation/NotImplemented;";
    public static final String IBACTION = "Lorg/robovm/objc/annotation/IBAction;";
    public static final String IBOUTLET = "Lorg/robovm/objc/annotation/IBOutlet;";
    public static final String IBINSPECTABLE = "Lorg/robovm/objc/annotation/IBInspectable;";
    public static final String IBOUTLETCOLLECTION = "Lorg/robovm/objc/annotation/IBOutletCollection;";
    public static final String NATIVE_CLASS = "Lorg/robovm/objc/annotation/NativeClass;";
    public static final String CUSTOM_CLASS = "Lorg/robovm/objc/annotation/CustomClass;";
    public static final String NATIVE_PROTOCOL_PROXY = "Lorg/robovm/objc/annotation/NativeProtocolProxy;";
    public static final String TYPE_ENCODING = "Lorg/robovm/objc/annotation/TypeEncoding;";
    public static final String SELECTOR = "org.robovm.objc.Selector";
    public static final String NATIVE_OBJECT = "org.robovm.rt.bro.NativeObject";
    public static final String OBJC_SUPER = "org.robovm.objc.ObjCSuper";
    public static final String OBJC_CLASS = "org.robovm.objc.ObjCClass";
    public static final String OBJC_OBJECT = "org.robovm.objc.ObjCObject";
    public static final String OBJC_RUNTIME = "org.robovm.objc.ObjCRuntime";
    public static final String OBJC_EXTENSIONS = "org.robovm.objc.ObjCExtensions";
    public static final String NS_OBJECT = "org.robovm.apple.foundation.NSObject";
    public static final String NS_OBJECT$MARSHALER = "org.robovm.apple.foundation.NSObject$Marshaler";
    public static final String NS_STRING$AS_STRING_MARSHALER = "org.robovm.apple.foundation.NSString$AsStringMarshaler";
    public static final String $M = "org.robovm.objc.$M";
    public static final String UI_EVENT = "org.robovm.apple.uikit.UIEvent";
    public static final String UI_APPLICATION_DELEGATE = "org.robovm.apple.uikit.UIApplicationDelegate";
    public static final String NS_ARRAY = "org.robovm.apple.foundation.NSArray";
    private boolean initialized = false;
    private Config config;
    private SootClass org_robovm_rt_bro_NativeObject = null;
    private SootClass org_robovm_objc_ObjCClass = null;
    private SootClass org_robovm_objc_ObjCSuper = null;
    private SootClass org_robovm_objc_ObjCObject = null;
    private SootClass org_robovm_objc_ObjCRuntime = null;
    private SootClass org_robovm_objc_ObjCExtensions = null;
    private SootClass org_robovm_objc_Selector = null;
    private SootClass java_lang_String = null;
    private SootClass java_lang_Class = null;
    private SootClass org_robovm_apple_foundation_NSObject = null;
    private SootClass org_robovm_objc_$M = null;
    private SootClass org_robovm_apple_uikit_UIEvent = null;
    private SootClass org_robovm_apple_uikit_UIApplicationDelegate = null;
    private SootClass org_robovm_apple_foundation_NSArray = null;
    private SootClass org_robovm_apple_foundation_NSObject$Marshaler = null;
    private SootClass org_robovm_apple_foundation_NSString$AsStringMarshaler = null;
    private SootMethodRef org_robovm_objc_ObjCObject_getSuper = null;
    private SootFieldRef org_robovm_objc_ObjCObject_customClass = null;
    private SootMethodRef org_robovm_objc_ObjCClass_getByType = null;
    private SootMethodRef org_robovm_objc_ObjCRuntime_bind = null;
    private SootMethodRef org_robovm_objc_ObjCObject_updateStrongRef = null;
    private SootMethodRef org_robovm_objc_ObjCExtensions_updateStrongRef = null;
    private SootMethodRef org_robovm_objc_Selector_register = null;
    private SootMethodRef org_robovm_objc_ObjCObject_getPeerObject = null;
    private SootMethodRef org_robovm_objc_ObjCObject_retainCustomObjectFromCb = null;
    private SootMethodRef org_robovm_rt_bro_NativeObject_setHandle = null;
    private SootMethodRef org_robovm_rt_bro_NativeObject_getHandle = null;
    private SootMethodRef org_robovm_apple_foundation_NSObject_forceSkipInit = null;
    private SootClass java_lang_NoSuchMethodError = null;
    private SootMethodRef java_lang_NoSuchMethodError_init = null;

    static SootMethod getOrCreateStaticInitializer(SootClass sootClass) {
        for (SootMethod m : sootClass.getMethods()) {
            if (!"<clinit>".equals(m.getName())) continue;
            return m;
        }
        SootMethod m = new SootMethod("<clinit>", Collections.emptyList(), VoidType.v(), 8);
        JimpleBody body = Jimple.v().newBody(m);
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        m.setActiveBody(body);
        sootClass.addMethod(m);
        return m;
    }

    private String getSelectorFieldName(String selectorName) {
        return "$sel$" + selectorName.replace(':', '$');
    }

    private SootField getSelectorField(String selectorName) {
        return new SootField(this.getSelectorFieldName(selectorName), this.org_robovm_objc_Selector.getType(), 26);
    }

    private SootMethod getMsgSendMethod(String selectorName, SootMethod method, SootMethod annotatedMethod, boolean isCallback, Type receiverType, boolean extensions) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        if (extensions) {
            paramTypes.add(method.getParameterType(0));
        } else if (method.isStatic()) {
            paramTypes.add(this.org_robovm_objc_ObjCClass.getType());
        } else {
            paramTypes.add(receiverType == null ? method.getDeclaringClass().getType() : receiverType);
        }
        paramTypes.add(this.org_robovm_objc_Selector.getType());
        if (extensions) {
            paramTypes.addAll(method.getParameterTypes().subList(1, method.getParameterTypes().size()));
        } else {
            paramTypes.addAll(method.getParameterTypes());
        }
        SootMethod m = new SootMethod((isCallback ? "$cb$" : "$m$") + selectorName.replace(':', '$'), paramTypes, method.getReturnType(), 0xA | (isCallback ? 0 : 256));
        ObjCMemberPlugin.copyAnnotations(annotatedMethod, m, extensions);
        this.createGenericSignatureForMsgSend(annotatedMethod, m, paramTypes, extensions);
        return m;
    }

    private SootMethod getMsgSendInitMethod(String selectorName, SootMethod method) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        paramTypes.add(LongType.v());
        paramTypes.add(this.org_robovm_objc_Selector.getType());
        paramTypes.addAll(method.getParameterTypes());
        SootMethod m = new SootMethod("$cb$" + selectorName.replace(':', '$'), paramTypes, LongType.v(), 10);
        ObjCMemberPlugin.copyAnnotations(method, m, false);
        Annotations.addRuntimeVisibleParameterAnnotation(m, 0, "Lorg/robovm/rt/bro/annotation/Pointer;");
        Annotations.addRuntimeVisibleAnnotation((Host)m, "Lorg/robovm/rt/bro/annotation/Pointer;");
        this.createGenericSignatureForMsgSend(method, m, paramTypes, false);
        return m;
    }

    private void createGenericSignatureForMsgSend(SootMethod annotatedMethod, SootMethod m, List<Type> paramTypes, boolean extensions) {
        SignatureTag tag = (SignatureTag)annotatedMethod.getTag(SignatureTag.class.getSimpleName());
        if (tag != null) {
            SootMethodType type = new SootMethodType(annotatedMethod);
            ArrayList<String> genericParameterTypes = new ArrayList<String>();
            for (org.robovm.compiler.util.generic.Type t : type.getGenericParameterTypes()) {
                genericParameterTypes.add(t.toGenericSignature());
            }
            if (!extensions) {
                genericParameterTypes.add(0, Types.getDescriptor(paramTypes.get(0)));
            }
            genericParameterTypes.add(1, Types.getDescriptor(paramTypes.get(1)));
            StringBuilder sb = new StringBuilder("(");
            sb.append(StringUtils.join(genericParameterTypes, ""));
            sb.append(")");
            sb.append(type.getGenericReturnType().toGenericSignature());
            m.addTag(new SignatureTag(sb.toString()));
        }
    }

    private static void copyAnnotations(SootMethod fromMethod, SootMethod toMethod, boolean extensions) {
        Annotations.copyAnnotations(fromMethod, toMethod, Annotations.Visibility.Any);
        if (extensions) {
            Annotations.copyParameterAnnotations(fromMethod, toMethod, 0, 1, 0, Annotations.Visibility.Any);
            if (fromMethod.getParameterCount() > 1) {
                Annotations.copyParameterAnnotations(fromMethod, toMethod, 1, fromMethod.getParameterCount(), 1, Annotations.Visibility.Any);
            }
        } else {
            Annotations.copyParameterAnnotations(fromMethod, toMethod, 0, fromMethod.getParameterCount(), 2, Annotations.Visibility.Any);
        }
    }

    private SootMethod getMsgSendMethod(String selectorName, SootMethod method, boolean extensions) {
        return this.getMsgSendMethod(selectorName, method, method, false, null, extensions);
    }

    private SootMethod getMsgSendSuperMethod(String selectorName, SootMethod method) {
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        paramTypes.add(this.org_robovm_objc_ObjCSuper.getType());
        paramTypes.add(this.org_robovm_objc_Selector.getType());
        paramTypes.addAll(method.getParameterTypes());
        SootMethod m = new SootMethod("$m$super$" + selectorName.replace(':', '$'), paramTypes, method.getReturnType(), 266);
        ObjCMemberPlugin.copyAnnotations(method, m, false);
        this.createGenericSignatureForMsgSend(method, m, paramTypes, false);
        return m;
    }

    private SootMethod getCallbackMethod(String selectorName, SootMethod method, SootMethod annotatedMethod, Type receiverType) {
        return this.getMsgSendMethod(selectorName, method, annotatedMethod, true, receiverType, false);
    }

    private void addBindCall(SootClass sootClass) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        String internalName = sootClass.getName().replace('.', '/');
        ClassConstant c = ClassConstant.v(internalName);
        PatchingChain<Unit> units = body.getUnits();
        for (Unit unit : units) {
            StaticInvokeExpr expr;
            SootMethodRef ref;
            InvokeStmt stmt;
            if (!(unit instanceof InvokeStmt) || !((stmt = (InvokeStmt)unit).getInvokeExpr() instanceof StaticInvokeExpr) || !(ref = (expr = (StaticInvokeExpr)stmt.getInvokeExpr()).getMethodRef()).isStatic() || !ref.declaringClass().equals(this.org_robovm_objc_ObjCRuntime) || !ref.name().equals("bind") || !ref.parameterTypes().isEmpty() && !expr.getArg(0).equals(c)) continue;
            return;
        }
        units.insertBefore(j.newInvokeStmt(j.newStaticInvokeExpr(this.org_robovm_objc_ObjCRuntime_bind, ClassConstant.v(internalName))), (Unit)units.getLast());
    }

    private void addObjCClassField(SootClass sootClass) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        Local objCClass = Jimple.v().newLocal("$objCClass", this.org_robovm_objc_ObjCClass.getType());
        body.getLocals().add(objCClass);
        PatchingChain<Unit> units = body.getUnits();
        SootField f = new SootField("$objCClass", this.org_robovm_objc_ObjCClass.getType(), 26);
        sootClass.addField(f);
        units.insertBefore((Unit)((Object)Arrays.asList(j.newAssignStmt(objCClass, j.newStaticInvokeExpr(this.org_robovm_objc_ObjCClass_getByType, ClassConstant.v(sootClass.getName().replace('.', '/')))), j.newAssignStmt(j.newStaticFieldRef(f.makeRef()), objCClass))), (Unit)units.getLast());
    }

    private void registerSelectors(SootClass sootClass, Set<String> selectors) {
        Jimple j = Jimple.v();
        SootMethod clinit = ObjCMemberPlugin.getOrCreateStaticInitializer(sootClass);
        Body body = clinit.retrieveActiveBody();
        Local sel = Jimple.v().newLocal("$sel", this.org_robovm_objc_Selector.getType());
        body.getLocals().add(sel);
        PatchingChain<Unit> units = body.getUnits();
        for (String selectorName : selectors) {
            SootField f = this.getSelectorField(selectorName);
            sootClass.addField(f);
            units.insertBefore((Unit)((Object)Arrays.asList(j.newAssignStmt(sel, j.newStaticInvokeExpr(this.org_robovm_objc_Selector_register, StringConstant.v(selectorName))), j.newAssignStmt(j.newStaticFieldRef(f.makeRef()), sel))), (Unit)units.getLast());
        }
    }

    private void init(Config config) {
        if (this.initialized) {
            return;
        }
        this.config = config;
        if (config.getClazzes().load(OBJC_OBJECT.replace('.', '/')) == null) {
            this.initialized = true;
            return;
        }
        SootResolver r = SootResolver.v();
        this.org_robovm_objc_ObjCObject = r.resolveClass(OBJC_OBJECT, 1);
        this.org_robovm_objc_ObjCExtensions = r.resolveClass(OBJC_EXTENSIONS, 1);
        this.org_robovm_rt_bro_NativeObject = r.makeClassRef(NATIVE_OBJECT);
        this.org_robovm_objc_ObjCClass = r.makeClassRef(OBJC_CLASS);
        this.org_robovm_objc_ObjCSuper = r.makeClassRef(OBJC_SUPER);
        this.org_robovm_objc_ObjCRuntime = r.makeClassRef(OBJC_RUNTIME);
        this.org_robovm_objc_Selector = r.makeClassRef(SELECTOR);
        this.org_robovm_apple_foundation_NSObject = r.makeClassRef(NS_OBJECT);
        this.org_robovm_apple_foundation_NSObject$Marshaler = r.makeClassRef(NS_OBJECT$MARSHALER);
        this.org_robovm_apple_foundation_NSString$AsStringMarshaler = r.makeClassRef(NS_STRING$AS_STRING_MARSHALER);
        this.org_robovm_objc_$M = r.makeClassRef($M);
        this.org_robovm_apple_uikit_UIEvent = r.makeClassRef(UI_EVENT);
        this.org_robovm_apple_uikit_UIApplicationDelegate = r.makeClassRef(UI_APPLICATION_DELEGATE);
        this.org_robovm_apple_foundation_NSArray = r.makeClassRef(NS_ARRAY);
        SootClass java_lang_Object = r.makeClassRef("java.lang.Object");
        this.java_lang_String = r.makeClassRef("java.lang.String");
        this.java_lang_Class = r.makeClassRef("java.lang.Class");
        this.org_robovm_objc_Selector_register = Scene.v().makeMethodRef(this.org_robovm_objc_Selector, "register", Arrays.asList(this.java_lang_String.getType()), this.org_robovm_objc_Selector.getType(), true);
        this.org_robovm_objc_ObjCObject_getSuper = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "getSuper", Collections.emptyList(), this.org_robovm_objc_ObjCSuper.getType(), false);
        this.org_robovm_objc_ObjCObject_updateStrongRef = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "updateStrongRef", Arrays.asList(java_lang_Object.getType(), java_lang_Object.getType()), VoidType.v(), false);
        this.org_robovm_objc_ObjCClass_getByType = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCClass, "getByType", Arrays.asList(this.java_lang_Class.getType()), this.org_robovm_objc_ObjCClass.getType(), true);
        this.org_robovm_objc_ObjCRuntime_bind = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCRuntime, "bind", Arrays.asList(this.java_lang_Class.getType()), VoidType.v(), true);
        this.org_robovm_objc_ObjCObject_customClass = Scene.v().makeFieldRef(this.org_robovm_objc_ObjCObject, "customClass", BooleanType.v(), false);
        this.org_robovm_objc_ObjCExtensions_updateStrongRef = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCExtensions, "updateStrongRef", Arrays.asList(this.org_robovm_objc_ObjCObject.getType(), java_lang_Object.getType(), java_lang_Object.getType()), VoidType.v(), true);
        this.org_robovm_objc_ObjCObject_getPeerObject = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "getPeerObject", Arrays.asList(LongType.v()), this.org_robovm_objc_ObjCObject.getType(), true);
        this.org_robovm_objc_ObjCObject_retainCustomObjectFromCb = Scene.v().makeMethodRef(this.org_robovm_objc_ObjCObject, "retainCustomObjectFromCb", Arrays.asList(LongType.v()), VoidType.v(), true);
        this.org_robovm_rt_bro_NativeObject_setHandle = Scene.v().makeMethodRef(this.org_robovm_rt_bro_NativeObject, "setHandle", Arrays.asList(LongType.v()), VoidType.v(), false);
        this.org_robovm_rt_bro_NativeObject_getHandle = Scene.v().makeMethodRef(this.org_robovm_rt_bro_NativeObject, "getHandle", Collections.emptyList(), LongType.v(), false);
        this.org_robovm_apple_foundation_NSObject_forceSkipInit = Scene.v().makeMethodRef(this.org_robovm_apple_foundation_NSObject, "forceSkipInit", Collections.emptyList(), VoidType.v(), false);
        this.java_lang_NoSuchMethodError = r.makeClassRef("java.lang.NoSuchMethodError");
        this.java_lang_NoSuchMethodError_init = Scene.v().makeMethodRef(this.java_lang_NoSuchMethodError, "<init>", Arrays.asList(this.java_lang_String.getType()), VoidType.v(), false);
        this.initialized = true;
    }

    private boolean isAssignable(SootClass cls, SootClass type) {
        if (type == null || type.isPhantom()) {
            return false;
        }
        if (type.isInterface()) {
            while (cls != null) {
                for (SootClass inf : cls.getInterfaces()) {
                    if (inf != type) continue;
                    return true;
                }
                cls = cls.hasSuperclass() ? cls.getSuperclass() : null;
            }
            return false;
        }
        while (cls != type && cls.hasSuperclass()) {
            cls = cls.getSuperclass();
        }
        return cls == type;
    }

    private boolean isObjCObject(SootClass cls) {
        return this.isAssignable(cls, this.org_robovm_objc_ObjCObject);
    }

    private boolean isObjCExtensions(SootClass cls) {
        return this.isAssignable(cls, this.org_robovm_objc_ObjCExtensions);
    }

    private boolean isNSObject(Type type) {
        return type instanceof RefType && this.isAssignable(((RefType)type).getSootClass(), this.org_robovm_apple_foundation_NSObject);
    }

    private boolean isUIEvent(Type type) {
        return type instanceof RefType && this.isAssignable(((RefType)type).getSootClass(), this.org_robovm_apple_uikit_UIEvent);
    }

    private boolean isUIApplicationDelegate(Type type) {
        return type instanceof RefType && this.isAssignable(((RefType)type).getSootClass(), this.org_robovm_apple_uikit_UIApplicationDelegate);
    }

    private boolean isSelector(Type type) {
        return type instanceof RefType && this.isAssignable(((RefType)type).getSootClass(), this.org_robovm_objc_Selector);
    }

    private boolean isNSArray(Type type) {
        return type instanceof RefType && this.isAssignable(((RefType)type).getSootClass(), this.org_robovm_apple_foundation_NSArray);
    }

    private boolean isNSObject$Marshaler_toNative(SootMethod method) {
        return method.getDeclaringClass().getType().equals(this.org_robovm_apple_foundation_NSObject$Marshaler.getType()) && method.getName().equals("toNative") && method.getParameterCount() == 2 && method.getParameterType(0).equals(this.org_robovm_apple_foundation_NSObject.getType()) && method.getParameterType(1).equals(LongType.v()) && method.getReturnType().equals(LongType.v());
    }

    private boolean isNSObject$Marshaler_toObject(SootMethod method) {
        return method.getDeclaringClass().getType().equals(this.org_robovm_apple_foundation_NSObject$Marshaler.getType()) && method.getName().equals("toObject") && method.getParameterCount() == 3 && method.getParameterType(0).equals(this.java_lang_Class.getType()) && method.getParameterType(1).equals(LongType.v()) && method.getParameterType(2).equals(LongType.v()) && method.getReturnType().equals(this.org_robovm_apple_foundation_NSObject.getType());
    }

    private boolean isNSString$AsStringMarshaler_toNative(SootMethod method) {
        return method.getDeclaringClass().getType().equals(this.org_robovm_apple_foundation_NSString$AsStringMarshaler.getType()) && method.getName().equals("toNative") && method.getParameterCount() == 2 && method.getParameterType(0).equals(this.java_lang_String.getType()) && method.getParameterType(1).equals(LongType.v()) && method.getReturnType().equals(LongType.v());
    }

    private boolean isNSString$AsStringMarshaler_toObject(SootMethod method) {
        return method.getDeclaringClass().getType().equals(this.org_robovm_apple_foundation_NSString$AsStringMarshaler.getType()) && method.getName().equals("toObject") && method.getParameterCount() == 3 && method.getParameterType(0).equals(this.java_lang_Class.getType()) && method.getParameterType(1).equals(LongType.v()) && method.getParameterType(2).equals(LongType.v()) && method.getReturnType().equals(this.java_lang_String.getType());
    }

    private boolean isCustomClass(SootClass cls) {
        return !Annotations.hasAnnotation(cls, NATIVE_CLASS) && !Annotations.hasAnnotation(cls, NATIVE_PROTOCOL_PROXY) && this.isNSObject(cls.getType());
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) {
        boolean uiAppDelegate;
        this.init(config);
        SootClass sootClass = clazz.getSootClass();
        boolean extensions = false;
        boolean customClass = Annotations.hasAnnotation(sootClass, CUSTOM_CLASS);
        boolean bl = uiAppDelegate = !customClass && this.isUIApplicationDelegate(sootClass.getType());
        if (!sootClass.isInterface() && (this.isObjCObject(sootClass) || (extensions = this.isObjCExtensions(sootClass)))) {
            if (customClass) {
                this.transformIBOutletFieldToSetters(sootClass);
            }
            TreeSet<String> selectors = new TreeSet<String>();
            HashSet<String> overridables = new HashSet<String>();
            HashSet<String> initializers = new HashSet<String>();
            for (SootMethod method : sootClass.getMethods()) {
                if (!"<clinit>".equals(method.getName()) && !"<init>".equals(method.getName())) {
                    this.transformMethod(config, clazz, sootClass, method, selectors, overridables, extensions);
                    continue;
                }
                if (!customClass && !uiAppDelegate || !"<init>".equals(method.getName())) continue;
                this.transformConstructor(sootClass, method, initializers);
            }
            if (customClass || uiAppDelegate) {
                this.transformParentConstructors(sootClass, initializers);
            }
            this.addBindCall(sootClass);
            if (!extensions) {
                this.addObjCClassField(sootClass);
            }
            this.registerSelectors(sootClass, selectors);
        }
    }

    private static <E> List<E> l(E head, List<E> tail) {
        LinkedList<E> l = new LinkedList<E>(tail);
        l.addFirst(head);
        return l;
    }

    private boolean isOverridable(SootMethod method) {
        return !method.isStatic() && !method.isPrivate() && (method.getModifiers() & 0x10) == 0 && (method.getDeclaringClass().getModifiers() & 0x10) == 0;
    }

    private boolean checkOverridable(Set<String> overridables, String selectorName, SootMethod method) {
        boolean b = this.isOverridable(method);
        if (b && overridables.contains(selectorName)) {
            throw new CompilerException("Found multiple overridable @Method or @Property methods in " + method.getDeclaringClass() + " with the selector '" + selectorName + "'.");
        }
        return b;
    }

    private void transformConstructor(SootClass sootClass, SootMethod constructor, Set<String> initializers) {
        SootMethod superConstructor;
        initializers.add(constructor.getSubSignature());
        AnnotationTag annotation2 = Annotations.getAnnotation(constructor, METHOD);
        if (annotation2 == null && (superConstructor = this.findOverridenMethodWithAnnotation(sootClass, constructor, METHOD)) != null) {
            annotation2 = Annotations.getAnnotation(superConstructor, METHOD);
        }
        if (annotation2 == null) {
            return;
        }
        String selectorName = Annotations.readStringElem(annotation2, "selector", "").trim();
        if (selectorName.length() == 0) {
            return;
        }
        this.createConstructorCallback(sootClass, constructor, selectorName);
    }

    private void transformParentConstructors(SootClass sootClass, Set<String> initializers) {
        SootMethod defaultConstructor;
        try {
            defaultConstructor = sootClass.getMethod("<init>", Collections.emptyList(), VoidType.v());
        }
        catch (RuntimeException e) {
            defaultConstructor = null;
        }
        SootClass supercls = sootClass.getSuperclass();
        while (!supercls.getType().equals(this.org_robovm_objc_ObjCObject.getType())) {
            for (SootMethod method : supercls.getMethods()) {
                String selectorName;
                SootMethod superConstructor;
                if (!"<init>".equals(method.getName()) || initializers.contains(method.getSubSignature())) continue;
                initializers.add(method.getSubSignature());
                AnnotationTag annotation2 = Annotations.getAnnotation(method, METHOD);
                if (annotation2 == null && (superConstructor = this.findOverridenMethodWithAnnotation(supercls, method, METHOD)) != null) {
                    annotation2 = Annotations.getAnnotation(superConstructor, METHOD);
                }
                if (annotation2 == null || (selectorName = Annotations.readStringElem(annotation2, "selector", "").trim()).length() == 0) continue;
                if (defaultConstructor != null) {
                    this.createParentConstructorCallback(sootClass, defaultConstructor, method, selectorName);
                    continue;
                }
                this.createParentConstructorExceptionCallback(sootClass, method, selectorName);
            }
            supercls = supercls.getSuperclass();
        }
    }

    private void createConstructorCallback(SootClass sootClass, SootMethod constructor, String selectorName) {
        Jimple jimple = Jimple.v();
        SootMethod callbackMethod = this.getMsgSendInitMethod(selectorName, constructor);
        sootClass.addMethod(callbackMethod);
        ObjCMemberPlugin.addCallbackAnnotation(callbackMethod);
        ObjCMemberPlugin.addBindSelectorAnnotation(callbackMethod, selectorName);
        JimpleBody jimpleBody = jimple.newBody(callbackMethod);
        callbackMethod.setActiveBody(jimpleBody);
        Body body = callbackMethod.getActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        jimpleBody.insertIdentityStmts();
        ArrayList<Local> args = new ArrayList<Local>(jimpleBody.getLocals());
        Local self = jimple.newLocal("$self", LongType.v());
        body.getLocals().add(self);
        units.add(jimple.newIdentityStmt(self, jimple.newParameterRef(LongType.v(), 0)));
        Local thiz = jimple.newLocal("$this", sootClass.getType());
        body.getLocals().add(thiz);
        NopStmt noClassCreatedAnchor = jimple.newNopStmt();
        NopStmt classAlreadyCreated = jimple.newNopStmt();
        Local peer = jimple.newLocal("$peer", this.org_robovm_objc_ObjCObject.getType());
        body.getLocals().add(peer);
        units.add(jimple.newAssignStmt(peer, jimple.newStaticInvokeExpr(this.org_robovm_objc_ObjCObject_getPeerObject, self)));
        units.add(jimple.newAssignStmt(thiz, jimple.newCastExpr(peer, thiz.getType())));
        units.add(jimple.newIfStmt((Value)jimple.newEqExpr(thiz, NullConstant.v()), noClassCreatedAnchor));
        units.add(classAlreadyCreated);
        units.add(jimple.newReturnStmt(self));
        units.add(noClassCreatedAnchor);
        units.add(jimple.newAssignStmt(thiz, jimple.newNewExpr(sootClass.getType())));
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, this.org_robovm_rt_bro_NativeObject_setHandle, self)));
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, constructor.makeRef(), args.subList(2, args.size()))));
        SootMethod afterMarshaled = this.findMethod(sootClass, "afterMarshaled", Arrays.asList(IntType.v()), VoidType.v(), true);
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, afterMarshaled.makeRef(), IntConstant.v(0))));
        units.add(jimple.newInvokeStmt(jimple.newStaticInvokeExpr(this.org_robovm_objc_ObjCObject_retainCustomObjectFromCb, self)));
        units.add(jimple.newAssignStmt(self, jimple.newSpecialInvokeExpr(thiz, this.org_robovm_rt_bro_NativeObject_getHandle)));
        units.add(jimple.newReturnStmt(self));
    }

    private void createParentConstructorCallback(SootClass sootClass, SootMethod defaultConstructor, SootMethod parentConstructor, String selectorName) {
        SootMethod initMethod = this.findMethod(sootClass, "init", parentConstructor.getParameterTypes(), LongType.v(), true);
        if (initMethod == null) {
            this.createParentConstructorExceptionCallback(sootClass, parentConstructor, selectorName);
            return;
        }
        Jimple jimple = Jimple.v();
        SootMethod callbackMethod = this.getMsgSendInitMethod(selectorName, parentConstructor);
        sootClass.addMethod(callbackMethod);
        ObjCMemberPlugin.addCallbackAnnotation(callbackMethod);
        ObjCMemberPlugin.addBindSelectorAnnotation(callbackMethod, selectorName);
        JimpleBody jimpleBody = jimple.newBody(callbackMethod);
        callbackMethod.setActiveBody(jimpleBody);
        Body body = callbackMethod.getActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        jimpleBody.insertIdentityStmts();
        ArrayList<Local> args = new ArrayList<Local>(jimpleBody.getLocals());
        Local self = jimple.newLocal("$self", LongType.v());
        body.getLocals().add(self);
        units.add(jimple.newIdentityStmt(self, jimple.newParameterRef(LongType.v(), 0)));
        Local thiz = jimple.newLocal("$this", sootClass.getType());
        body.getLocals().add(thiz);
        NopStmt noClassCreatedAnchor = jimple.newNopStmt();
        NopStmt classAlreadyCreated = jimple.newNopStmt();
        Local peer = jimple.newLocal("$peer", this.org_robovm_objc_ObjCObject.getType());
        body.getLocals().add(peer);
        units.add(jimple.newAssignStmt(peer, jimple.newStaticInvokeExpr(this.org_robovm_objc_ObjCObject_getPeerObject, self)));
        units.add(jimple.newAssignStmt(thiz, jimple.newCastExpr(peer, thiz.getType())));
        units.add(jimple.newIfStmt((Value)jimple.newEqExpr(thiz, NullConstant.v()), noClassCreatedAnchor));
        units.add(classAlreadyCreated);
        units.add(jimple.newReturnStmt(self));
        units.add(noClassCreatedAnchor);
        units.add(jimple.newAssignStmt(thiz, jimple.newNewExpr(sootClass.getType())));
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, this.org_robovm_rt_bro_NativeObject_setHandle, self)));
        if (this.isNSObject(sootClass.getType())) {
            units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, this.org_robovm_apple_foundation_NSObject_forceSkipInit)));
        }
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, defaultConstructor.makeRef(), Collections.emptyList())));
        units.add(jimple.newAssignStmt(self, jimple.newSpecialInvokeExpr(thiz, initMethod.makeRef(), args.subList(2, args.size()))));
        SootMethod initObject = this.findMethod(sootClass, "initObject", Arrays.asList(LongType.v()), VoidType.v(), true);
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, initObject.makeRef(), self)));
        SootMethod afterMarshaled = this.findMethod(sootClass, "afterMarshaled", Arrays.asList(IntType.v()), VoidType.v(), true);
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(thiz, afterMarshaled.makeRef(), IntConstant.v(0))));
        units.add(jimple.newInvokeStmt(jimple.newStaticInvokeExpr(this.org_robovm_objc_ObjCObject_retainCustomObjectFromCb, self)));
        units.add(jimple.newAssignStmt(self, jimple.newSpecialInvokeExpr(thiz, this.org_robovm_rt_bro_NativeObject_getHandle)));
        units.add(jimple.newReturnStmt(self));
    }

    private void createParentConstructorExceptionCallback(SootClass sootClass, SootMethod constructor, String selectorName) {
        Jimple jimple = Jimple.v();
        SootMethod callbackMethod = this.getMsgSendInitMethod(selectorName, constructor);
        sootClass.addMethod(callbackMethod);
        ObjCMemberPlugin.addCallbackAnnotation(callbackMethod);
        ObjCMemberPlugin.addBindSelectorAnnotation(callbackMethod, selectorName);
        callbackMethod.setActiveBody(jimple.newBody(callbackMethod));
        Body body = callbackMethod.getActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        Local self = jimple.newLocal("$self", LongType.v());
        body.getLocals().add(self);
        units.add(jimple.newIdentityStmt(self, jimple.newParameterRef(LongType.v(), 0)));
        Local thiz = jimple.newLocal("$this", sootClass.getType());
        body.getLocals().add(thiz);
        Local peer = jimple.newLocal("$peer", this.org_robovm_objc_ObjCObject.getType());
        body.getLocals().add(peer);
        units.add(jimple.newAssignStmt(peer, jimple.newStaticInvokeExpr(this.org_robovm_objc_ObjCObject_getPeerObject, self)));
        units.add(jimple.newAssignStmt(thiz, jimple.newCastExpr(peer, thiz.getType())));
        NopStmt noClassCreatedAnchor = jimple.newNopStmt();
        NopStmt classAlreadyCreatedAnchor = jimple.newNopStmt();
        units.add(jimple.newIfStmt((Value)jimple.newEqExpr(thiz, NullConstant.v()), noClassCreatedAnchor));
        units.add(classAlreadyCreatedAnchor);
        units.add(jimple.newReturnStmt(self));
        units.add(noClassCreatedAnchor);
        String msg = String.format("Objctive-C called -%s which could not be mapped to a constructor in %s. Expected a default constructor or a %s constructor.", selectorName, sootClass.getName(), constructor.getSubSignature());
        Local exc = jimple.newLocal("$exc", this.java_lang_NoSuchMethodError.getType());
        body.getLocals().add(exc);
        units.add(jimple.newAssignStmt(exc, jimple.newNewExpr(this.java_lang_NoSuchMethodError.getType())));
        units.add(jimple.newInvokeStmt(jimple.newSpecialInvokeExpr(exc, this.java_lang_NoSuchMethodError_init, StringConstant.v(msg))));
        units.add(jimple.newThrowStmt(exc));
    }

    private void transformIBOutletFieldToSetters(SootClass sootClass) {
        for (SootField field : sootClass.getFields()) {
            AnnotationTag annotation2 = Annotations.getAnnotation(field, IBOUTLETCOLLECTION);
            if (annotation2 != null) {
                if (!this.isNSArray(field.getType())) {
                    throw new CompilerException("Objective-C @IBOutletCollection field " + field + " must be of type NSArray.");
                }
            } else {
                annotation2 = Annotations.getAnnotation(field, IBOUTLET);
                if (annotation2 == null) {
                    annotation2 = Annotations.getAnnotation(field, IBINSPECTABLE);
                }
            }
            if (annotation2 == null) continue;
            if (field.isStatic()) {
                throw new CompilerException("Objective-C @IBOutlet/@IBOutletCollection/@IBInspectable field " + field + " must not be static.");
            }
            if (field.isFinal()) {
                throw new CompilerException("Objective-C @IBOutlet/@IBOutletCollection/@IBInspectable field " + field + " must not be final.");
            }
            Jimple jimple = Jimple.v();
            SootMethod method = new SootMethod("$field$set_" + field.getName(), Collections.singletonList(field.getType()), VoidType.v(), 18);
            if (Types.isStruct(field.getType())) {
                Annotations.addRuntimeVisibleParameterAnnotation(method, 0, "Lorg/robovm/rt/bro/annotation/ByVal;");
            }
            sootClass.addMethod(method);
            method.setActiveBody(jimple.newBody(method));
            Body body = method.getActiveBody();
            PatchingChain<Unit> units = body.getUnits();
            Local thiz = jimple.newLocal("$this", sootClass.getType());
            Local value = jimple.newLocal("$value", field.getType());
            body.getLocals().add(thiz);
            body.getLocals().add(value);
            units.add(jimple.newIdentityStmt(thiz, jimple.newThisRef(sootClass.getType())));
            units.add(jimple.newIdentityStmt(value, jimple.newParameterRef(field.getType(), 0)));
            units.add(jimple.newAssignStmt(jimple.newInstanceFieldRef(thiz, field.makeRef()), value));
            units.add(jimple.newReturnVoidStmt());
            String propertyName = Annotations.readStringElem(annotation2, "name", field.getName());
            String setterSelectorName = "set" + StringUtils.capitalize(propertyName) + ":";
            annotation2 = new AnnotationTag(annotation2.getType(), 1);
            annotation2.addElem(new AnnotationStringElem(setterSelectorName, 's', "selector"));
            Annotations.addRuntimeVisibleAnnotation((Host)method, annotation2);
        }
    }

    private void transformMethod(Config config, Clazz clazz, SootClass sootClass, SootMethod method, Set<String> selectors, Set<String> overridables, boolean extensions) {
        block15: {
            AnnotationTag annotation2 = Annotations.getAnnotation(method, METHOD);
            if (annotation2 != null) {
                if (!(!extensions || method.isStatic() && method.isNative())) {
                    throw new CompilerException("Objective-C @Method method " + method + " in extension class must be static and native.");
                }
                this.transformObjCMethod(annotation2, sootClass, method, selectors, overridables, extensions);
                return;
            }
            annotation2 = Annotations.getAnnotation(method, IBACTION);
            if (annotation2 != null) {
                Type param2;
                if (method.isStatic() || method.isNative()) {
                    throw new CompilerException("Objective-C @IBAction method " + method + " must not be static or native.");
                }
                int paramCount = method.getParameterCount();
                Type param1 = paramCount > 0 ? method.getParameterType(0) : null;
                Type type = param2 = paramCount > 1 ? method.getParameterType(1) : null;
                if (method.getReturnType() != VoidType.v() || paramCount > 2 || param1 != null && !this.isNSObject(param1) && !this.isNSObject(param1) || param2 != null && (!this.isUIEvent(param2) || this.isNSObject(param1))) {
                    throw new CompilerException("Objective-C @IBAction method " + method + " does not have a supported signature. @IBAction methods must return void and either take no arguments, 1 argument of type NSObject, or 2 arguments of types NSObject and UIEvent.");
                }
                this.transformObjCMethod(annotation2, sootClass, method, selectors, overridables, extensions);
                return;
            }
            annotation2 = Annotations.getAnnotation(method, PROPERTY);
            if (annotation2 != null) {
                if (!(!extensions || method.isStatic() && method.isNative())) {
                    throw new CompilerException("Objective-C @Property method " + method + " in extension class must be static and native.");
                }
                this.transformObjCProperty(annotation2, "@Property", sootClass, method, selectors, overridables, extensions);
                return;
            }
            annotation2 = Annotations.getAnnotation(method, IBOUTLET);
            if (annotation2 != null) {
                if (method.isStatic()) {
                    throw new CompilerException("Objective-C @IBOutlet method " + method + " must not be static.");
                }
                this.transformObjCProperty(annotation2, "@IBOutlet", sootClass, method, selectors, overridables, extensions);
                return;
            }
            annotation2 = Annotations.getAnnotation(method, IBINSPECTABLE);
            if (annotation2 != null) {
                if (method.isStatic()) {
                    throw new CompilerException("Objective-C @IBInspectable method " + method + " must not be static.");
                }
                this.transformObjCProperty(annotation2, "@IBInspectable", sootClass, method, selectors, overridables, extensions);
                return;
            }
            annotation2 = Annotations.getAnnotation(method, IBOUTLETCOLLECTION);
            if (annotation2 != null) {
                if (method.isStatic()) {
                    throw new CompilerException("Objective-C @IBOutletCollection method " + method + " must not be static.");
                }
                if (method.getReturnType() != VoidType.v() && !this.isNSArray(method.getReturnType()) || method.getReturnType() == VoidType.v() && method.getParameterCount() == 1 && !this.isNSArray(method.getParameterType(0))) {
                    throw new CompilerException("Objective-C @IBOutletCollection method " + method + " does not have a supported signature. @IBOutletCollection getter methods must return NSArray. @IBOutletCollection setter methods must have 1 parameter of type NSArray.");
                }
                this.transformObjCProperty(annotation2, "@IBOutletCollection", sootClass, method, selectors, overridables, extensions);
                return;
            }
            if (method.isStatic() || method.isNative() || method.isAbstract() || method.isPrivate() || !this.isCustomClass(sootClass) || Annotations.hasAnnotation(method, NOT_IMPLEMENTED)) break block15;
            List<SootMethod> superMethods = this.findOverriddenMethods(sootClass, method);
            for (SootMethod superMethod : superMethods) {
                if (this.createCustomClassCallbackIfNeeded(sootClass, method, superMethod)) break;
            }
        }
    }

    private boolean createCustomClassCallbackIfNeeded(SootClass sootClass, SootMethod method, SootMethod superMethod) {
        AnnotationTag annotation2 = Annotations.getAnnotation(superMethod, METHOD);
        if (annotation2 != null) {
            this.createCallback(sootClass, method, superMethod, this.getObjCMethodSelectorName(annotation2, superMethod, false), this.getReceiverType(sootClass));
            return true;
        }
        annotation2 = Annotations.getAnnotation(superMethod, PROPERTY);
        if (annotation2 != null) {
            boolean isGetter = method.getReturnType() != VoidType.v();
            this.createCallback(sootClass, method, superMethod, this.getObjCPropertySelectorName(annotation2, superMethod, isGetter), this.getReceiverType(sootClass));
            return true;
        }
        return false;
    }

    private SootMethod findMethod(SootClass sootClass, String methodName, List<Type> parameterTypes, Type returnType, boolean includeObjC) {
        while (true) {
            try {
                SootMethod m = sootClass.getMethod(methodName, parameterTypes, returnType);
                return m;
            }
            catch (RuntimeException runtimeException) {
                boolean done = sootClass.getType().equals(this.org_robovm_objc_ObjCObject.getType());
                sootClass = sootClass.getSuperclass();
                if (!(done |= !includeObjC && sootClass.getType().equals(this.org_robovm_objc_ObjCObject.getType()))) continue;
                return null;
            }
            break;
        }
    }

    private List<SootMethod> findOverriddenMethods(SootClass sootClass, SootMethod method) {
        SootClass supercls = sootClass.getSuperclass();
        while (!supercls.getType().equals(this.org_robovm_objc_ObjCObject.getType())) {
            try {
                SootMethod m = supercls.getMethod(method.getName(), method.getParameterTypes(), method.getReturnType());
                if (this.overrides(method, m) && !Annotations.hasAnnotation(m, NOT_IMPLEMENTED)) {
                    return Collections.singletonList(m);
                }
            }
            catch (RuntimeException m) {
                // empty catch block
            }
            supercls = supercls.getSuperclass();
        }
        ArrayList<SootMethod> candidates = new ArrayList<SootMethod>();
        this.findOverriddenMethodsOnInterfaces(sootClass, method, candidates);
        return candidates;
    }

    private void findOverriddenMethodsOnInterfaces(SootClass sootClass, SootMethod method, List<SootMethod> candidates) {
        if (sootClass.isInterface()) {
            try {
                candidates.add(sootClass.getMethod(method.getName(), method.getParameterTypes(), method.getReturnType()));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        for (SootClass interfaze : sootClass.getInterfaces()) {
            this.findOverriddenMethodsOnInterfaces(interfaze, method, candidates);
        }
        if (!sootClass.isInterface() && sootClass.hasSuperclass() && !sootClass.getSuperclass().getType().equals(this.org_robovm_objc_ObjCObject.getType())) {
            this.findOverriddenMethodsOnInterfaces(sootClass.getSuperclass(), method, candidates);
        }
    }

    private SootMethod findOverridenMethodWithAnnotation(SootClass sootClass, SootMethod method, String annotationPath) {
        SootClass supercls = sootClass.getSuperclass();
        while (!supercls.getType().equals(this.org_robovm_objc_ObjCObject.getType())) {
            try {
                SootMethod m = supercls.getMethod(method.getName(), method.getParameterTypes(), method.getReturnType());
                AnnotationTag annotation2 = Annotations.getAnnotation(m, annotationPath);
                if (annotation2 != null) {
                    return m;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            supercls = supercls.getSuperclass();
        }
        return null;
    }

    private boolean overrides(SootMethod subMethod, SootMethod superMethod) {
        if (!superMethod.isPrivate() && !superMethod.isStatic()) {
            if (!superMethod.isPublic() && !superMethod.isProtected()) {
                String package1 = superMethod.getDeclaringClass().getPackageName();
                String package2 = subMethod.getDeclaringClass().getPackageName();
                return package1.equals(package2);
            }
            return true;
        }
        return false;
    }

    private void transformObjCMethod(AnnotationTag annotation2, SootClass sootClass, SootMethod method, Set<String> selectors, Set<String> overridables, boolean extensions) {
        String selectorName = this.getObjCMethodSelectorName(annotation2, method, extensions);
        if (!extensions && this.isCustomClass(sootClass)) {
            this.createCallback(sootClass, method, method, selectorName, this.getReceiverType(sootClass));
        }
        if (method.isNative()) {
            if (this.checkOverridable(overridables, selectorName, method)) {
                overridables.add(selectorName);
            }
            selectors.add(selectorName);
            this.createBridge(sootClass, method, selectorName, false, extensions);
        }
    }

    private Type getReceiverType(SootClass sootClass) {
        RefType receiverType = ObjCProtocolProxyPlugin.isObjCProxy(sootClass) ? sootClass.getInterfaces().getFirst().getType() : sootClass.getType();
        return receiverType;
    }

    private void transformObjCProperty(AnnotationTag annotation2, String javaAnnotation, SootClass sootClass, SootMethod method, Set<String> selectors, Set<String> overridables, boolean extensions) {
        int setterParamCount;
        int getterParamCount = extensions ? 1 : 0;
        int n = setterParamCount = extensions ? 2 : 1;
        if (method.getReturnType() != VoidType.v() && method.getParameterCount() != getterParamCount || method.getReturnType() == VoidType.v() && method.getParameterCount() != setterParamCount) {
            if (!extensions) {
                throw new CompilerException("Objective-C " + this.getAnnotationName(annotation2) + " method " + method + " does not have a supported signature. " + this.getAnnotationName(annotation2) + " getter methods must take 0 arguments and must not return void. " + this.getAnnotationName(annotation2) + " setter methods must take 1 argument and return void.");
            }
            throw new CompilerException("Objective-C " + this.getAnnotationName(annotation2) + " method " + method + " in extension class does not have a supported signature. " + this.getAnnotationName(annotation2) + " getter methods in extension classes must take 1 argument (the 'this' reference) and must not return void. " + this.getAnnotationName(annotation2) + " setter methods in extension classes must take 2 arguments (first is the 'this' reference) and return void.");
        }
        boolean isGetter = method.getReturnType() != VoidType.v();
        String selectorName = this.getObjCPropertySelectorName(annotation2, method, isGetter);
        if (!extensions && this.isCustomClass(sootClass)) {
            this.createCallback(sootClass, method, method, selectorName, this.getReceiverType(sootClass));
        }
        if (method.isNative()) {
            if (this.checkOverridable(overridables, selectorName, method)) {
                overridables.add(selectorName);
            }
            selectors.add(selectorName);
            boolean strongRefSetter = !isGetter && Annotations.readBooleanElem(annotation2, "strongRef", false);
            this.createBridge(sootClass, method, selectorName, strongRefSetter, extensions);
        }
    }

    private String getAnnotationName(AnnotationTag annotation2) {
        String n = annotation2.getType();
        n = n.substring(1, n.length() - 1);
        return "@" + n.substring(n.lastIndexOf(47) + 1);
    }

    private String getObjCMethodSelectorName(AnnotationTag annotation2, SootMethod method, boolean extensions) {
        String selectorName = Annotations.readStringElem(annotation2, "selector", "").trim();
        if (selectorName.length() == 0) {
            int argCount = method.getParameterCount();
            if (IBACTION.equals(annotation2.getType()) && argCount == 2) {
                selectorName = method.getName() + ":withEvent:";
            } else {
                int i;
                StringBuilder sb = new StringBuilder(method.getName());
                int n = i = extensions ? 1 : 0;
                while (i < argCount) {
                    sb.append(':');
                    ++i;
                }
                selectorName = sb.toString();
            }
        }
        return selectorName;
    }

    private String getObjCPropertySelectorName(AnnotationTag annotation2, SootMethod method, boolean isGetter) {
        String selectorName = Annotations.readStringElem(annotation2, "selector", "").trim();
        if (selectorName.length() == 0) {
            String methodName = method.getName();
            if (!(isGetter && methodName.startsWith("get") && methodName.length() > 3 || isGetter && methodName.startsWith("is") && methodName.length() > 2 || !isGetter && methodName.startsWith("set") && methodName.length() > 3)) {
                throw new CompilerException("Invalid Objective-C " + this.getAnnotationName(annotation2) + " method name " + method + ". " + this.getAnnotationName(annotation2) + " methods without an explicit selector value must follow the Java beans property method naming convention.");
            }
            selectorName = methodName;
            if (isGetter) {
                selectorName = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
                selectorName = selectorName.substring(0, 1).toLowerCase() + selectorName.substring(1);
            } else {
                selectorName = selectorName + ":";
            }
        }
        return selectorName;
    }

    private void createCallback(SootClass sootClass, SootMethod method, SootMethod annotatedMethod, String selectorName, Type receiverType) {
        Jimple j = Jimple.v();
        SootMethod callbackMethod = this.getCallbackMethod(selectorName, method, annotatedMethod, receiverType);
        sootClass.addMethod(callbackMethod);
        ObjCMemberPlugin.addCallbackAnnotation(callbackMethod);
        ObjCMemberPlugin.addBindSelectorAnnotation(callbackMethod, selectorName);
        if (!Annotations.hasAnnotation(annotatedMethod, TYPE_ENCODING) && (this.isCustomClass(sootClass) || ObjCProtocolProxyPlugin.isObjCProxy(sootClass))) {
            String encoding = this.generateTypeEncoding(callbackMethod);
            try {
                ObjCMemberPlugin.addTypeEncodingAnnotation(callbackMethod, encoding);
            }
            catch (IllegalArgumentException e) {
                throw new CompilerException("Failed to determine method type encoding for method " + method + ": " + e.getMessage());
            }
        }
        JimpleBody body = j.newBody(callbackMethod);
        callbackMethod.setActiveBody(body);
        PatchingChain<Unit> units = body.getUnits();
        Local thiz = null;
        if (!method.isStatic()) {
            thiz = j.newLocal("$this", receiverType);
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newParameterRef(receiverType, 0)));
        }
        LinkedList<Local> args = new LinkedList<Local>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Type t = method.getParameterType(i);
            Local p = j.newLocal("$p" + i, t);
            body.getLocals().add(p);
            units.add(j.newIdentityStmt(p, j.newParameterRef(t, i + 2)));
            args.add(p);
        }
        Local ret = null;
        if (method.getReturnType() != VoidType.v()) {
            ret = j.newLocal("$ret", method.getReturnType());
            body.getLocals().add(ret);
        }
        SootMethodRef targetMethod = method.makeRef();
        if (((RefType)receiverType).getSootClass().isInterface()) {
            List parameterTypes = method.getParameterTypes();
            targetMethod = Scene.v().makeMethodRef(((RefType)receiverType).getSootClass(), method.getName(), parameterTypes, method.getReturnType(), false);
        }
        StaticInvokeExpr expr = method.isStatic() ? j.newStaticInvokeExpr(targetMethod, args) : (((RefType)receiverType).getSootClass().isInterface() ? j.newInterfaceInvokeExpr(thiz, targetMethod, args) : j.newVirtualInvokeExpr(thiz, targetMethod, args));
        units.add(ret == null ? j.newInvokeStmt(expr) : j.newAssignStmt(ret, expr));
        if (ret != null) {
            units.add(j.newReturnStmt(ret));
        } else {
            units.add(j.newReturnVoidStmt());
        }
    }

    private String generateTypeEncoding(SootMethod method) {
        TypeEncoder encoder = new TypeEncoder();
        return encoder.encode(method, !this.config.getArch().is32Bit());
    }

    private SootMethod findStrongRefGetter(SootClass sootClass, SootMethod method, boolean extensions) {
        String setterPropName;
        AnnotationTag annotation2 = Annotations.getAnnotation(method, PROPERTY);
        if (annotation2 == null) {
            annotation2 = Annotations.getAnnotation(method, IBOUTLET);
        }
        if (annotation2 == null) {
            annotation2 = Annotations.getAnnotation(method, IBINSPECTABLE);
        }
        if (annotation2 == null) {
            annotation2 = Annotations.getAnnotation(method, IBOUTLETCOLLECTION);
        }
        if ((setterPropName = Annotations.readStringElem(annotation2, "name", "").trim()).length() == 0) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() == 3) {
                throw new CompilerException("Failed to determine the property name from the @Property method " + method + ". Either specify the name explicitly in the @Property annotation or rename the method according to the Java beans property setter method naming convention.");
            }
            setterPropName = methodName.substring(3);
            setterPropName = setterPropName.substring(0, 1).toLowerCase() + setterPropName.substring(1);
        }
        int paramCount = extensions ? 1 : 0;
        Type propType = method.getParameterType(extensions ? 1 : 0);
        for (SootMethod m : sootClass.getMethods()) {
            AnnotationTag propertyAnno;
            if (m == method || method.isStatic() != m.isStatic() || m.getParameterCount() != paramCount || !m.getReturnType().equals(propType) || (propertyAnno = Annotations.getAnnotation(m, PROPERTY)) == null) continue;
            String getterPropName = Annotations.readStringElem(propertyAnno, "name", "").trim();
            if (getterPropName.length() == 0) {
                String methodName = m.getName();
                if (!methodName.startsWith("get") || methodName.length() == 3) continue;
                getterPropName = methodName.substring(3);
                getterPropName = getterPropName.substring(0, 1).toLowerCase() + getterPropName.substring(1);
            }
            if (!setterPropName.equals(getterPropName)) continue;
            return m;
        }
        throw new CompilerException("Failed to determine the getter method corresponding to the strong ref @Property setter method " + method + ". The getter must either specify the name explicitly in the @Property annotation or be named according to the Java beans property getter method naming convention.");
    }

    private SootMethodRef getGenericMsgSendReplacementMethod(SootMethod method) {
        MarshalerLookup.MarshalerMethod param0MarshalerMethod;
        if (method.getParameterCount() == 2) {
            MarshalerLookup.MarshalerMethod param0MarshalerMethod2;
            if (this.isNSObject(method.getParameterType(0)) && this.isSelector(method.getParameterType(1)) && !Annotations.hasAnnotation(method, "Lorg/robovm/rt/bro/annotation/Marshaler;") && this.isNSObject$Marshaler_toNative((param0MarshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 0))).getMethod())) {
                MarshalerLookup.MarshalerMethod retMarshalerMethod;
                List<Type> paramTypes = Arrays.asList(this.org_robovm_apple_foundation_NSObject.getType(), this.org_robovm_objc_Selector.getType());
                if (method.getReturnType() == VoidType.v() || method.getReturnType() instanceof PrimType) {
                    String prefix = this.getPrimitiveReturnTypeModifier(method);
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, prefix + "_objc_msgSend", paramTypes, method.getReturnType(), true);
                }
                if (this.isNSObject(method.getReturnType())) {
                    MarshalerLookup.MarshalerMethod retMarshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
                    if (this.isNSObject$Marshaler_toObject(retMarshalerMethod2.getMethod())) {
                        return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "object_objc_msgSend", paramTypes, this.org_robovm_apple_foundation_NSObject.getType(), true);
                    }
                } else if (method.getReturnType().equals(this.java_lang_String.getType()) && this.isNSString$AsStringMarshaler_toObject((retMarshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method))).getMethod())) {
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "string_objc_msgSend", paramTypes, method.getReturnType(), true);
                }
            }
        } else if (method.getParameterCount() == 3 && method.getReturnType() == VoidType.v() && this.isNSObject(method.getParameterType(0)) && this.isSelector(method.getParameterType(1)) && !Annotations.hasParameterAnnotation(method, 1, "Lorg/robovm/rt/bro/annotation/Marshaler;") && this.isNSObject$Marshaler_toNative((param0MarshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 0))).getMethod())) {
            MarshalerLookup.MarshalerMethod param2MarshalerMethod;
            List<Type> paramTypes = Arrays.asList(this.org_robovm_apple_foundation_NSObject.getType(), this.org_robovm_objc_Selector.getType(), method.getParameterType(2));
            if (method.getParameterType(2) instanceof PrimType) {
                String suffix = this.getPrimitiveParameterTypeModifier(method, 2);
                return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSend_" + suffix, paramTypes, method.getReturnType(), true);
            }
            if (this.isNSObject(method.getParameterType(2))) {
                MarshalerLookup.MarshalerMethod param2MarshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 2));
                if (this.isNSObject$Marshaler_toNative(param2MarshalerMethod2.getMethod())) {
                    paramTypes = Arrays.asList(this.org_robovm_apple_foundation_NSObject.getType(), this.org_robovm_objc_Selector.getType(), this.org_robovm_apple_foundation_NSObject.getType());
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSend_object", paramTypes, method.getReturnType(), true);
                }
            } else if (method.getParameterType(2).equals(this.java_lang_String.getType()) && this.isNSString$AsStringMarshaler_toNative((param2MarshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 2))).getMethod())) {
                return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSend_string", paramTypes, method.getReturnType(), true);
            }
        }
        return method.makeRef();
    }

    private SootMethodRef getGenericMsgSendSuperReplacementMethod(SootMethod method) {
        if (method.getParameterCount() == 2) {
            if (method.getParameterType(0).equals(this.org_robovm_objc_ObjCSuper.getType()) && this.isSelector(method.getParameterType(1)) && !Annotations.hasAnnotation(method, "Lorg/robovm/rt/bro/annotation/Marshaler;")) {
                MarshalerLookup.MarshalerMethod retMarshalerMethod;
                if (method.getReturnType() == VoidType.v() || method.getReturnType() instanceof PrimType) {
                    String prefix = this.getPrimitiveReturnTypeModifier(method);
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, prefix + "_objc_msgSendSuper", method.getParameterTypes(), method.getReturnType(), true);
                }
                if (this.isNSObject(method.getReturnType())) {
                    MarshalerLookup.MarshalerMethod retMarshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
                    if (this.isNSObject$Marshaler_toObject(retMarshalerMethod2.getMethod())) {
                        return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "object_objc_msgSendSuper", method.getParameterTypes(), this.org_robovm_apple_foundation_NSObject.getType(), true);
                    }
                } else if (method.getReturnType().equals(this.java_lang_String.getType()) && this.isNSString$AsStringMarshaler_toObject((retMarshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method))).getMethod())) {
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "string_objc_msgSendSuper", method.getParameterTypes(), method.getReturnType(), true);
                }
            }
        } else if (method.getParameterCount() == 3 && method.getReturnType() == VoidType.v() && method.getParameterType(0).equals(this.org_robovm_objc_ObjCSuper.getType()) && this.isSelector(method.getParameterType(1)) && !Annotations.hasParameterAnnotation(method, 1, "Lorg/robovm/rt/bro/annotation/Marshaler;")) {
            MarshalerLookup.MarshalerMethod param2MarshalerMethod;
            if (method.getParameterType(2) instanceof PrimType) {
                String suffix = this.getPrimitiveParameterTypeModifier(method, 2);
                return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSendSuper_" + suffix, method.getParameterTypes(), method.getReturnType(), true);
            }
            if (this.isNSObject(method.getParameterType(2))) {
                MarshalerLookup.MarshalerMethod param2MarshalerMethod2 = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 2));
                if (this.isNSObject$Marshaler_toNative(param2MarshalerMethod2.getMethod())) {
                    List<Type> paramTypes = Arrays.asList(this.org_robovm_objc_ObjCSuper.getType(), this.org_robovm_objc_Selector.getType(), this.org_robovm_apple_foundation_NSObject.getType());
                    return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSendSuper_object", paramTypes, method.getReturnType(), true);
                }
            } else if (method.getParameterType(2).equals(this.java_lang_String.getType()) && this.isNSString$AsStringMarshaler_toNative((param2MarshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, 2))).getMethod())) {
                return Scene.v().makeMethodRef(this.org_robovm_objc_$M, "objc_msgSendSuper_string", method.getParameterTypes(), method.getReturnType(), true);
            }
        }
        return method.makeRef();
    }

    private String getPrimitiveReturnTypeModifier(SootMethod method) {
        String mod = method.getReturnType().toString();
        if (method.getReturnType() == LongType.v() && Annotations.hasPointerAnnotation(method)) {
            mod = "ptr";
        } else if ((method.getReturnType() == FloatType.v() || method.getReturnType() == DoubleType.v()) && Annotations.hasMachineSizedFloatAnnotation(method)) {
            mod = "m" + mod;
        } else if (method.getReturnType() == LongType.v() && Annotations.hasMachineSizedSIntAnnotation(method)) {
            mod = "msint";
        } else if (method.getReturnType() == LongType.v() && Annotations.hasMachineSizedUIntAnnotation(method)) {
            mod = "muint";
        }
        return mod;
    }

    private String getPrimitiveParameterTypeModifier(SootMethod method, int paramIdx) {
        String mod = method.getParameterType(paramIdx).toString();
        if (method.getParameterType(paramIdx) == LongType.v() && Annotations.hasPointerAnnotation(method, paramIdx)) {
            mod = "ptr";
        } else if ((method.getParameterType(paramIdx) == FloatType.v() || method.getParameterType(paramIdx) == DoubleType.v()) && Annotations.hasMachineSizedFloatAnnotation(method, paramIdx)) {
            mod = "m" + mod;
        } else if (method.getParameterType(paramIdx) == LongType.v() && Annotations.hasMachineSizedSIntAnnotation(method, paramIdx)) {
            mod = "msint";
        } else if (method.getParameterType(paramIdx) == LongType.v() && Annotations.hasMachineSizedUIntAnnotation(method, paramIdx)) {
            mod = "muint";
        }
        return mod;
    }

    private void createBridge(SootClass sootClass, SootMethod method, String selectorName, boolean strongRefSetter, boolean extensions) {
        Stmt invokeMsgSendStmt;
        Type propType;
        int i;
        Jimple j = Jimple.v();
        boolean usingGenericInstanceMethod = false;
        SootMethod msgSendMethod = this.getMsgSendMethod(selectorName, method, extensions);
        sootClass.addMethod(msgSendMethod);
        ObjCMemberPlugin.addBridgeAnnotation(msgSendMethod);
        SootMethodRef msgSendMethodRef = this.getGenericMsgSendReplacementMethod(msgSendMethod);
        if (!msgSendMethodRef.declaringClass().getType().equals(msgSendMethod.getDeclaringClass().getType())) {
            sootClass.removeMethod(msgSendMethod);
            if (!method.isStatic()) {
                msgSendMethodRef = Scene.v().makeMethodRef(msgSendMethodRef.declaringClass(), msgSendMethodRef.name() + "_instance", msgSendMethodRef.parameterTypes(), msgSendMethodRef.returnType(), true);
                usingGenericInstanceMethod = true;
            }
        }
        SootMethodRef msgSendSuperMethodRef = null;
        if (!(usingGenericInstanceMethod || extensions || method.isStatic())) {
            SootMethod msgSendSuperMethod = this.getMsgSendSuperMethod(selectorName, method);
            sootClass.addMethod(msgSendSuperMethod);
            ObjCMemberPlugin.addBridgeAnnotation(msgSendSuperMethod);
            msgSendSuperMethodRef = this.getGenericMsgSendSuperReplacementMethod(msgSendSuperMethod);
            if (!msgSendSuperMethodRef.declaringClass().getType().equals(msgSendSuperMethod.getDeclaringClass().getType())) {
                sootClass.removeMethod(msgSendSuperMethod);
            }
        }
        method.setModifiers(method.getModifiers() & 0xFFFFFEFF);
        JimpleBody body = j.newBody(method);
        method.setActiveBody(body);
        PatchingChain<Unit> units = body.getUnits();
        Local thiz = null;
        if (extensions) {
            thiz = j.newLocal("$this", method.getParameterType(0));
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newParameterRef(method.getParameterType(0), 0)));
        } else if (!method.isStatic()) {
            thiz = j.newLocal("$this", sootClass.getType());
            body.getLocals().add(thiz);
            units.add(j.newIdentityStmt(thiz, j.newThisRef(sootClass.getType())));
        }
        LinkedList<Local> args = new LinkedList<Local>();
        int n = i = extensions ? 1 : 0;
        while (i < method.getParameterCount()) {
            Type t = method.getParameterType(i);
            Local p = j.newLocal("$p" + i, t);
            body.getLocals().add(p);
            units.add(j.newIdentityStmt(p, j.newParameterRef(t, i)));
            args.add(p);
            ++i;
        }
        Local objCClass = null;
        if (!extensions && method.isStatic()) {
            objCClass = j.newLocal("$objCClass", this.org_robovm_objc_ObjCClass.getType());
            body.getLocals().add(objCClass);
            units.add(j.newAssignStmt(objCClass, j.newStaticFieldRef(Scene.v().makeFieldRef(sootClass, "$objCClass", this.org_robovm_objc_ObjCClass.getType(), true))));
        }
        if (strongRefSetter && (propType = method.getParameterType(extensions ? 1 : 0)) instanceof RefLikeType) {
            SootMethodRef getter = this.findStrongRefGetter(sootClass, method, extensions).makeRef();
            Local before = j.newLocal("$before", propType);
            body.getLocals().add(before);
            units.add(j.newAssignStmt(before, extensions ? j.newStaticInvokeExpr(getter, thiz) : (objCClass != null ? j.newStaticInvokeExpr(getter) : j.newVirtualInvokeExpr(thiz, getter))));
            Value after = (Value)args.get(0);
            if (extensions) {
                units.add(j.newInvokeStmt(j.newStaticInvokeExpr(this.org_robovm_objc_ObjCExtensions_updateStrongRef, Arrays.asList(thiz, before, after))));
            } else {
                units.add(j.newInvokeStmt(j.newVirtualInvokeExpr(objCClass != null ? objCClass : thiz, this.org_robovm_objc_ObjCObject_updateStrongRef, before, after)));
            }
        }
        Local sel = j.newLocal("$sel", this.org_robovm_objc_Selector.getType());
        body.getLocals().add(sel);
        units.add(j.newAssignStmt(sel, j.newStaticFieldRef(Scene.v().makeFieldRef(sootClass, this.getSelectorFieldName(selectorName), this.org_robovm_objc_Selector.getType(), true))));
        args.addFirst(sel);
        Local customClass = null;
        if (!(usingGenericInstanceMethod || extensions || Modifier.isFinal(sootClass.getModifiers()) || method.isStatic())) {
            customClass = j.newLocal("$customClass", BooleanType.v());
            body.getLocals().add(customClass);
            units.add(j.newAssignStmt(customClass, j.newInstanceFieldRef(thiz, this.org_robovm_objc_ObjCObject_customClass)));
        }
        Local ret = null;
        if (method.getReturnType() != VoidType.v()) {
            ret = j.newLocal("$ret", msgSendMethodRef.returnType());
            body.getLocals().add(ret);
        }
        Local castRet = null;
        if (!msgSendMethodRef.returnType().equals(method.getReturnType())) {
            castRet = j.newLocal("$castRet", method.getReturnType());
            body.getLocals().add(castRet);
        }
        StaticInvokeExpr invokeMsgSendExpr = j.newStaticInvokeExpr(msgSendMethodRef, ObjCMemberPlugin.l(thiz != null ? thiz : objCClass, args));
        Stmt stmt = invokeMsgSendStmt = ret == null ? j.newInvokeStmt(invokeMsgSendExpr) : j.newAssignStmt(ret, invokeMsgSendExpr);
        if (customClass != null) {
            units.add(j.newIfStmt((Value)j.newEqExpr(customClass, IntConstant.v(0)), invokeMsgSendStmt));
            Local zuper = j.newLocal("$super", this.org_robovm_objc_ObjCSuper.getType());
            body.getLocals().add(zuper);
            units.add(j.newAssignStmt(zuper, j.newVirtualInvokeExpr(body.getThisLocal(), this.org_robovm_objc_ObjCObject_getSuper)));
            StaticInvokeExpr invokeMsgSendSuperExpr = j.newStaticInvokeExpr(msgSendSuperMethodRef, ObjCMemberPlugin.l(zuper, args));
            units.add(ret == null ? j.newInvokeStmt(invokeMsgSendSuperExpr) : j.newAssignStmt(ret, invokeMsgSendSuperExpr));
            if (ret != null) {
                if (castRet != null) {
                    units.add(j.newAssignStmt(castRet, j.newCastExpr(ret, castRet.getType())));
                    units.add(j.newReturnStmt(castRet));
                } else {
                    units.add(j.newReturnStmt(ret));
                }
            } else {
                units.add(j.newReturnVoidStmt());
            }
        }
        units.add(invokeMsgSendStmt);
        if (ret != null) {
            if (castRet != null) {
                units.add(j.newAssignStmt(castRet, j.newCastExpr(ret, castRet.getType())));
                units.add(j.newReturnStmt(castRet));
            } else {
                units.add(j.newReturnStmt(ret));
            }
        } else {
            units.add(j.newReturnVoidStmt());
        }
    }

    static void addBridgeAnnotation(SootMethod method) {
        Annotations.addRuntimeVisibleAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Bridge;");
    }

    static void addCallbackAnnotation(SootMethod method) {
        Annotations.addRuntimeVisibleAnnotation((Host)method, "Lorg/robovm/rt/bro/annotation/Callback;");
    }

    static void addBindSelectorAnnotation(SootMethod method, String selectorName) {
        AnnotationTag annotationTag = new AnnotationTag(BIND_SELECTOR, 1);
        annotationTag.addElem(new AnnotationStringElem(selectorName, 's', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }

    static void addNotImplementedAnnotation(SootMethod method, String selectorName) {
        AnnotationTag annotationTag = new AnnotationTag(NOT_IMPLEMENTED, 1);
        annotationTag.addElem(new AnnotationStringElem(selectorName, 's', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }

    static void addTypeEncodingAnnotation(SootMethod method, String encoding) {
        AnnotationTag annotationTag = new AnnotationTag(TYPE_ENCODING, 1);
        annotationTag.addElem(new AnnotationStringElem(encoding, 's', "value"));
        Annotations.addRuntimeVisibleAnnotation((Host)method, annotationTag);
    }
}

