/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.FullRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;

public class FieldRWTagger
extends BodyTransformer {
    public int numRWs = 0;
    public int numWRs = 0;
    public int numRRs = 0;
    public int numWWs = 0;
    public int numNatives = 0;
    public Date startTime = null;
    boolean optionDontTag = false;
    boolean optionNaive = false;
    private CallGraph cg;

    public FieldRWTagger(Singletons.Global g) {
    }

    public static FieldRWTagger v() {
        return G.v().soot_jimple_toolkits_pointer_FieldRWTagger();
    }

    protected void initializationStuff(String phaseName) {
        if (G.v().Union_factory == null) {
            G.v().Union_factory = new UnionFactory(){

                @Override
                public Union newUnion() {
                    return FullObjectSet.v();
                }
            };
        }
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        this.cg = Scene.v().getCallGraph();
    }

    protected Object keyFor(Stmt s) {
        if (s.containsInvokeExpr()) {
            if (this.optionNaive) {
                throw new RuntimeException("shouldn't get here");
            }
            Iterator<Edge> it = this.cg.edgesOutOf(s);
            if (!it.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Edge> ret = new ArrayList<Edge>();
            while (it.hasNext()) {
                ret.add(it.next());
            }
            return ret;
        }
        return s;
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        this.initializationStuff(phaseName);
        SideEffectAnalysis sea = new SideEffectAnalysis(DumbPointerAnalysis.v(), Scene.v().getCallGraph());
        sea.findNTRWSets(body.getMethod());
        HashMap<Object, RWSet> stmtToReadSet = new HashMap<Object, RWSet>();
        HashMap<Object, RWSet> stmtToWriteSet = new HashMap<Object, RWSet>();
        UniqueRWSets sets = new UniqueRWSets();
        this.optionDontTag = PhaseOptions.getBoolean(options, "dont-tag");
        boolean justDoTotallyConservativeThing = body.getMethod().getName().equals("<clinit>");
        for (Stmt stmt : body.getUnits()) {
            if (!stmt.containsInvokeExpr()) continue;
            if (justDoTotallyConservativeThing) {
                stmtToReadSet.put(stmt, sets.getUnique(new FullRWSet()));
                stmtToWriteSet.put(stmt, sets.getUnique(new FullRWSet()));
                continue;
            }
            Object key = this.keyFor(stmt);
            if (stmtToReadSet.containsKey(key)) continue;
            stmtToReadSet.put(key, sets.getUnique(sea.readSet(body.getMethod(), stmt)));
            stmtToWriteSet.put(key, sets.getUnique(sea.writeSet(body.getMethod(), stmt)));
        }
    }

    protected class UniqueRWSets {
        protected ArrayList<RWSet> l = new ArrayList();

        protected UniqueRWSets() {
        }

        RWSet getUnique(RWSet s) {
            if (s == null) {
                return s;
            }
            for (RWSet ret : this.l) {
                if (!ret.isEquivTo(s)) continue;
                return ret;
            }
            this.l.add(s);
            return s;
        }

        Iterator<RWSet> iterator() {
            return this.l.iterator();
        }

        short indexOf(RWSet s) {
            short i = 0;
            for (RWSet ret : this.l) {
                if (ret.isEquivTo(s)) {
                    return i;
                }
                i = (short)(i + 1);
            }
            return -1;
        }
    }
}

