/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import soot.EquivalentValue;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.Constant;
import soot.jimple.DivExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.RemExpr;
import soot.jimple.UnopExpr;

public class SootFilter {
    public static EquivalentValue equiVal(Value val) {
        if (val == null) {
            return null;
        }
        return new EquivalentValue(val);
    }

    public static Value rhs(Unit unit) {
        if (unit instanceof AssignStmt) {
            return ((AssignStmt)unit).getRightOp();
        }
        return null;
    }

    public static Value binop(Value val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BinopExpr) {
            return val;
        }
        return null;
    }

    public static Value binopRhs(Unit unit) {
        return SootFilter.binop(SootFilter.rhs(unit));
    }

    public static Value concreteRef(Value val) {
        if (val == null) {
            return null;
        }
        if (val instanceof ConcreteRef) {
            return val;
        }
        return null;
    }

    public static Value noExceptionThrowing(Value val) {
        if (val == null) {
            return null;
        }
        if (!SootFilter.throwsException(val)) {
            return val;
        }
        return null;
    }

    public static Value noExceptionThrowingRhs(Unit unit) {
        return SootFilter.noExceptionThrowing(SootFilter.rhs(unit));
    }

    public static Value noInvokeRhs(Unit unit) {
        return SootFilter.noInvoke(SootFilter.rhs(unit));
    }

    public static Value noInvoke(Value val) {
        if (val == null || SootFilter.isInvoke(val)) {
            return null;
        }
        return val;
    }

    public static boolean isInvoke(Value val) {
        return (val = SootFilter.getEquivalentValueRoot(val)) instanceof InvokeExpr;
    }

    public static Value local(Value val) {
        if (val != null && SootFilter.isLocal(val)) {
            return val;
        }
        return null;
    }

    public static Value noLocal(Value val) {
        if (val != null && !SootFilter.isLocal(val)) {
            return val;
        }
        return null;
    }

    public static boolean isLocal(Value val) {
        return SootFilter.getEquivalentValueRoot(val) instanceof Local;
    }

    public static Value getEquivalentValueRoot(Value val) {
        if (val == null) {
            return null;
        }
        while (val instanceof EquivalentValue) {
            val = ((EquivalentValue)val).getValue();
        }
        return val;
    }

    public static boolean throwsException(Value val) {
        if ((val = SootFilter.getEquivalentValueRoot(val)) instanceof BinopExpr || val instanceof UnopExpr || val instanceof Local || val instanceof Constant) {
            return val instanceof DivExpr || val instanceof RemExpr || val instanceof LengthExpr;
        }
        return true;
    }
}

