/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.IntegerType;
import soot.ShortType;
import soot.Type;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.BytecodeHierarchy;
import soot.jimple.toolkits.typing.fast.EmptyList;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.SingletonList;
import soot.jimple.toolkits.typing.fast.TypeResolver;

public class AugHierarchy
implements IHierarchy {
    @Override
    public Collection<Type> lcas(Type a, Type b) {
        return AugHierarchy.lcas_(a, b);
    }

    public static Collection<Type> lcas_(Type a, Type b) {
        if (TypeResolver.typesEqual(a, b)) {
            return new SingletonList<Type>(a);
        }
        if (a instanceof BottomType) {
            return new SingletonList<Type>(b);
        }
        if (b instanceof BottomType) {
            return new SingletonList<Type>(a);
        }
        if (a instanceof IntegerType && b instanceof IntegerType) {
            if (a instanceof Integer1Type) {
                return new SingletonList<Type>(b);
            }
            if (b instanceof Integer1Type) {
                return new SingletonList<Type>(a);
            }
            if (a instanceof BooleanType || b instanceof BooleanType) {
                return new EmptyList<Type>();
            }
            if (a instanceof ByteType && b instanceof Integer32767Type || b instanceof ByteType && a instanceof Integer32767Type) {
                return new SingletonList<Type>(ShortType.v());
            }
            if (a instanceof CharType && (b instanceof ShortType || b instanceof ByteType) || b instanceof CharType && (a instanceof ShortType || a instanceof ByteType)) {
                return new SingletonList<Type>(IntType.v());
            }
            if (AugHierarchy.ancestor_(a, b)) {
                return new SingletonList<Type>(a);
            }
            return new SingletonList<Type>(b);
        }
        if (a instanceof IntegerType || b instanceof IntegerType) {
            return new EmptyList<Type>();
        }
        return BytecodeHierarchy.lcas_(a, b);
    }

    @Override
    public boolean ancestor(Type ancestor, Type child) {
        return AugHierarchy.ancestor_(ancestor, child);
    }

    public static boolean ancestor_(Type ancestor, Type child) {
        if (TypeResolver.typesEqual(ancestor, child)) {
            return true;
        }
        if (ancestor instanceof Integer1Type) {
            return child instanceof BottomType;
        }
        if (ancestor instanceof BooleanType) {
            return child instanceof BottomType || child instanceof Integer1Type;
        }
        if (ancestor instanceof Integer127Type) {
            return child instanceof BottomType || child instanceof Integer1Type;
        }
        if (ancestor instanceof ByteType || ancestor instanceof Integer32767Type) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type;
        }
        if (ancestor instanceof CharType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type;
        }
        if (ancestor instanceof ShortType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type || child instanceof ByteType;
        }
        if (ancestor instanceof IntType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type || child instanceof ByteType || child instanceof CharType || child instanceof ShortType;
        }
        if (child instanceof IntegerType) {
            return false;
        }
        return BytecodeHierarchy.ancestor_(ancestor, child);
    }
}

