/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LocalVariable;
import soot.PatchingChain;
import soot.ShortType;
import soot.Singletons;
import soot.Type;
import soot.Unit;
import soot.ValueBox;
import soot.coffi.Util;
import soot.jimple.GroupIntPair;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FastColorer;
import soot.toolkits.scalar.RoboVmLiveSlotLocals;

public class RoboVmLocalPacker
extends BodyTransformer {
    public RoboVmLocalPacker(Singletons.Global g) {
    }

    public static RoboVmLocalPacker v() {
        return G.v().soot_toolkits_scalar_RoboVmLocalPacker();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] RoboVm Packing locals...");
        }
        if (!body.getLocalVariables().isEmpty()) {
            this.promoteIntTypes(body);
        }
        HashMap<Local, Local> replacements = new HashMap<Local, Local>();
        this.mergeVariables(body, replacements);
        if (!replacements.isEmpty()) {
            for (Unit s : body.getUnits()) {
                Local l;
                Local r;
                for (ValueBox box : s.getUseBoxes()) {
                    if (!(box.getValue() instanceof Local) || (r = (Local)replacements.get(l = (Local)box.getValue())) == null) continue;
                    box.setValue(r);
                }
                for (ValueBox box : s.getDefBoxes()) {
                    if (!(box.getValue() instanceof Local) || (r = (Local)replacements.get(l = (Local)box.getValue())) == null) continue;
                    box.setValue(r);
                }
            }
            ArrayList<Local> oldLocals = new ArrayList<Local>(body.getLocals());
            body.getLocals().clear();
            for (Local l : oldLocals) {
                if (replacements.containsKey(l)) continue;
                body.getLocals().add(l);
            }
        }
    }

    private void promoteIntTypes(Body body) {
        PatchingChain<Unit> units = body.getUnits();
        RoboVmLiveSlotLocals liveSlotLocals = new RoboVmLiveSlotLocals(new ExceptionalUnitGraph(body));
        HashMap<Integer, Unit> paramDefinitions = new HashMap<Integer, Unit>();
        for (Unit s : units) {
            Local l;
            IdentityStmt is;
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ParameterRef) || !((is = (IdentityStmt)s).getLeftOpBox().getValue() instanceof Local) || (l = (Local)is.getLeftOpBox().getValue()).getIndex() < 0) continue;
            paramDefinitions.put(l.getIndex(), s);
        }
        for (LocalVariable v : body.getLocalVariables()) {
            Unit endUnit;
            int varSizeBits;
            if (v.getName().contains("$") || (varSizeBits = this.getVariableSize(v.getDescriptor())) < 0) continue;
            Unit startUnit = (Unit)paramDefinitions.get(v.getIndex());
            if (startUnit == null) {
                startUnit = v.getStartUnit();
            }
            if ((endUnit = v.getEndUnit()) != null) {
                if (endUnit != startUnit) {
                    endUnit = units.getPredOf(endUnit);
                }
            } else {
                endUnit = (Unit)units.getLast();
            }
            Iterator<Unit> it = units.iterator(startUnit, endUnit);
            while (it.hasNext()) {
                Local varLocal;
                Unit u = it.next();
                Map<Integer, Local> unitLocals = liveSlotLocals.getLocalsBeforUnit(u);
                Local local = varLocal = unitLocals != null ? unitLocals.get(v.getIndex()) : null;
                if (varLocal != null) {
                    int localSizeBits = this.getVariableSize(varLocal.getType());
                    if (localSizeBits < 0 || localSizeBits >= varSizeBits) continue;
                    varLocal.setType(this.toType(v.getDescriptor()));
                    continue;
                }
                if (u == startUnit) continue;
            }
        }
    }

    private void mergeVariables(Body body, Map<Local, Local> replacements) {
        HashMap<Local, Object> localToGroup = new HashMap<Local, Object>();
        HashMap<Object, Integer> groupToColorCount = new HashMap<Object, Integer>();
        HashMap<Local, Integer> localToColor = new HashMap<Local, Integer>();
        for (Local l : body.getLocals()) {
            Object localType = l.getIndex() < 0 ? l.getType() : new GroupIntPair(l.getType(), l.getIndex());
            localToGroup.put(l, localType);
            if (groupToColorCount.containsKey(localType)) continue;
            groupToColorCount.put(localType, 0);
        }
        FastColorer.assignColorsToLocals(body, localToGroup, localToColor, groupToColorCount);
        HashMap<GroupIntPair, Local> groupIntToLocal = new HashMap<GroupIntPair, Local>();
        for (Local local : body.getLocals()) {
            int color;
            Object group = localToGroup.get(local);
            GroupIntPair pair = new GroupIntPair(group, color = ((Integer)localToColor.get(local)).intValue());
            if (groupIntToLocal.containsKey(pair)) {
                replacements.put(local, (Local)groupIntToLocal.get(pair));
                continue;
            }
            groupIntToLocal.put(pair, local);
        }
    }

    private int getVariableSize(String descriptor) {
        switch (descriptor) {
            case "Z": {
                return 1;
            }
            case "B": {
                return 8;
            }
            case "C": {
                return 16;
            }
            case "S": {
                return 16;
            }
            case "I": {
                return 32;
            }
        }
        return -1;
    }

    private int getVariableSize(Type type) {
        if (type instanceof Integer1Type) {
            return 1;
        }
        if (type instanceof BooleanType) {
            return 1;
        }
        if (type instanceof Integer127Type) {
            return 8;
        }
        if (type instanceof ByteType) {
            return 8;
        }
        if (type instanceof ShortType) {
            return 16;
        }
        if (type instanceof CharType) {
            return 16;
        }
        if (type instanceof Integer32767Type) {
            return 32;
        }
        if (type instanceof IntType) {
            return 32;
        }
        return -1;
    }

    private Type toType(String descriptor) {
        return Util.v().jimpleTypeOfFieldDescriptor(descriptor);
    }
}

