/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.robovm.compiler.Version;
import org.robovm.gradle.RoboVMPluginExtension;
import org.robovm.gradle.tasks.ArchiveTask;
import org.robovm.gradle.tasks.ConsoleTask;
import org.robovm.gradle.tasks.IOSDeviceTask;
import org.robovm.gradle.tasks.IPadSimulatorTask;
import org.robovm.gradle.tasks.IPhoneSimulatorTask;
import org.robovm.gradle.tasks.InstallTask;
import org.robovm.gradle.tooling.ModelBuilder;

public class RoboVMPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;

    public static String getRoboVMVersion() {
        return Version.getVersion();
    }

    @Inject
    public RoboVMPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.registry.register((ToolingModelBuilder)new ModelBuilder());
        project.getExtensions().create("robovm", RoboVMPluginExtension.class, new Object[]{project});
        project.task(this.params(IPhoneSimulatorTask.class, "Runs your iOS app in the iPhone simulator"), "launchIPhoneSimulator");
        project.task(this.params(IPadSimulatorTask.class, "Runs your iOS app in the iPad simulator"), "launchIPadSimulator");
        project.task(this.params(IOSDeviceTask.class, "Runs your iOS app on a connected iOS device."), "launchIOSDevice");
        project.task(this.params(ConsoleTask.class, "Runs a console app"), "launchConsole");
        project.task(this.params(ArchiveTask.class, "Creates .ipa file. This is an alias for the robovmArchive task"), "createIPA");
        project.task(this.params(ArchiveTask.class, "Compiles a binary, archives it in a format suitable for distribution and saves it to build/robovm/"), "robovmArchive");
        project.task(this.params(InstallTask.class, "Compiles a binary and installs it to build/robovm/"), "robovmInstall");
    }

    private Map<String, Object> params(Class<? extends Task> task, String description) {
        return this.params(task, description, "build");
    }

    private Map<String, Object> params(Class<? extends Task> task, String description, String ... dependencies) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", task);
        params.put("description", description);
        if (dependencies != null) {
            params.put("dependsOn", dependencies);
        }
        return params;
    }
}

