/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle.tasks;

import com.mobidevelop.robovm.org.apache.commons.io.FileUtils;
import com.mobidevelop.robovm.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.robovm.compiler.AppCompiler;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.target.ios.ProvisioningProfile;
import org.robovm.compiler.target.ios.SigningIdentity;
import org.robovm.gradle.RoboVMPlugin;
import org.robovm.gradle.RoboVMPluginExtension;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public abstract class AbstractRoboVMTask
extends DefaultTask {
    protected final Project project = this.getProject();
    protected final RoboVMPluginExtension extension = (RoboVMPluginExtension)this.project.getExtensions().getByName("robovm");
    protected final RepositorySystem repositorySystem = this.createRepositorySystem();
    protected final RepositorySystemSession repositorySystemSession = this.createRepositorySystemSession();
    protected final List<RemoteRepository> remoteRepositories = this.createRemoteRepositories();
    @Internal
    protected Logger roboVMLogger;

    public AbstractRoboVMTask() {
        this.setGroup("MobiVM");
    }

    public AppCompiler build(OS os, Arch arch, Environment env, String targetType) {
        this.getLogger().info("Building RoboVM app for: " + os + " (" + arch + env.asLlvmSuffix("-") + ")");
        Config.Builder builder = new Config.Builder();
        this.configure(builder).os(os).arch(arch).env(env).targetType(targetType);
        try {
            this.getLogger().info("Compiling RoboVM app, this could take a while, especially the first time round");
            Config config = builder.build();
            AppCompiler compiler = new AppCompiler(config);
            compiler.build();
            this.getLogger().info("Compile RoboVM app completed.");
            return compiler;
        }
        catch (IOException e) {
            throw new GradleException("Error building RoboVM executable for app", (Throwable)e);
        }
    }

    protected Config.Builder configure(Config.Builder builder) {
        builder.logger(this.getRoboVMLogger());
        if (this.extension.getPropertiesFile() != null) {
            File propertiesFile = new File(this.extension.getPropertiesFile());
            if (!propertiesFile.exists()) {
                throw new GradleException("Invalid 'propertiesFile' specified for RoboVM compile: " + propertiesFile);
            }
            try {
                this.getLogger().debug("Including properties file in RoboVM compiler config: " + propertiesFile.getAbsolutePath());
                builder.addProperties(propertiesFile);
            }
            catch (IOException e) {
                throw new GradleException("Failed to add properties file to RoboVM config: " + propertiesFile);
            }
        }
        try {
            builder.readProjectProperties(this.project.getProjectDir(), false);
        }
        catch (IOException e) {
            throw new GradleException("Failed to read RoboVM project properties file(s) in " + this.project.getProjectDir().getAbsolutePath(), (Throwable)e);
        }
        if (this.extension.getConfigFile() != null) {
            File configFile = new File(this.extension.getConfigFile());
            if (!configFile.exists()) {
                throw new GradleException("Invalid 'configFile' specified for RoboVM compile: " + configFile);
            }
            try {
                this.getLogger().debug("Loading config file for RoboVM compiler: " + configFile.getAbsolutePath());
                builder.read(configFile);
            }
            catch (Exception e) {
                throw new GradleException("Failed to read RoboVM config file: " + configFile);
            }
        }
        try {
            builder.readProjectConfig(this.project.getProjectDir(), false);
        }
        catch (Exception e) {
            throw new GradleException("Failed to read project RoboVM config file in " + this.project.getProjectDir().getAbsolutePath(), (Throwable)e);
        }
        File installDir = null;
        installDir = this.extension.getInstallDir() != null ? new File(this.extension.getInstallDir()) : new File(this.project.getBuildDir(), "robovm");
        File cacheDir = null;
        cacheDir = this.extension.getCacheDir() != null ? new File(this.extension.getCacheDir()) : new File(System.getProperty("user.home"), ".robovm/cache");
        File temporaryDirectory = new File(this.project.getBuildDir(), "robovm.tmp");
        try {
            FileUtils.deleteDirectory(temporaryDirectory);
        }
        catch (IOException e) {
            throw new GradleException("Failed to clean output dir " + temporaryDirectory, (Throwable)e);
        }
        temporaryDirectory.mkdirs();
        builder.home(new Config.Home(this.unpack())).tmpDir(temporaryDirectory).skipInstall(true).installDir(installDir).cacheDir(cacheDir);
        if (this.project.hasProperty("mainClassName")) {
            builder.mainClass((String)this.project.property("mainClassName"));
        }
        if (this.extension.isDebug()) {
            builder.debug(true);
            if (this.extension.getDebugPort() != -1) {
                builder.addPluginArgument("debug:jdwpport=" + this.extension.getDebugPort());
            }
        }
        if (this.extension.isSkipLinking()) {
            builder.skipLinking(true);
        }
        if (this.extension.isIosSkipSigning()) {
            builder.iosSkipSigning(true);
        } else {
            if (this.extension.getIosSignIdentity() != null) {
                String iosSignIdentity = this.extension.getIosSignIdentity();
                this.getLogger().debug("Using explicit iOS Signing identity: " + iosSignIdentity);
                builder.iosSignIdentity(SigningIdentity.find((List)SigningIdentity.list(), (String)iosSignIdentity));
            }
            if (this.extension.getIosProvisioningProfile() != null) {
                String iosProvisioningProfile = this.extension.getIosProvisioningProfile();
                this.getLogger().debug("Using explicit iOS provisioning profile: " + iosProvisioningProfile);
                builder.iosProvisioningProfile(ProvisioningProfile.find((List)ProvisioningProfile.list(), (String)iosProvisioningProfile));
            }
        }
        if (this.extension.isDumpIntermediates()) {
            builder.dumpIntermediates(true);
        }
        if (this.extension.isEnableBitcode()) {
            builder.enableBitcode(true);
        }
        builder.clearClasspathEntries();
        Set classpathEntries = this.project.getConfigurations().getByName("runtimeClasspath").getFiles();
        classpathEntries.add(new File(this.project.getBuildDir(), "classes/main"));
        classpathEntries.add(new File(this.project.getBuildDir(), "classes/java/main"));
        classpathEntries.add(new File(this.project.getBuildDir(), "classes/groovy/main"));
        classpathEntries.add(new File(this.project.getBuildDir(), "classes/scala/main"));
        classpathEntries.add(new File(this.project.getBuildDir(), "classes/kotlin/main"));
        classpathEntries.add(new File(this.project.getBuildDir(), "resources/main"));
        if (this.project.hasProperty("output.classesDir")) {
            classpathEntries.add((File)this.project.property("output.classesDir"));
        }
        for (File classpathEntry : classpathEntries) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Including classpath element for RoboVM app: " + classpathEntry.getAbsolutePath());
            }
            if (!classpathEntry.exists()) continue;
            builder.addClasspathEntry(classpathEntry);
        }
        return builder;
    }

    @TaskAction
    public abstract void invoke();

    protected File unpack() throws GradleException {
        Artifact artifact = this.resolveArtifact("com.mobidevelop.robovm:robovm-dist:tar.gz:nocompiler:" + RoboVMPlugin.getRoboVMVersion());
        File distTarFile = artifact.getFile();
        File unpackedDirectory = new File(distTarFile.getParent(), "unpacked");
        final File unpackedDistDirectory = new File(unpackedDirectory, "robovm-" + RoboVMPlugin.getRoboVMVersion());
        if (unpackedDirectory.exists() && !artifact.isSnapshot()) {
            this.getLogger().debug("Archive '" + distTarFile + "' was already unpacked in: " + unpackedDirectory);
        } else {
            this.getLogger().info("Extracting '" + distTarFile + "' to: " + unpackedDirectory);
            if (!unpackedDirectory.exists() && !unpackedDirectory.mkdirs()) {
                throw new GradleException("Unable to create base directory to unpack into: " + unpackedDirectory);
            }
            try {
                this.extractTarGz(distTarFile, unpackedDirectory);
            }
            catch (IOException e) {
                throw new GradleException("Couldn't extract distribution tar.gz", (Throwable)e);
            }
            if (!unpackedDistDirectory.exists()) {
                throw new GradleException("Unable to unpack archive");
            }
        }
        this.getAnt().invokeMethod("chmod", (Object)new HashMap<String, Object>(){
            {
                this.put("dir", new File(unpackedDistDirectory, "bin").getAbsoluteFile());
                this.put("perm", "+x");
                this.put("includes", "*");
            }
        });
        return unpackedDistDirectory;
    }

    protected Artifact resolveArtifact(String artifactLocator) throws GradleException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(artifactLocator);
        request.setArtifact(artifact);
        request.setRepositories(this.remoteRepositories);
        this.getLogger().debug("Resolving artifact " + artifact + " from " + this.remoteRepositories);
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
        this.getLogger().debug("Resolved artifact " + artifact + " to " + result.getArtifact().getFile() + " from " + result.getRepository());
        return result.getArtifact();
    }

    protected Logger getRoboVMLogger() {
        if (this.roboVMLogger == null) {
            this.roboVMLogger = new Logger(){

                public void debug(String s, Object ... objects) {
                    AbstractRoboVMTask.this.getLogger().debug(String.format(s, objects));
                }

                public void info(String s, Object ... objects) {
                    AbstractRoboVMTask.this.getLogger().info(String.format(s, objects));
                }

                public void warn(String s, Object ... objects) {
                    AbstractRoboVMTask.this.getLogger().warn(String.format(s, objects));
                }

                public void error(String s, Object ... objects) {
                    AbstractRoboVMTask.this.getLogger().error(String.format(s, objects));
                }
            };
        }
        return this.roboVMLogger;
    }

    private RepositorySystem createRepositorySystem() {
        MavenServiceLocator locator = new MavenServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setService(WagonProvider.class, ManualWagonProvider.class);
        return locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession createRepositorySystemSession() {
        LocalRepository localRepository = new LocalRepository(System.getProperty("user.home") + "/.m2/repository");
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager(localRepository));
        return session;
    }

    private List<RemoteRepository> createRemoteRepositories() {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        repositories.add(new RemoteRepository("maven-central", "default", "https://repo1.maven.org/maven2/"));
        repositories.add(new RemoteRepository("oss.sonatype.org-snapshots", "default", "https://oss.sonatype.org/content/repositories/snapshots/"));
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractTarGz(File archive, File destDir) throws IOException {
        TarArchiveInputStream in;
        block12: {
            in = null;
            try {
                boolean filesWereUpdated = false;
                in = new TarArchiveInputStream(new GZIPInputStream(new FileInputStream(archive)));
                ArchiveEntry entry = null;
                while ((entry = in.getNextEntry()) != null) {
                    int mode;
                    File f = new File(destDir, entry.getName());
                    if (entry.isDirectory()) {
                        f.mkdirs();
                        continue;
                    }
                    if (f.exists() && f.lastModified() == entry.getLastModifiedDate().getTime() && f.length() == entry.getSize()) continue;
                    f.getParentFile().mkdirs();
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(f);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        IOUtils.closeQuietly(out);
                        out = null;
                        f.setLastModified(entry.getLastModifiedDate().getTime());
                    }
                    finally {
                        if (out != null) {
                            IOUtils.closeQuietly(out);
                        }
                    }
                    if (entry instanceof TarArchiveEntry && ((mode = ((TarArchiveEntry)entry).getMode()) & 0x40) > 0) {
                        f.setExecutable(true, (mode & 1) == 0);
                    }
                    filesWereUpdated = true;
                }
                if (!filesWereUpdated) break block12;
                this.getLogger().debug("Archive '" + archive + "' unpacked to: " + destDir);
                this.getLogger().info("Clearing ~/.robovm/cache folder due SDK files changed.");
                File cacheDir = new File(System.getProperty("user.home"), ".robovm/cache");
                try {
                    FileUtils.deleteDirectory(cacheDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
    }

    public static class ManualWagonProvider
    implements WagonProvider {
        @Override
        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint) || "https".equals(roleHint)) {
                return new HttpWagon();
            }
            return null;
        }

        @Override
        public void release(Wagon wagon) {
        }
    }
}

