/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSString
extends NSObject
implements Comparable<Object> {
    private String content;
    private static CharsetEncoder asciiEncoder;
    private static CharsetEncoder utf16beEncoder;
    private static CharsetEncoder utf8Encoder;

    public NSString(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        this.content = new String(bytes, encoding);
    }

    public NSString(String string) {
        this.content = string;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String c) {
        this.content = c;
    }

    public void append(NSString s) {
        this.append(s.getContent());
    }

    public void append(String s) {
        this.content = this.content + s;
    }

    public void prepend(String s) {
        this.content = s + this.content;
    }

    public void prepend(NSString s) {
        this.prepend(s.getContent());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NSString)) {
            return false;
        }
        return this.content.equals(((NSString)obj).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<string>");
        Class<NSString> clazz = NSString.class;
        synchronized (NSString.class) {
            if (utf8Encoder == null) {
                utf8Encoder = Charset.forName("UTF-8").newEncoder();
            } else {
                utf8Encoder.reset();
            }
            try {
                ByteBuffer byteBuf = utf8Encoder.encode(CharBuffer.wrap(this.content));
                byte[] bytes = new byte[byteBuf.remaining()];
                byteBuf.get(bytes);
                this.content = new String(bytes, "UTF-8");
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not encode the NSString into UTF-8: " + String.valueOf(ex.getMessage()));
            }
            if (this.content.contains("&") || this.content.contains("<") || this.content.contains(">")) {
                xml.append("<![CDATA[");
                xml.append(this.content.replaceAll("]]>", "]]]]><![CDATA[>"));
                xml.append("]]>");
            } else {
                xml.append(this.content);
            }
            xml.append("</string>");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBinary(BinaryPropertyListWriter out) throws IOException {
        CharBuffer charBuf = CharBuffer.wrap(this.content);
        Class<NSString> clazz = NSString.class;
        synchronized (NSString.class) {
            ByteBuffer byteBuf;
            int kind;
            if (asciiEncoder == null) {
                asciiEncoder = Charset.forName("ASCII").newEncoder();
            } else {
                asciiEncoder.reset();
            }
            if (asciiEncoder.canEncode((CharSequence)charBuf)) {
                kind = 5;
                byteBuf = asciiEncoder.encode(charBuf);
            } else {
                if (utf16beEncoder == null) {
                    utf16beEncoder = Charset.forName("UTF-16BE").newEncoder();
                } else {
                    utf16beEncoder.reset();
                }
                kind = 6;
                byteBuf = utf16beEncoder.encode(charBuf);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            byte[] bytes = new byte[byteBuf.remaining()];
            byteBuf.get(bytes);
            out.writeIntHeader(kind, this.content.length());
            out.write(bytes);
            return;
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        ascii.append(NSString.escapeStringForASCII(this.content));
        ascii.append("\"");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        ascii.append(NSString.escapeStringForASCII(this.content));
        ascii.append("\"");
    }

    static String escapeStringForASCII(String s) {
        String out = "";
        char[] cArray = s.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u007f') {
                out = out + "\\U";
                String hex = Integer.toHexString(c);
                while (hex.length() < 4) {
                    hex = "0" + hex;
                }
                out = out + hex;
                continue;
            }
            out = c == '\\' ? out + "\\\\" : (c == '\"' ? out + "\\\"" : (c == '\b' ? out + "\\b" : (c == '\n' ? out + "\\n" : (c == '\r' ? out + "\\r" : (c == '\t' ? out + "\\t" : out + c)))));
        }
        return out;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof NSString) {
            return this.getContent().compareTo(((NSString)o).getContent());
        }
        if (o instanceof String) {
            return this.getContent().compareTo((String)o);
        }
        return -1;
    }
}

