/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robovm.compiler.Functions;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Type;
import soot.SootClass;
import soot.SootMethod;

public class ITable {
    private Entry[] entries;

    private ITable(SootClass clazz) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (SootMethod method : clazz.getMethods()) {
            if (method.isStatic() || !method.isPublic()) continue;
            entries.add(new Entry(entries.size(), method));
        }
        this.entries = entries.toArray(new Entry[entries.size()]);
    }

    public int size() {
        return this.entries.length;
    }

    Entry findEntry(String name, String desc2) {
        for (Entry entry : this.entries) {
            if (!entry.name.equals(name) || !entry.desc.equals(desc2)) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(SootMethod method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        return this.findEntry(method.getName(), Types.getDescriptor(method));
    }

    public StructureConstant getStruct() {
        ArrayConstantBuilder table = new ArrayConstantBuilder(Type.I8_PTR);
        for (Entry entry : this.entries) {
            if (!Modifier.isAbstract(entry.getModifiers())) {
                table.add(new ConstantBitcast(entry.getFunctionRef(), Type.I8_PTR));
                continue;
            }
            table.add(new ConstantBitcast(Functions.BC_ABSTRACT_METHOD_CALLED, Type.I8_PTR));
        }
        return new StructureConstantBuilder().add(new IntegerConstant((short)this.entries.length)).add(table.build()).build();
    }

    public StructureConstant getStruct(ModuleBuilder mb, SootClass clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Expected a class got an interface: " + clazz.getName());
        }
        ArrayConstantBuilder table = new ArrayConstantBuilder(Type.I8_PTR);
        for (Entry entry : this.entries) {
            ResolvedEntry resolvedEntry = entry.resolve(clazz);
            if (resolvedEntry == null) {
                FunctionRef defaultFunctionRef = entry.getFunctionRef();
                if (defaultFunctionRef != null) {
                    if (!mb.hasSymbol(defaultFunctionRef.getName())) {
                        mb.addFunctionDeclaration(new FunctionDeclaration(defaultFunctionRef));
                    }
                    table.add(new ConstantBitcast(defaultFunctionRef, Type.I8_PTR));
                    continue;
                }
                table.add(new ConstantBitcast(Functions.BC_ABSTRACT_METHOD_CALLED, Type.I8_PTR));
                continue;
            }
            if (Modifier.isAbstract(resolvedEntry.getModifiers())) {
                table.add(new ConstantBitcast(Functions.BC_ABSTRACT_METHOD_CALLED, Type.I8_PTR));
                continue;
            }
            if (!Modifier.isPublic(resolvedEntry.getModifiers())) {
                table.add(new ConstantBitcast(Functions.BC_NON_PUBLIC_METHOD_CALLED, Type.I8_PTR));
                continue;
            }
            FunctionRef functionRef = resolvedEntry.getFunctionRef();
            if (!resolvedEntry.declaringClass.equals(clazz.getName()) && !mb.hasSymbol(functionRef.getName())) {
                mb.addFunctionDeclaration(new FunctionDeclaration(functionRef));
            }
            table.add(new ConstantBitcast(functionRef, Type.I8_PTR));
        }
        return new StructureConstantBuilder().add(new IntegerConstant((short)this.entries.length)).add(table.build()).build();
    }

    public static class ResolvedEntry
    extends Entry {
        public ResolvedEntry(Entry entry, SootMethod method) {
            super(entry.index, method);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResolvedEntry [modifiers=").append(this.modifiers).append(", declaringClass=").append(this.declaringClass).append(", index=").append(this.index).append(", name=").append(this.name).append(", desc=").append(this.desc).append("]");
            return builder.toString();
        }
    }

    public static class Entry {
        protected int index;
        protected final int modifiers;
        protected final String declaringClass;
        protected final String name;
        protected final String desc;

        Entry(int index, SootMethod method) {
            this(index, method.getModifiers(), method.getDeclaringClass().getName(), method.getName(), Types.getDescriptor(method));
        }

        Entry(int index, int modifiers, String declaringClass, String name, String desc2) {
            this.index = index;
            this.modifiers = modifiers;
            this.declaringClass = declaringClass;
            this.name = name;
            this.desc = desc2;
        }

        private ResolvedEntry resolve(SootClass clazz) {
            SootClass c = clazz;
            if (!c.isInterface()) {
                while (c != null) {
                    ResolvedEntry e = this.resolveImmediate(c);
                    if (e != null) {
                        return e;
                    }
                    c = c.hasSuperclass() ? c.getSuperclass() : null;
                }
            }
            c = clazz;
            while (c != null) {
                ResolvedEntry e;
                for (SootClass interfaze : c.getInterfaces()) {
                    e = this.resolveImmediate(interfaze);
                    if (e == null) continue;
                    return e;
                }
                for (SootClass interfaze : c.getInterfaces()) {
                    e = this.resolve(interfaze);
                    if (e == null) continue;
                    return e;
                }
                c = c.hasSuperclass() ? c.getSuperclass() : null;
            }
            return null;
        }

        private ResolvedEntry resolveImmediate(SootClass clazz) {
            for (SootMethod m : clazz.getMethods()) {
                if (!m.getName().equals(this.name) || !this.desc.equals(Types.getDescriptor(m))) continue;
                return new ResolvedEntry(this, m);
            }
            return null;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getDeclaringClass() {
            return this.declaringClass;
        }

        public FunctionRef getFunctionRef() {
            if (Modifier.isAbstract(this.modifiers) || !Modifier.isPublic(this.modifiers)) {
                return null;
            }
            String owner = this.declaringClass.replace('.', '/');
            String functionName = Modifier.isSynchronized(this.modifiers) ? Symbols.synchronizedWrapperSymbol(owner, this.name, this.desc) : Symbols.methodSymbol(owner, this.name, this.desc);
            return new FunctionRef(functionName, Types.getFunctionType(this.desc, Modifier.isStatic(this.modifiers)));
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Entry [modifiers=").append(this.modifiers).append(", declaringClass=").append(this.declaringClass).append(", index=").append(this.index).append(", name=").append(this.name).append(", desc=").append(this.desc).append("]");
            return builder.toString();
        }
    }

    public static class Cache {
        Map<String, ITable> cache = new HashMap<String, ITable>();

        public ITable get(SootClass clazz) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("Not an interface: " + clazz.getName());
            }
            ITable itable = this.cache.get(clazz.getName());
            if (itable != null) {
                return itable;
            }
            itable = new ITable(clazz);
            this.cache.put(clazz.getName(), itable);
            return itable;
        }
    }
}

