/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import com.mobidevelop.robovm.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.robovm.compiler.clazz.AbstractPath;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.Clazzes;

public class DirectoryPath
extends AbstractPath {
    DirectoryPath(File dir, Clazzes clazzes, int index, boolean inBootclasspath) {
        super(dir, clazzes, index, inBootclasspath);
    }

    @Override
    public boolean contains(String file) {
        File f = new File(this.getFile(), file);
        return f.exists() && f.isFile();
    }

    @Override
    public InputStream open(String file) throws IOException {
        File f = new File(this.getFile(), file);
        return new FileInputStream(f);
    }

    @Override
    protected Set<Clazz> doListClasses() {
        TreeSet<Clazz> s = new TreeSet<Clazz>();
        for (File f : this.listClassFiles()) {
            s.add(new DirectoryPathClazz(this.clazzes, this, this.file, f));
        }
        return s;
    }

    private List<File> listClassFiles() {
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles(this.file, new String[]{"class"}, true));
        Collections.sort(files);
        return files;
    }

    private boolean hasChangedSince(File dir, long timestamp) {
        for (File f : dir.listFiles()) {
            if (!(f.isFile() ? f.lastModified() > timestamp : this.hasChangedSince(f, timestamp))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChangedSince(long timestamp) {
        return this.hasChangedSince(this.file, timestamp);
    }

    public static class DirectoryPathClazz
    extends Clazz {
        private final File f;
        private byte[] bytes = null;

        DirectoryPathClazz(Clazzes clazzes, AbstractPath path, File dir, File f) {
            super(clazzes, f.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1), path);
            this.f = f;
        }

        @Override
        public byte[] getBytes() throws IOException {
            if (this.bytes == null) {
                this.bytes = FileUtils.readFileToByteArray(this.f);
            }
            return this.bytes;
        }

        public File getClassFile() {
            return this.f;
        }

        @Override
        public long lastModified() {
            return this.f.lastModified();
        }
    }
}

