/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.AggregateType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;

public class ConstantGetelementptr
extends Constant {
    private final Constant cst;
    private final int[] idx;

    public ConstantGetelementptr(Constant cst, int ... idx) {
        if (!cst.isPointer()) {
            throw new IllegalArgumentException("PointerType expected");
        }
        if (!(((PointerType)cst.getType()).getBase() instanceof AggregateType)) {
            throw new IllegalArgumentException("PointerType should point to AggregateType");
        }
        if (idx == null || idx.length == 0) {
            throw new IllegalArgumentException("No indexes");
        }
        this.cst = cst;
        this.idx = idx;
    }

    @Override
    public Type getType() {
        Type t = (AggregateType)((PointerType)this.cst.getType()).getBase();
        for (int i = 1; i < this.idx.length; ++i) {
            t = t.getTypeAt(this.idx[i]);
        }
        return new PointerType(t);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("getelementptr (");
        sb.append(this.cst.getType());
        sb.append(' ');
        sb.append(this.cst);
        for (int i = 0; i < this.idx.length; ++i) {
            sb.append(", i32 ");
            sb.append(this.idx[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

