/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.BinaryOpInstruction;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public class Fcmp
extends BinaryOpInstruction {
    private final Condition cond;

    public Fcmp(Variable result, Condition cond, Value op1, Value op2) {
        super(result, op1, op2);
        if (result.getType() != Type.I1) {
            throw new IllegalArgumentException("i1 type expected as result");
        }
        if (!op1.getType().equals(op2.getType())) {
            throw new IllegalArgumentException("Type mismatch");
        }
        if (!op1.isFloatingPoint()) {
            throw new IllegalArgumentException("Floating point type expected");
        }
        this.cond = cond;
    }

    public String toString() {
        return this.result + " = fcmp " + (Object)((Object)this.cond) + " " + this.op1.getType() + " " + this.op1 + ", " + this.op2;
    }

    public static enum Condition {
        oeq,
        ogt,
        oge,
        olt,
        ole,
        one,
        ord,
        ueq,
        ugt,
        uge,
        ult,
        ule,
        une,
        uno;

    }
}

