/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.annotation;

import com.mobidevelop.robovm.asm.ClassWriter;
import com.mobidevelop.robovm.asm.FieldVisitor;
import com.mobidevelop.robovm.asm.Label;
import com.mobidevelop.robovm.asm.MethodVisitor;
import com.mobidevelop.robovm.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import soot.PrimType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;

public class AnnotationImplPlugin
extends AbstractCompilerPlugin {
    private static final int MOD_ANNOTATION = 8192;
    public static final String IMPL_CLASS_NAME_SUFFIX = "$Impl";
    private static final String BASE_CLASS = "org/robovm/rt/annotation/Annotation";
    private boolean initialized = false;

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    private void generateMemberFieldsAndAccessorMethods(Clazz clazz, ClassWriter cw) throws IOException {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        SootClass sootClass = clazz.getSootClass();
        List<SootMethod> methods = sootClass.getMethods();
        for (SootMethod method : methods) {
            String fieldName = this.getFieldName(method);
            Type type = method.getReturnType();
            String typeDesc = Types.getDescriptor(type);
            cw.visitField(2, fieldName, "Ljava/lang/Object;", null, null).visitEnd();
            MethodVisitor mv = cw.visitMethod(1, method.getName(), Types.getDescriptor(method), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitLdcInsn(method.getName());
            mv.visitMethodInsn(183, BASE_CLASS, "validate", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            int retOp = 0;
            switch (typeDesc.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    retOp = 172;
                    break;
                }
                case 'J': {
                    retOp = 173;
                    break;
                }
                case 'F': {
                    retOp = 174;
                    break;
                }
                case 'D': {
                    retOp = 175;
                    break;
                }
                default: {
                    retOp = 176;
                }
            }
            this.unboxIfNeeded(mv, type);
            if (!(type instanceof PrimType)) {
                mv.visitTypeInsn(192, Types.getInternalName(type));
            }
            mv.visitInsn(retOp);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void generateSetDefaultsMethod(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        SootClass sootClass = clazz.getSootClass();
        List<SootMethod> methods = sootClass.getMethods();
        MethodVisitor mv = cw.visitMethod(2, "$setDefaults", "()V", null, null);
        mv.visitCode();
        for (SootMethod method : methods) {
            AnnotationDefaultTag defTag = (AnnotationDefaultTag)method.getTag(AnnotationDefaultTag.class.getSimpleName());
            String fieldName = this.getFieldName(method);
            if (defTag == null) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(178, BASE_CLASS, "NO_VALUE", "Ljava/lang/Object;");
                mv.visitFieldInsn(181, implName, fieldName, "Ljava/lang/Object;");
                continue;
            }
            Type type = method.getReturnType();
            String typeDesc = Types.getDescriptor(type);
            Object v = null;
            if (type instanceof PrimType) {
                switch (typeDesc.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        v = ((AnnotationIntElem)defTag.getDefaultVal()).getValue();
                        break;
                    }
                    case 'J': {
                        v = ((AnnotationLongElem)defTag.getDefaultVal()).getValue();
                        break;
                    }
                    case 'F': {
                        v = Float.valueOf(((AnnotationFloatElem)defTag.getDefaultVal()).getValue());
                        break;
                    }
                    case 'D': {
                        v = ((AnnotationDoubleElem)defTag.getDefaultVal()).getValue();
                    }
                }
            } else if ("Ljava/lang/Class;".equals(typeDesc)) {
                v = com.mobidevelop.robovm.asm.Type.getType(((AnnotationClassElem)defTag.getDefaultVal()).getDesc());
                if (((com.mobidevelop.robovm.asm.Type)v).getDescriptor().length() != 1) {
                    v = null;
                }
            } else if ("Ljava/lang/String;".equals(typeDesc)) {
                v = ((AnnotationStringElem)defTag.getDefaultVal()).getValue();
            }
            if (v != null) {
                mv.visitVarInsn(25, 0);
                if (v instanceof com.mobidevelop.robovm.asm.Type && ((com.mobidevelop.robovm.asm.Type)v).getDescriptor().length() == 1) {
                    switch (((com.mobidevelop.robovm.asm.Type)v).getDescriptor().charAt(0)) {
                        case 'V': {
                            mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'Z': {
                            mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'B': {
                            mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'S': {
                            mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'C': {
                            mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'I': {
                            mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'J': {
                            mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'F': {
                            mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'D': {
                            mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                        }
                    }
                } else {
                    mv.visitLdcInsn(v);
                }
                this.boxIfNeeded(mv, type);
                mv.visitFieldInsn(181, implName, fieldName, "Ljava/lang/Object;");
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitLdcInsn(method.getName());
            mv.visitMethodInsn(183, BASE_CLASS, "getDefaultValue", "(Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitFieldInsn(181, implName, fieldName, "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String getFieldName(SootMethod method) {
        String fieldName = "m$" + method.getName();
        return fieldName;
    }

    private void generateConstructor(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(com.mobidevelop.robovm.asm.Type.getObjectType(clazz.getInternalName()));
        mv.visitMethodInsn(183, BASE_CLASS, "<init>", "(Ljava/lang/Class;)V");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, implName, "$setDefaults", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateAnnotationTypeMethod(Clazz clazz, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "annotationType", "()Ljava/lang/Class;", null, null);
        mv.visitCode();
        mv.visitLdcInsn(com.mobidevelop.robovm.asm.Type.getObjectType(clazz.getInternalName()));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateMembersToStringMethod(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(4, "membersToString", "(Ljava/lang/StringBuilder;)V", null, null);
        mv.visitCode();
        boolean first = true;
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            String fieldName = this.getFieldName(method);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitLdcInsn(method.getName());
            mv.visitInsn(first ? 4 : 3);
            mv.visitMethodInsn(183, BASE_CLASS, "memberToString", "(Ljava/lang/StringBuilder;Ljava/lang/Object;Ljava/lang/String;Z)V");
            first = false;
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateFastEqualsMethod(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(4, "fastEquals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, implName);
        mv.visitVarInsn(58, 1);
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            String fieldName = this.getFieldName(method);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitMethodInsn(183, BASE_CLASS, "memberEquals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            Label l1 = new Label();
            mv.visitJumpInsn(154, l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l1);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void boxIfNeeded(MethodVisitor mv, Type type) {
        if (type instanceof PrimType) {
            String typeDesc = Types.getDescriptor(type);
            String wrapperType = null;
            switch (typeDesc.charAt(0)) {
                case 'Z': {
                    wrapperType = "java/lang/Boolean";
                    break;
                }
                case 'B': {
                    wrapperType = "java/lang/Byte";
                    break;
                }
                case 'S': {
                    wrapperType = "java/lang/Short";
                    break;
                }
                case 'C': {
                    wrapperType = "java/lang/Character";
                    break;
                }
                case 'I': {
                    wrapperType = "java/lang/Integer";
                    break;
                }
                case 'J': {
                    wrapperType = "java/lang/Long";
                    break;
                }
                case 'F': {
                    wrapperType = "java/lang/Float";
                    break;
                }
                case 'D': {
                    wrapperType = "java/lang/Double";
                }
            }
            mv.visitMethodInsn(184, BASE_CLASS, "box", "(" + typeDesc + ")L" + wrapperType + ";");
        }
    }

    private void unboxIfNeeded(MethodVisitor mv, Type type) {
        if (type instanceof PrimType) {
            String typeDesc = Types.getDescriptor(type);
            String wrapperType = null;
            switch (typeDesc.charAt(0)) {
                case 'Z': {
                    wrapperType = "java/lang/Boolean";
                    break;
                }
                case 'B': {
                    wrapperType = "java/lang/Byte";
                    break;
                }
                case 'S': {
                    wrapperType = "java/lang/Short";
                    break;
                }
                case 'C': {
                    wrapperType = "java/lang/Character";
                    break;
                }
                case 'I': {
                    wrapperType = "java/lang/Integer";
                    break;
                }
                case 'J': {
                    wrapperType = "java/lang/Long";
                    break;
                }
                case 'F': {
                    wrapperType = "java/lang/Float";
                    break;
                }
                case 'D': {
                    wrapperType = "java/lang/Double";
                }
            }
            mv.visitTypeInsn(192, wrapperType);
            mv.visitMethodInsn(184, BASE_CLASS, "unbox", "(L" + wrapperType + ";)" + typeDesc);
        }
    }

    private void generateSlowEqualsMethod(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(4, "slowEquals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, clazz.getInternalName());
        mv.visitVarInsn(58, 1);
        Label l1 = new Label();
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            String fieldName = this.getFieldName(method);
            Type type = method.getReturnType();
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, clazz.getInternalName(), method.getName(), "()" + Types.getDescriptor(type));
            this.boxIfNeeded(mv, type);
            mv.visitMethodInsn(183, BASE_CLASS, "memberEquals", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            mv.visitJumpInsn(153, l1);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateHashCodeMethod(Clazz clazz, ClassWriter cw) {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        for (SootMethod method : clazz.getSootClass().getMethods()) {
            String fieldName = this.getFieldName(method);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, implName, fieldName, "Ljava/lang/Object;");
            mv.visitLdcInsn(method.getName());
            mv.visitMethodInsn(183, BASE_CLASS, "hash", "(Ljava/lang/Object;Ljava/lang/String;)I");
            mv.visitInsn(96);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateFactoryMethod(Clazz clazz, ClassWriter cw) throws IOException {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        MethodVisitor mv = cw.visitMethod(9, "$create", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (clazz.getSootClass().getMethodCount() == 0) {
            mv.visitMethodInsn(184, implName, "$createSingleton", "()Ljava/lang/Object;");
        } else {
            mv.visitTypeInsn(187, implName);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, implName, "<init>", "()V");
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateSingletonFactoryMethod(Clazz clazz, ClassWriter cw) throws IOException {
        String implName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
        FieldVisitor fv = cw.visitField(26, "$instance", "L" + implName + ";", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, implName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, implName, "<init>", "()V");
        mv.visitFieldInsn(179, implName, "$instance", "L" + implName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "$createSingleton", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, implName, "$instance", "L" + implName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) {
        this.init();
        SootClass sootClass = clazz.getSootClass();
        if ((sootClass.getModifiers() & 0x2000) > 0) {
            try {
                String implInternalName = clazz.getInternalName() + IMPL_CLASS_NAME_SUFFIX;
                ClassWriter cw = new ClassWriter(3);
                cw.visit(51, 4145, implInternalName, null, BASE_CLASS, new String[]{clazz.getInternalName()});
                this.generateConstructor(clazz, cw);
                this.generateAnnotationTypeMethod(clazz, cw);
                this.generateMembersToStringMethod(clazz, cw);
                this.generateFastEqualsMethod(clazz, cw);
                this.generateSlowEqualsMethod(clazz, cw);
                this.generateHashCodeMethod(clazz, cw);
                this.generateMemberFieldsAndAccessorMethods(clazz, cw);
                this.generateSetDefaultsMethod(clazz, cw);
                this.generateSingletonFactoryMethod(clazz, cw);
                this.generateFactoryMethod(clazz, cw);
                cw.visitEnd();
                File f = clazz.getPath().getGeneratedClassFile(implInternalName);
                FileUtils.writeByteArrayToFile(f, cw.toByteArray());
                f.setLastModified(clazz.lastModified());
                clazz.getClazzInfo().addClassDependency(implInternalName, false);
                clazz.getClazzInfo().addInvokeMethodDependency(implInternalName, "$createSingleton", "()Ljava/lang/Object;", false);
                clazz.getClazzInfo().addInvokeMethodDependency(implInternalName, "$create", "()Ljava/lang/Object;", false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

