/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.util.generic.GenericDeclaration;
import org.robovm.compiler.util.generic.GenericSignatureParser;
import org.robovm.compiler.util.generic.SootBaseType;
import org.robovm.compiler.util.generic.SootMethodType;
import org.robovm.compiler.util.generic.Type;
import org.robovm.compiler.util.generic.TypeVariable;
import org.robovm.compiler.util.generic.Types;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.Tag;

public class SootClassType
extends SootBaseType
implements GenericDeclaration {
    private final SootClass sootClass;

    public SootClassType(String name) {
        this(SootResolver.v().makeClassRef(name));
    }

    public SootClassType(SootClass sootClass) {
        this.sootClass = sootClass;
    }

    public SootClass getSootClass() {
        return this.sootClass;
    }

    private boolean isAssignableFrom(SootClass sub) {
        if (this.sootClass.equals(sub)) {
            return true;
        }
        if (this.sootClass.isInterface()) {
            SootClass c = sub;
            while (c != null) {
                for (SootClass ifs : c.getInterfaces()) {
                    if (!this.isAssignableFrom(ifs)) continue;
                    return true;
                }
                c = c.hasSuperclass() ? c.getSuperclass() : null;
            }
        } else if (sub.hasSuperclass()) {
            return this.isAssignableFrom(sub.getSuperclass());
        }
        return false;
    }

    public boolean isAssignableFrom(SootClassType c) {
        return this.isAssignableFrom(c.sootClass);
    }

    @Override
    public TypeVariable<?>[] getTypeParameters() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForClass(this, (SignatureTag)this.sootClass.getTag("SignatureTag"));
        return (TypeVariable[])parser.formalTypeParameters.clone();
    }

    public Type[] getGenericInterfaces() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForClass(this, (SignatureTag)this.sootClass.getTag("SignatureTag"));
        return parser.interfaceTypes.getResolvedTypes();
    }

    public Type getGenericSuperclass() {
        GenericSignatureParser parser = new GenericSignatureParser();
        parser.parseForClass(this, (SignatureTag)this.sootClass.getTag("SignatureTag"));
        return Types.getType(parser.superclassType);
    }

    private SootMethodType getEnclosingMethod(boolean constructor) {
        EnclosingMethodTag emTag = (EnclosingMethodTag)this.sootClass.getTag("EnclosingMethodTag");
        if (emTag != null) {
            SootClass cls;
            String clsName = emTag.getEnclosingClass();
            String name = emTag.getEnclosingMethod();
            String desc2 = emTag.getEnclosingMethodSig();
            if (clsName != null && name != null && desc2 != null && (constructor && name.equals("<init>") || !constructor && !name.equals("<init>") && !name.equals("<clinit>")) && !(cls = SootResolver.v().makeClassRef(clsName)).isPhantom()) {
                for (SootMethod m : cls.getMethods()) {
                    String mDesc = org.robovm.compiler.Types.getDescriptor(m);
                    if (!m.getName().equals(name) || !desc2.equals(mDesc)) continue;
                    return new SootMethodType(m);
                }
            }
        }
        return null;
    }

    public SootMethodType getEnclosingMethod() {
        return this.getEnclosingMethod(false);
    }

    public SootMethodType getEnclosingConstructor() {
        return this.getEnclosingMethod(true);
    }

    public SootClassType getEnclosingClass() {
        EnclosingMethodTag emTag = (EnclosingMethodTag)this.sootClass.getTag("EnclosingMethodTag");
        if (emTag == null) {
            return this.getDeclaringClass();
        }
        return new SootClassType(emTag.getEnclosingClass().replace('/', '.'));
    }

    public SootClassType getSuperclass() {
        if (this.sootClass.isPhantom()) {
            return new SootClassType("java.lang.Object");
        }
        return this.sootClass.hasSuperclass() ? new SootClassType(this.sootClass.getSuperclass()) : null;
    }

    public SootClassType[] getInterfaces() {
        if (this.sootClass.isPhantom()) {
            return new SootClassType[0];
        }
        return this.wrapClasses(this.sootClass.getInterfaces());
    }

    public SootClassType getDeclaringClass() {
        for (Tag tag : this.sootClass.getTags()) {
            InnerClassTag icTag;
            if (!(tag instanceof InnerClassTag) || (icTag = (InnerClassTag)tag).getInnerClass() == null || icTag.getOuterClass() == null) continue;
            String innerName = icTag.getInnerClass().replace('/', '.');
            if (!this.sootClass.getName().equals(innerName)) continue;
            return new SootClassType(icTag.getOuterClass().replace('/', '.'));
        }
        return null;
    }

    public String toString() {
        return this.sootClass.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sootClass == null ? 0 : this.sootClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SootClassType other = (SootClassType)obj;
        return !(this.sootClass == null ? other.sootClass != null : !this.sootClass.equals(other.sootClass));
    }

    private String toSimpleClassTypeSignature() {
        StringBuilder sb = new StringBuilder();
        SootClassType declaringClass = this.getDeclaringClass();
        if (declaringClass != null && declaringClass.sootClass.hasTag("SignatureTag")) {
            sb.append(declaringClass.toSimpleClassTypeSignature());
            sb.append('.');
            String innerName = this.sootClass.getName().substring(declaringClass.sootClass.getName().length() + 1);
            sb.append(innerName);
        } else {
            sb.append(this.sootClass.getName().replace('.', '/'));
        }
        TypeVariable<?>[] typeArgs = this.getTypeParameters();
        if (typeArgs.length > 0) {
            sb.append("<");
            for (TypeVariable<?> ta : typeArgs) {
                sb.append(ta.toGenericSignature());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public String toGenericSignature() {
        return "L" + this.toSimpleClassTypeSignature() + ";";
    }
}

