/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.hooks.payloads.HooksCmdResponse;
import org.robovm.debugger.jdwp.handlers.array.IJdwpArrayDelegate;
import org.robovm.debugger.runtime.ValueManipulator;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoArrayImpl;
import org.robovm.debugger.state.classdata.ClassInfoPrimitiveImpl;
import org.robovm.debugger.state.instances.VmArrayInstance;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class JdwpArrayDelegate
implements IJdwpArrayDelegate {
    private final AllDelegates delegates;

    public JdwpArrayDelegate(AllDelegates delegates) {
        this.delegates = delegates;
    }

    @Override
    public int jdwpArrayLength(long arrayId) throws DebuggerException {
        VmArrayInstance instance;
        try {
            instance = (VmArrayInstance)this.delegates.state().referenceRefIdHolder().instanceById(arrayId);
        }
        catch (ClassCastException e) {
            throw new DebuggerException(508);
        }
        if (instance == null) {
            throw new DebuggerException(20);
        }
        return instance.length();
    }

    @Override
    public void jdwpArrayGetValue(long arrayId, int index, int length, ByteBufferPacket writer) throws DebuggerException {
        ByteBufferReader reader;
        ValueManipulator manipulator;
        VmArrayInstance instance;
        try {
            instance = (VmArrayInstance)this.delegates.state().referenceRefIdHolder().instanceById(arrayId);
        }
        catch (ClassCastException e) {
            throw new DebuggerException(508);
        }
        if (index < 0 || length <= 0 || index + length > instance.length()) {
            throw new DebuggerException(504);
        }
        ClassInfo elementType = instance.elementType();
        if (elementType.isPrimitive()) {
            ClassInfoPrimitiveImpl primType = (ClassInfoPrimitiveImpl)elementType;
            manipulator = primType.manipulator();
            this.delegates.runtime().deviceMemoryReader().setAddress(instance.dataPtr() + (long)(primType.size() * index));
            reader = ByteBufferReader.wrap(this.delegates.runtime().deviceMemoryReader().readBytes(primType.size() * length));
        } else {
            int pointerSize = this.delegates.runtime().deviceMemoryReader().pointerSize();
            this.delegates.runtime().deviceMemoryReader().setAddress(instance.dataPtr() + (long)(pointerSize * index));
            reader = ByteBufferReader.wrap(this.delegates.runtime().deviceMemoryReader().readBytes(pointerSize * length), this.delegates.runtime().deviceMemoryReader().is64bit());
            manipulator = this.delegates.instances().objectManipulator();
        }
        reader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        writer.writeByte(Converter.jdwpSimpleInstanceTag(elementType));
        writer.writeInt32(length);
        if (elementType.isPrimitive()) {
            for (int idx = 0; idx < length; ++idx) {
                Object element = manipulator.readFromDevice(reader);
                manipulator.writeToDevice(writer, element);
            }
        } else {
            for (int idx = 0; idx < length; ++idx) {
                Object element = manipulator.readFromDevice(reader);
                manipulator.writeToJdwp(writer, element);
            }
        }
    }

    @Override
    public void jdwpArraySetValue(long arrayId, int index, int length, ByteBufferReader reader) throws DebuggerException {
        long destAddr;
        ValueManipulator manipulator;
        VmArrayInstance instance;
        try {
            instance = (VmArrayInstance)this.delegates.state().referenceRefIdHolder().instanceById(arrayId);
        }
        catch (ClassCastException e) {
            throw new DebuggerException(508);
        }
        if (instance == null) {
            throw new DebuggerException(20);
        }
        if (index < 0 || length <= 0 || index + length > instance.length()) {
            throw new DebuggerException(504);
        }
        ByteBufferPacket packet = this.delegates.sharedTargetPacket();
        packet.reset();
        ClassInfo elementType = instance.elementType();
        if (elementType.isPrimitive()) {
            ClassInfoPrimitiveImpl primType = (ClassInfoPrimitiveImpl)elementType;
            manipulator = primType.manipulator();
            destAddr = instance.dataPtr() + (long)(primType.size() * index);
        } else {
            destAddr = instance.dataPtr() + (long)(packet.pointerSize() * index);
            manipulator = this.delegates.instances().objectManipulator();
        }
        for (int idx = 0; idx < length; ++idx) {
            Object element = manipulator.readFromJdwp(reader);
            manipulator.writeToDevice(packet, element);
        }
        this.delegates.hooksApi().writeMemory(destAddr, packet);
    }

    public VmArrayInstance createArrayInstance(long objectPtr, ClassInfoArrayImpl ci) {
        int alignSize;
        long dataPtr = objectPtr + (long)(this.delegates.runtime().deviceMemoryReader().pointerSize() * 2);
        this.delegates.runtime().deviceMemoryReader().setAddress(dataPtr);
        int length = this.delegates.runtime().deviceMemoryReader().readInt32();
        dataPtr += 4L;
        if (ci.elementType().isPrimitive()) {
            alignSize = ((ClassInfoPrimitiveImpl)ci.elementType()).size();
            if (alignSize > 4) {
                alignSize = this.delegates.runtime().deviceMemoryReader().pointerSize();
            }
        } else {
            alignSize = this.delegates.runtime().deviceMemoryReader().pointerSize();
        }
        dataPtr = dataPtr + (long)alignSize - 1L & (long)(~(alignSize - 1));
        return new VmArrayInstance(objectPtr, ci, length, dataPtr);
    }

    public String readArrayString(VmArrayInstance instance, int index, int length) {
        if (!instance.elementType().isPrimitive() || !"C".equals(instance.elementType().signature())) {
            throw new DebuggerException("Wrong array element type while trying to get string from array: " + instance.elementType().signature());
        }
        if (index < 0 || length <= 0 || index + length > instance.length()) {
            throw new DebuggerException(504);
        }
        ClassInfoPrimitiveImpl primType = (ClassInfoPrimitiveImpl)instance.elementType();
        this.delegates.runtime().deviceMemoryReader().setAddress(instance.dataPtr() + (long)(primType.size() * index));
        byte[] bytes = this.delegates.runtime().deviceMemoryReader().readBytes(primType.size() * length);
        return new String(bytes, Charset.forName("UTF-16LE"));
    }

    @Override
    public long jdwpArrayCreateInstance(long arrayTypeId, int length) {
        HooksCmdResponse res;
        ClassInfoArrayImpl classInfoArray = (ClassInfoArrayImpl)this.delegates.state().classInfoLoader().classInfoByRefId(arrayTypeId);
        if (classInfoArray == null) {
            throw new DebuggerException(21);
        }
        VmThread thread = this.delegates.threads().anySuspendedThread();
        if (thread == null) {
            throw new DebuggerException(113);
        }
        String elementTypeSignature = classInfoArray.elementType().signature();
        if (classInfoArray.elementType().isClass()) {
            elementTypeSignature = elementTypeSignature.substring(1, elementTypeSignature.length() - 1);
        }
        if ((res = this.delegates.hooksApi().newArray(thread.threadPtr(), length, elementTypeSignature)).exceptionPrt() != 0L || res.result() == null) {
            throw new DebuggerException(113);
        }
        VmArrayInstance arrayInstance = (VmArrayInstance)this.delegates.instances().instanceByPointer((Long)res.result(), classInfoArray, null, true);
        return arrayInstance.refId();
    }
}

