/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.hooks.unitls;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robovm.debugger.hooks.IHooksApi;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class TargetByteBufferReader
extends ByteBufferReader {
    private final IHooksApi hooksApi;
    private long address;

    public TargetByteBufferReader(IHooksApi api, boolean is64bit) {
        super(null, is64bit);
        this.hooksApi = api;
    }

    @Override
    protected void expects(int bytes) {
        if (this.byteBuffer == null || this.byteBuffer.limit() < bytes) {
            this.byteBuffer = ByteBuffer.allocate((int)((double)bytes * 1.5));
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.byteBuffer.position(0);
        byte[] buff = this.hooksApi.readMemory(this.address, bytes);
        this.byteBuffer.put(buff);
        this.address += (long)bytes;
        this.byteBuffer.position(0);
    }

    public void setAddress(long addr) {
        this.address = addr;
    }

    public String readStringZAtPtr(long addr) {
        return this.hooksApi.readCString(addr);
    }

    @Override
    public void skip(int bytesToSkip) {
        this.address += (long)bytesToSkip;
    }

    @Override
    public int position() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int byteBufferDataStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int absolutePosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasRemaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int bytesRemaining() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringZ() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringZ(int at) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readString(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readStringWithLen() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] readBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpToOutputStream(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByteOrder(ByteOrder order) {
        super.setByteOrder(order);
    }

    @Override
    public ByteBufferReader sliceAt(int pos, int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBufferReader slice(int offest, int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBufferReader slice(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBufferReader slice() {
        throw new UnsupportedOperationException();
    }
}

