/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.classobjectreference;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.instances.VmClassInstance;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpClassObjRefReflectedTypeHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpClassObjRefReflectedTypeHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long classObjectId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            try {
                VmClassInstance classInstance = (VmClassInstance)this.state.referenceRefIdHolder().instanceById(classObjectId);
                if (classInstance == null) {
                    return 20;
                }
                ClassInfo classInfo = classInstance.representedClassInfo();
                output.writeByte(Converter.jdwpTypeTag(classInfo));
                output.writeLong(classInfo.refId());
            }
            catch (ClassCastException e) {
                return 20;
            }
            catch (DebuggerException e) {
                if (e.getCode() < 0) {
                    throw e;
                }
                return (short)e.getCode();
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 17;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "Method(17).ReflectedType(1)";
    }
}

