/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.vm;

import java.util.List;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpVmAllThreadsHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpVmAllThreadsHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            List<VmThread> threads = this.state.threads();
            output.writeInt32(threads.size());
            for (VmThread thread : threads) {
                output.writeLong(thread.refId());
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 1;
    }

    @Override
    public byte getCommand() {
        return 4;
    }

    public String toString() {
        return "VirtualMachine(1).AllThreads(4)";
    }
}

