/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.vm;

import java.util.HashSet;
import java.util.List;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.state.instances.VmThreadGroup;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpVmTopLevelThreadGroupsHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpVmTopLevelThreadGroupsHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            output.writeInt32(0);
            List<VmThread> threads = this.state.threads();
            HashSet<Long> reportedGroups = new HashSet<Long>();
            for (VmThread thread : threads) {
                VmThreadGroup group = thread.threadGroup();
                if (group.parent() != null || reportedGroups.contains(group.refId())) continue;
                reportedGroups.add(group.refId());
                output.writeLong(group.refId());
            }
            output.setPosition(0);
            output.writeInt32(reportedGroups.size());
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 1;
    }

    @Override
    public byte getCommand() {
        return 5;
    }

    public String toString() {
        return "VirtualMachine(1).TopLevelThreadGroups(5)";
    }
}

