/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.instances;

import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.instances.VmInstance;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThreadGroup;

public class VmThread
extends VmInstance {
    private final long threadPtr;
    private final String name;
    private final VmThreadGroup threadGroup;
    private Status status;
    private int suspendCount;
    private VmStackTrace[] stack;

    public VmThread(long objectPtr, long threadPtr, ClassInfo classInfo, String name, VmThreadGroup threadGroup) {
        super(objectPtr, classInfo);
        this.threadPtr = threadPtr;
        this.name = name;
        this.threadGroup = threadGroup;
        this.status = Status.RUNNING;
    }

    public int suspendCount() {
        return this.suspendCount;
    }

    public int markSuspended() {
        ++this.suspendCount;
        return this.suspendCount;
    }

    public int markResumed() {
        if (this.suspendCount > 0) {
            --this.suspendCount;
            return this.suspendCount;
        }
        return -1;
    }

    public String name() {
        return this.name;
    }

    public VmThreadGroup threadGroup() {
        return this.threadGroup;
    }

    public long threadPtr() {
        return this.threadPtr;
    }

    public VmStackTrace[] stack() {
        return this.stack;
    }

    public void setStack(VmStackTrace[] stack) {
        this.stack = stack;
    }

    public Status status() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "thread (" + this.refId() + ", " + this.name + ", " + this.threadGroup.name() + ")";
    }

    public static enum Status {
        SUPENDED,
        RUNNING;

    }
}

